/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.source;

import java.io.Serializable;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.util.Preconditions;
import org.apache.iceberg.Schema;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.flink.FlinkConfigOptions;
import org.apache.iceberg.flink.source.StreamingStartingStrategy;

@Internal
public class ScanContext
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final ConfigOption<Long> SNAPSHOT_ID = ConfigOptions.key((String)"snapshot-id").longType().defaultValue(null);
    private static final ConfigOption<Boolean> CASE_SENSITIVE = ConfigOptions.key((String)"case-sensitive").booleanType().defaultValue((Object)false);
    private static final ConfigOption<Long> AS_OF_TIMESTAMP = ConfigOptions.key((String)"as-of-timestamp").longType().defaultValue(null);
    private static final ConfigOption<StreamingStartingStrategy> STARTING_STRATEGY = ConfigOptions.key((String)"starting-strategy").enumType(StreamingStartingStrategy.class).defaultValue((Object)StreamingStartingStrategy.INCREMENTAL_FROM_LATEST_SNAPSHOT);
    private static final ConfigOption<Long> START_SNAPSHOT_TIMESTAMP = ConfigOptions.key((String)"start-snapshot-timestamp").longType().defaultValue(null);
    private static final ConfigOption<Long> START_SNAPSHOT_ID = ConfigOptions.key((String)"start-snapshot-id").longType().defaultValue(null);
    private static final ConfigOption<Long> END_SNAPSHOT_ID = ConfigOptions.key((String)"end-snapshot-id").longType().defaultValue(null);
    private static final ConfigOption<Long> SPLIT_SIZE = ConfigOptions.key((String)"split-size").longType().defaultValue(null);
    private static final ConfigOption<Integer> SPLIT_LOOKBACK = ConfigOptions.key((String)"split-lookback").intType().defaultValue(null);
    private static final ConfigOption<Long> SPLIT_FILE_OPEN_COST = ConfigOptions.key((String)"split-file-open-cost").longType().defaultValue(null);
    private static final ConfigOption<Boolean> STREAMING = ConfigOptions.key((String)"streaming").booleanType().defaultValue((Object)false);
    private static final ConfigOption<Duration> MONITOR_INTERVAL = ConfigOptions.key((String)"monitor-interval").durationType().defaultValue((Object)Duration.ofSeconds(10L));
    private static final ConfigOption<Boolean> INCLUDE_COLUMN_STATS = ConfigOptions.key((String)"include-column-stats").booleanType().defaultValue((Object)false);
    private static final ConfigOption<Integer> MAX_PLANNING_SNAPSHOT_COUNT = ConfigOptions.key((String)"max-planning-snapshot-count").intType().defaultValue((Object)Integer.MAX_VALUE);
    private final boolean caseSensitive;
    private final boolean exposeLocality;
    private final Long snapshotId;
    private final StreamingStartingStrategy startingStrategy;
    private final Long startSnapshotId;
    private final Long startSnapshotTimestamp;
    private final Long endSnapshotId;
    private final Long asOfTimestamp;
    private final Long splitSize;
    private final Integer splitLookback;
    private final Long splitOpenFileCost;
    private final boolean isStreaming;
    private final Duration monitorInterval;
    private final String nameMapping;
    private final Schema schema;
    private final List<Expression> filters;
    private final long limit;
    private final boolean includeColumnStats;
    private final Integer planParallelism;
    private final int maxPlanningSnapshotCount;

    private ScanContext(boolean caseSensitive, Long snapshotId, StreamingStartingStrategy startingStrategy, Long startSnapshotTimestamp, Long startSnapshotId, Long endSnapshotId, Long asOfTimestamp, Long splitSize, Integer splitLookback, Long splitOpenFileCost, boolean isStreaming, Duration monitorInterval, String nameMapping, Schema schema, List<Expression> filters, long limit, boolean includeColumnStats, boolean exposeLocality, Integer planParallelism, int maxPlanningSnapshotCount) {
        this.caseSensitive = caseSensitive;
        this.snapshotId = snapshotId;
        this.startingStrategy = startingStrategy;
        this.startSnapshotTimestamp = startSnapshotTimestamp;
        this.startSnapshotId = startSnapshotId;
        this.endSnapshotId = endSnapshotId;
        this.asOfTimestamp = asOfTimestamp;
        this.splitSize = splitSize;
        this.splitLookback = splitLookback;
        this.splitOpenFileCost = splitOpenFileCost;
        this.isStreaming = isStreaming;
        this.monitorInterval = monitorInterval;
        this.nameMapping = nameMapping;
        this.schema = schema;
        this.filters = filters;
        this.limit = limit;
        this.includeColumnStats = includeColumnStats;
        this.exposeLocality = exposeLocality;
        this.planParallelism = planParallelism;
        this.maxPlanningSnapshotCount = maxPlanningSnapshotCount;
        this.validate();
    }

    private void validate() {
        if (this.isStreaming) {
            if (this.startingStrategy == StreamingStartingStrategy.INCREMENTAL_FROM_SNAPSHOT_ID) {
                Preconditions.checkArgument((this.startSnapshotId != null ? 1 : 0) != 0, (Object)"Invalid starting snapshot id for SPECIFIC_START_SNAPSHOT_ID strategy: null");
                Preconditions.checkArgument((this.startSnapshotTimestamp == null ? 1 : 0) != 0, (Object)"Invalid starting snapshot timestamp for SPECIFIC_START_SNAPSHOT_ID strategy: not null");
            }
            if (this.startingStrategy == StreamingStartingStrategy.INCREMENTAL_FROM_SNAPSHOT_TIMESTAMP) {
                Preconditions.checkArgument((this.startSnapshotTimestamp != null ? 1 : 0) != 0, (Object)"Invalid starting snapshot timestamp for SPECIFIC_START_SNAPSHOT_TIMESTAMP strategy: null");
                Preconditions.checkArgument((this.startSnapshotId == null ? 1 : 0) != 0, (Object)"Invalid starting snapshot id for SPECIFIC_START_SNAPSHOT_ID strategy: not null");
            }
        }
    }

    public boolean caseSensitive() {
        return this.caseSensitive;
    }

    public Long snapshotId() {
        return this.snapshotId;
    }

    public StreamingStartingStrategy streamingStartingStrategy() {
        return this.startingStrategy;
    }

    public Long startSnapshotTimestamp() {
        return this.startSnapshotTimestamp;
    }

    public Long startSnapshotId() {
        return this.startSnapshotId;
    }

    public Long endSnapshotId() {
        return this.endSnapshotId;
    }

    public Long asOfTimestamp() {
        return this.asOfTimestamp;
    }

    public Long splitSize() {
        return this.splitSize;
    }

    public Integer splitLookback() {
        return this.splitLookback;
    }

    public Long splitOpenFileCost() {
        return this.splitOpenFileCost;
    }

    public boolean isStreaming() {
        return this.isStreaming;
    }

    public Duration monitorInterval() {
        return this.monitorInterval;
    }

    public String nameMapping() {
        return this.nameMapping;
    }

    public Schema project() {
        return this.schema;
    }

    public List<Expression> filters() {
        return this.filters;
    }

    public long limit() {
        return this.limit;
    }

    public boolean includeColumnStats() {
        return this.includeColumnStats;
    }

    public boolean exposeLocality() {
        return this.exposeLocality;
    }

    public Integer planParallelism() {
        return this.planParallelism;
    }

    public int maxPlanningSnapshotCount() {
        return this.maxPlanningSnapshotCount;
    }

    public ScanContext copyWithAppendsBetween(Long newStartSnapshotId, long newEndSnapshotId) {
        return ScanContext.builder().caseSensitive(this.caseSensitive).useSnapshotId(null).startSnapshotId(newStartSnapshotId).endSnapshotId(newEndSnapshotId).asOfTimestamp(null).splitSize(this.splitSize).splitLookback(this.splitLookback).splitOpenFileCost(this.splitOpenFileCost).streaming(this.isStreaming).monitorInterval(this.monitorInterval).nameMapping(this.nameMapping).project(this.schema).filters(this.filters).limit(this.limit).includeColumnStats(this.includeColumnStats).exposeLocality(this.exposeLocality).planParallelism(this.planParallelism).maxPlanningSnapshotCount(this.maxPlanningSnapshotCount).build();
    }

    public ScanContext copyWithSnapshotId(long newSnapshotId) {
        return ScanContext.builder().caseSensitive(this.caseSensitive).useSnapshotId(newSnapshotId).startSnapshotId(null).endSnapshotId(null).asOfTimestamp(null).splitSize(this.splitSize).splitLookback(this.splitLookback).splitOpenFileCost(this.splitOpenFileCost).streaming(this.isStreaming).monitorInterval(this.monitorInterval).nameMapping(this.nameMapping).project(this.schema).filters(this.filters).limit(this.limit).includeColumnStats(this.includeColumnStats).exposeLocality(this.exposeLocality).planParallelism(this.planParallelism).maxPlanningSnapshotCount(this.maxPlanningSnapshotCount).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private boolean caseSensitive = (Boolean)ScanContext.access$100().defaultValue();
        private Long snapshotId = (Long)ScanContext.access$200().defaultValue();
        private StreamingStartingStrategy startingStrategy = (StreamingStartingStrategy)((Object)ScanContext.access$300().defaultValue());
        private Long startSnapshotTimestamp = (Long)ScanContext.access$400().defaultValue();
        private Long startSnapshotId = (Long)ScanContext.access$500().defaultValue();
        private Long endSnapshotId = (Long)ScanContext.access$600().defaultValue();
        private Long asOfTimestamp = (Long)ScanContext.access$700().defaultValue();
        private Long splitSize = (Long)ScanContext.access$800().defaultValue();
        private Integer splitLookback = (Integer)ScanContext.access$900().defaultValue();
        private Long splitOpenFileCost = (Long)ScanContext.access$1000().defaultValue();
        private boolean isStreaming = (Boolean)ScanContext.access$1100().defaultValue();
        private Duration monitorInterval = (Duration)ScanContext.access$1200().defaultValue();
        private String nameMapping;
        private Schema projectedSchema;
        private List<Expression> filters;
        private long limit = -1L;
        private boolean includeColumnStats = (Boolean)ScanContext.access$1300().defaultValue();
        private boolean exposeLocality;
        private Integer planParallelism = (Integer)FlinkConfigOptions.TABLE_EXEC_ICEBERG_WORKER_POOL_SIZE.defaultValue();
        private int maxPlanningSnapshotCount = (Integer)ScanContext.access$1400().defaultValue();

        private Builder() {
        }

        public Builder caseSensitive(boolean newCaseSensitive) {
            this.caseSensitive = newCaseSensitive;
            return this;
        }

        public Builder useSnapshotId(Long newSnapshotId) {
            this.snapshotId = newSnapshotId;
            return this;
        }

        public Builder startingStrategy(StreamingStartingStrategy newStartingStrategy) {
            this.startingStrategy = newStartingStrategy;
            return this;
        }

        public Builder startSnapshotTimestamp(Long newStartSnapshotTimestamp) {
            this.startSnapshotTimestamp = newStartSnapshotTimestamp;
            return this;
        }

        public Builder startSnapshotId(Long newStartSnapshotId) {
            this.startSnapshotId = newStartSnapshotId;
            return this;
        }

        public Builder endSnapshotId(Long newEndSnapshotId) {
            this.endSnapshotId = newEndSnapshotId;
            return this;
        }

        public Builder asOfTimestamp(Long newAsOfTimestamp) {
            this.asOfTimestamp = newAsOfTimestamp;
            return this;
        }

        public Builder splitSize(Long newSplitSize) {
            this.splitSize = newSplitSize;
            return this;
        }

        public Builder splitLookback(Integer newSplitLookback) {
            this.splitLookback = newSplitLookback;
            return this;
        }

        public Builder splitOpenFileCost(Long newSplitOpenFileCost) {
            this.splitOpenFileCost = newSplitOpenFileCost;
            return this;
        }

        public Builder streaming(boolean streaming) {
            this.isStreaming = streaming;
            return this;
        }

        public Builder monitorInterval(Duration newMonitorInterval) {
            this.monitorInterval = newMonitorInterval;
            return this;
        }

        public Builder nameMapping(String newNameMapping) {
            this.nameMapping = newNameMapping;
            return this;
        }

        public Builder project(Schema newProjectedSchema) {
            this.projectedSchema = newProjectedSchema;
            return this;
        }

        public Builder filters(List<Expression> newFilters) {
            this.filters = newFilters;
            return this;
        }

        public Builder limit(long newLimit) {
            this.limit = newLimit;
            return this;
        }

        public Builder includeColumnStats(boolean newIncludeColumnStats) {
            this.includeColumnStats = newIncludeColumnStats;
            return this;
        }

        public Builder exposeLocality(boolean newExposeLocality) {
            this.exposeLocality = newExposeLocality;
            return this;
        }

        public Builder planParallelism(Integer parallelism) {
            this.planParallelism = parallelism;
            return this;
        }

        public Builder maxPlanningSnapshotCount(int newMaxPlanningSnapshotCount) {
            this.maxPlanningSnapshotCount = newMaxPlanningSnapshotCount;
            return this;
        }

        public Builder fromProperties(Map<String, String> properties) {
            Configuration config = new Configuration();
            properties.forEach((arg_0, arg_1) -> ((Configuration)config).setString(arg_0, arg_1));
            return this.useSnapshotId((Long)config.get(SNAPSHOT_ID)).caseSensitive((Boolean)config.get(CASE_SENSITIVE)).asOfTimestamp((Long)config.get(AS_OF_TIMESTAMP)).startingStrategy((StreamingStartingStrategy)((Object)config.get(STARTING_STRATEGY))).startSnapshotTimestamp((Long)config.get(START_SNAPSHOT_TIMESTAMP)).startSnapshotId((Long)config.get(START_SNAPSHOT_ID)).endSnapshotId((Long)config.get(END_SNAPSHOT_ID)).splitSize((Long)config.get(SPLIT_SIZE)).splitLookback((Integer)config.get(SPLIT_LOOKBACK)).splitOpenFileCost((Long)config.get(SPLIT_FILE_OPEN_COST)).streaming((Boolean)config.get(STREAMING)).monitorInterval((Duration)config.get(MONITOR_INTERVAL)).nameMapping(properties.get("schema.name-mapping.default")).includeColumnStats((Boolean)config.get(INCLUDE_COLUMN_STATS)).maxPlanningSnapshotCount((Integer)config.get(MAX_PLANNING_SNAPSHOT_COUNT));
        }

        public ScanContext build() {
            return new ScanContext(this.caseSensitive, this.snapshotId, this.startingStrategy, this.startSnapshotTimestamp, this.startSnapshotId, this.endSnapshotId, this.asOfTimestamp, this.splitSize, this.splitLookback, this.splitOpenFileCost, this.isStreaming, this.monitorInterval, this.nameMapping, this.projectedSchema, this.filters, this.limit, this.includeColumnStats, this.exposeLocality, this.planParallelism, this.maxPlanningSnapshotCount);
        }
    }
}

