/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.source;

import java.io.IOException;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.Table;
import org.apache.iceberg.flink.FlinkConfigOptions;
import org.apache.iceberg.hadoop.HadoopFileIO;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SourceUtil {
    private static final Logger LOG = LoggerFactory.getLogger(SourceUtil.class);
    private static final Set<String> FILE_SYSTEM_SUPPORT_LOCALITY = ImmutableSet.of("hdfs");

    private SourceUtil() {
    }

    static boolean isLocalityEnabled(Table table, ReadableConfig readableConfig, Boolean exposeLocality) {
        Boolean localityEnabled;
        Boolean bl = localityEnabled = exposeLocality != null ? exposeLocality : (Boolean)readableConfig.get(FlinkConfigOptions.TABLE_EXEC_ICEBERG_EXPOSE_SPLIT_LOCALITY_INFO);
        if (localityEnabled != null && !localityEnabled.booleanValue()) {
            return false;
        }
        FileIO fileIO = table.io();
        if (fileIO instanceof HadoopFileIO) {
            HadoopFileIO hadoopFileIO = (HadoopFileIO)fileIO;
            try {
                String scheme = new Path(table.location()).getFileSystem(hadoopFileIO.getConf()).getScheme();
                return FILE_SYSTEM_SUPPORT_LOCALITY.contains(scheme);
            }
            catch (IOException e) {
                LOG.warn("Failed to determine whether the locality information can be exposed for table: {}", (Object)table, (Object)e);
            }
        }
        return false;
    }

    static int inferParallelism(ReadableConfig readableConfig, long limitCount, Supplier<Integer> splitCountProvider) {
        int parallelism = (Integer)readableConfig.get(ExecutionConfigOptions.TABLE_EXEC_RESOURCE_DEFAULT_PARALLELISM);
        if (((Boolean)readableConfig.get(FlinkConfigOptions.TABLE_EXEC_ICEBERG_INFER_SOURCE_PARALLELISM)).booleanValue()) {
            int maxInferParallelism = (Integer)readableConfig.get(FlinkConfigOptions.TABLE_EXEC_ICEBERG_INFER_SOURCE_PARALLELISM_MAX);
            Preconditions.checkState(maxInferParallelism >= 1, FlinkConfigOptions.TABLE_EXEC_ICEBERG_INFER_SOURCE_PARALLELISM_MAX.key() + " cannot be less than 1");
            parallelism = Math.min(splitCountProvider.get(), maxInferParallelism);
        }
        if (limitCount > 0L) {
            int limit = limitCount >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)limitCount;
            parallelism = Math.min(parallelism, limit);
        }
        parallelism = Math.max(1, parallelism);
        return parallelism;
    }
}

