/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.source.enumerator;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.flink.annotation.Internal;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.apache.flink.core.memory.DataOutputSerializer;
import org.apache.iceberg.flink.source.enumerator.IcebergEnumeratorPosition;
import org.apache.iceberg.flink.source.enumerator.IcebergEnumeratorPositionSerializer;
import org.apache.iceberg.flink.source.enumerator.IcebergEnumeratorState;
import org.apache.iceberg.flink.source.split.IcebergSourceSplit;
import org.apache.iceberg.flink.source.split.IcebergSourceSplitSerializer;
import org.apache.iceberg.flink.source.split.IcebergSourceSplitState;
import org.apache.iceberg.flink.source.split.IcebergSourceSplitStatus;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;

@Internal
public class IcebergEnumeratorStateSerializer
implements SimpleVersionedSerializer<IcebergEnumeratorState> {
    public static final IcebergEnumeratorStateSerializer INSTANCE = new IcebergEnumeratorStateSerializer();
    private static final int VERSION = 1;
    private static final ThreadLocal<DataOutputSerializer> SERIALIZER_CACHE = ThreadLocal.withInitial(() -> new DataOutputSerializer(1024));
    private final IcebergEnumeratorPositionSerializer positionSerializer = IcebergEnumeratorPositionSerializer.INSTANCE;
    private final IcebergSourceSplitSerializer splitSerializer = IcebergSourceSplitSerializer.INSTANCE;

    public int getVersion() {
        return 1;
    }

    public byte[] serialize(IcebergEnumeratorState enumState) throws IOException {
        return this.serializeV1(enumState);
    }

    public IcebergEnumeratorState deserialize(int version, byte[] serialized) throws IOException {
        switch (version) {
            case 1: {
                return this.deserializeV1(serialized);
            }
        }
        throw new IOException("Unknown version: " + version);
    }

    private byte[] serializeV1(IcebergEnumeratorState enumState) throws IOException {
        Object positionBytes;
        DataOutputSerializer out = SERIALIZER_CACHE.get();
        out.writeBoolean(enumState.lastEnumeratedPosition() != null);
        if (enumState.lastEnumeratedPosition() != null) {
            out.writeInt(this.positionSerializer.getVersion());
            positionBytes = this.positionSerializer.serialize(enumState.lastEnumeratedPosition());
            out.writeInt(((byte[])positionBytes).length);
            out.write((byte[])positionBytes);
        }
        out.writeInt(this.splitSerializer.getVersion());
        out.writeInt(enumState.pendingSplits().size());
        positionBytes = enumState.pendingSplits().iterator();
        while (positionBytes.hasNext()) {
            IcebergSourceSplitState splitState = (IcebergSourceSplitState)positionBytes.next();
            byte[] splitBytes = this.splitSerializer.serialize(splitState.split());
            out.writeInt(splitBytes.length);
            out.write(splitBytes);
            out.writeUTF(splitState.status().name());
        }
        byte[] result = out.getCopyOfBuffer();
        out.clear();
        return result;
    }

    private IcebergEnumeratorState deserializeV1(byte[] serialized) throws IOException {
        DataInputDeserializer in = new DataInputDeserializer(serialized);
        IcebergEnumeratorPosition enumeratorPosition = null;
        if (in.readBoolean()) {
            int version = in.readInt();
            byte[] positionBytes = new byte[in.readInt()];
            in.read(positionBytes);
            enumeratorPosition = this.positionSerializer.deserialize(version, positionBytes);
        }
        int splitSerializerVersion = in.readInt();
        int splitCount = in.readInt();
        ArrayList<IcebergSourceSplitState> pendingSplits = Lists.newArrayListWithCapacity(splitCount);
        for (int i = 0; i < splitCount; ++i) {
            byte[] splitBytes = new byte[in.readInt()];
            in.read(splitBytes);
            IcebergSourceSplit split = this.splitSerializer.deserialize(splitSerializerVersion, splitBytes);
            String statusName = in.readUTF();
            pendingSplits.add(new IcebergSourceSplitState(split, IcebergSourceSplitStatus.valueOf(statusName)));
        }
        return new IcebergEnumeratorState(enumeratorPosition, pendingSplits);
    }
}

