/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.source.reader;

import java.util.Collections;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.connector.base.source.reader.RecordsWithSplitIds;
import org.apache.flink.connector.file.src.util.Pool;
import org.apache.iceberg.flink.source.reader.RecordAndPosition;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;

class ArrayBatchRecords<T>
implements RecordsWithSplitIds<RecordAndPosition<T>> {
    @Nullable
    private String splitId;
    @Nullable
    private final Pool.Recycler<T[]> recycler;
    @Nullable
    private final T[] records;
    private final int numberOfRecords;
    private final Set<String> finishedSplits;
    private final RecordAndPosition<T> recordAndPosition;
    private int position;

    private ArrayBatchRecords(@Nullable String splitId, @Nullable Pool.Recycler<T[]> recycler, @Nullable T[] records, int numberOfRecords, int fileOffset, long startingRecordOffset, Set<String> finishedSplits) {
        Preconditions.checkArgument(numberOfRecords >= 0, "numberOfRecords can't be negative");
        Preconditions.checkArgument(fileOffset >= 0, "fileOffset can't be negative");
        Preconditions.checkArgument(startingRecordOffset >= 0L, "numberOfRecords can't be negative");
        this.splitId = splitId;
        this.recycler = recycler;
        this.records = records;
        this.numberOfRecords = numberOfRecords;
        this.finishedSplits = Preconditions.checkNotNull(finishedSplits, "finishedSplits can be empty but not null");
        this.recordAndPosition = new RecordAndPosition();
        this.recordAndPosition.set(null, fileOffset, startingRecordOffset);
        this.position = 0;
    }

    @Nullable
    public String nextSplit() {
        String nextSplit = this.splitId;
        this.splitId = null;
        return nextSplit;
    }

    @Nullable
    public RecordAndPosition<T> nextRecordFromSplit() {
        if (this.position < this.numberOfRecords) {
            this.recordAndPosition.record(this.records[this.position]);
            ++this.position;
            return this.recordAndPosition;
        }
        return null;
    }

    public void recycle() {
        if (this.recycler != null) {
            this.recycler.recycle(this.records);
        }
    }

    public Set<String> finishedSplits() {
        return this.finishedSplits;
    }

    @VisibleForTesting
    T[] records() {
        return this.records;
    }

    @VisibleForTesting
    int numberOfRecords() {
        return this.numberOfRecords;
    }

    public static <T> ArrayBatchRecords<T> forRecords(String splitId, Pool.Recycler<T[]> recycler, T[] records, int numberOfRecords, int fileOffset, long startingRecordOffset) {
        return new ArrayBatchRecords<T>(splitId, recycler, records, numberOfRecords, fileOffset, startingRecordOffset, Collections.emptySet());
    }

    public static <T> ArrayBatchRecords<T> finishedSplit(String splitId) {
        return new ArrayBatchRecords<T>(null, null, null, 0, 0, 0L, Collections.singleton(splitId));
    }
}

