/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.io;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.io.CloseableGroup;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.iceberg.io.FilterIterator;
import org.apache.iceberg.metrics.Counter;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;

public interface CloseableIterable<T>
extends Iterable<T>,
Closeable {
    @Override
    public CloseableIterator<T> iterator();

    public static <E> CloseableIterable<E> withNoopClose(E entry) {
        return CloseableIterable.withNoopClose(ImmutableList.of(entry));
    }

    public static <E> CloseableIterable<E> withNoopClose(final Iterable<E> iterable) {
        return new CloseableIterable<E>(){

            @Override
            public void close() {
            }

            @Override
            public CloseableIterator<E> iterator() {
                return CloseableIterator.withClose(iterable.iterator());
            }
        };
    }

    public static <E> CloseableIterable<E> empty() {
        return CloseableIterable.withNoopClose(Collections.emptyList());
    }

    public static <E> CloseableIterable<E> combine(final Iterable<E> iterable, final Closeable closeable) {
        return new CloseableIterable<E>(){

            @Override
            public void close() throws IOException {
                closeable.close();
            }

            @Override
            public CloseableIterator<E> iterator() {
                return CloseableIterator.withClose(iterable.iterator());
            }
        };
    }

    public static <E> CloseableIterable<E> whenComplete(final CloseableIterable<E> iterable, final Runnable onCompletionRunnable) {
        Preconditions.checkNotNull(onCompletionRunnable, "Invalid runnable: null");
        return new CloseableIterable<E>(){

            @Override
            public void close() throws IOException {
                try {
                    iterable.close();
                }
                finally {
                    onCompletionRunnable.run();
                }
            }

            @Override
            public CloseableIterator<E> iterator() {
                return iterable.iterator();
            }
        };
    }

    public static <E> CloseableIterable<E> filter(CloseableIterable<E> iterable, final Predicate<E> pred) {
        return CloseableIterable.combine(() -> new FilterIterator<E>(iterable.iterator()){

            @Override
            protected boolean shouldKeep(E item) {
                return pred.test(item);
            }
        }, iterable);
    }

    public static <E> CloseableIterable<E> filter(final Counter skipCounter, CloseableIterable<E> iterable, final Predicate<E> pred) {
        Preconditions.checkArgument(null != skipCounter, "Invalid counter: null");
        Preconditions.checkArgument(null != iterable, "Invalid iterable: null");
        Preconditions.checkArgument(null != pred, "Invalid predicate: null");
        return CloseableIterable.combine(() -> new FilterIterator<E>(iterable.iterator()){

            @Override
            protected boolean shouldKeep(E item) {
                boolean matches = pred.test(item);
                if (!matches) {
                    skipCounter.increment();
                }
                return matches;
            }
        }, iterable);
    }

    public static <T> CloseableIterable<T> count(final Counter counter, final CloseableIterable<T> iterable) {
        Preconditions.checkArgument(null != counter, "Invalid counter: null");
        Preconditions.checkArgument(null != iterable, "Invalid iterable: null");
        return new CloseableIterable<T>(){

            @Override
            public CloseableIterator<T> iterator() {
                return CloseableIterator.count(counter, iterable.iterator());
            }

            @Override
            public void close() throws IOException {
                iterable.close();
            }
        };
    }

    public static <I, O> CloseableIterable<O> transform(final CloseableIterable<I> iterable, final Function<I, O> transform) {
        Preconditions.checkNotNull(transform, "Invalid transform: null");
        return new CloseableIterable<O>(){

            @Override
            public void close() throws IOException {
                iterable.close();
            }

            @Override
            public CloseableIterator<O> iterator() {
                return new CloseableIterator<O>(){
                    private final CloseableIterator<I> inner;
                    {
                        this.inner = iterable.iterator();
                    }

                    @Override
                    public void close() throws IOException {
                        this.inner.close();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.inner.hasNext();
                    }

                    @Override
                    public O next() {
                        return transform.apply(this.inner.next());
                    }
                };
            }
        };
    }

    public static <E> CloseableIterable<E> concat(Iterable<CloseableIterable<E>> iterable) {
        return new ConcatCloseableIterable<E>(iterable);
    }

    public static class ConcatCloseableIterable<E>
    extends CloseableGroup
    implements CloseableIterable<E> {
        private final Iterable<CloseableIterable<E>> inputs;

        ConcatCloseableIterable(Iterable<CloseableIterable<E>> inputs) {
            this.inputs = inputs;
        }

        @Override
        public CloseableIterator<E> iterator() {
            ConcatCloseableIterator iter = new ConcatCloseableIterator(this.inputs);
            this.addCloseable(iter);
            return iter;
        }

        private static class ConcatCloseableIterator<E>
        implements CloseableIterator<E> {
            private final Iterator<CloseableIterable<E>> iterables;
            private CloseableIterable<E> currentIterable = null;
            private Iterator<E> currentIterator = null;
            private boolean closed = false;

            private ConcatCloseableIterator(Iterable<CloseableIterable<E>> inputs) {
                this.iterables = inputs.iterator();
            }

            @Override
            public boolean hasNext() {
                if (this.closed) {
                    return false;
                }
                if (null != this.currentIterator && this.currentIterator.hasNext()) {
                    return true;
                }
                while (this.iterables.hasNext()) {
                    try {
                        if (null != this.currentIterable) {
                            this.currentIterable.close();
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeIOException(e, "Failed to close iterable", new Object[0]);
                    }
                    this.currentIterable = this.iterables.next();
                    this.currentIterator = this.currentIterable.iterator();
                    if (!this.currentIterator.hasNext()) continue;
                    return true;
                }
                try {
                    if (null != this.currentIterable) {
                        this.currentIterable.close();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeIOException(e, "Failed to close iterable", new Object[0]);
                }
                this.closed = true;
                this.currentIterator = null;
                this.currentIterable = null;
                return false;
            }

            @Override
            public void close() throws IOException {
                if (!this.closed) {
                    this.currentIterable.close();
                    this.closed = true;
                    this.currentIterator = null;
                    this.currentIterable = null;
                }
            }

            @Override
            public E next() {
                if (this.hasNext()) {
                    return this.currentIterator.next();
                }
                throw new NoSuchElementException();
            }
        }
    }
}

