/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.shaded.org.apache.parquet.hadoop;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.CRC32;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.shaded.org.apache.parquet.Preconditions;
import org.apache.iceberg.shaded.org.apache.parquet.bytes.BytesInput;
import org.apache.iceberg.shaded.org.apache.parquet.bytes.BytesUtils;
import org.apache.iceberg.shaded.org.apache.parquet.column.ColumnDescriptor;
import org.apache.iceberg.shaded.org.apache.parquet.column.Encoding;
import org.apache.iceberg.shaded.org.apache.parquet.column.EncodingStats;
import org.apache.iceberg.shaded.org.apache.parquet.column.page.DictionaryPage;
import org.apache.iceberg.shaded.org.apache.parquet.column.statistics.Statistics;
import org.apache.iceberg.shaded.org.apache.parquet.column.values.bloomfilter.BloomFilter;
import org.apache.iceberg.shaded.org.apache.parquet.crypto.AesCipher;
import org.apache.iceberg.shaded.org.apache.parquet.crypto.ColumnEncryptionProperties;
import org.apache.iceberg.shaded.org.apache.parquet.crypto.FileEncryptionProperties;
import org.apache.iceberg.shaded.org.apache.parquet.crypto.InternalColumnEncryptionSetup;
import org.apache.iceberg.shaded.org.apache.parquet.crypto.InternalFileEncryptor;
import org.apache.iceberg.shaded.org.apache.parquet.crypto.ModuleCipherFactory;
import org.apache.iceberg.shaded.org.apache.parquet.crypto.ParquetCryptoRuntimeException;
import org.apache.iceberg.shaded.org.apache.parquet.format.BlockCipher;
import org.apache.iceberg.shaded.org.apache.parquet.format.ColumnIndex;
import org.apache.iceberg.shaded.org.apache.parquet.format.Util;
import org.apache.iceberg.shaded.org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.iceberg.shaded.org.apache.parquet.hadoop.Footer;
import org.apache.iceberg.shaded.org.apache.parquet.hadoop.Offsets;
import org.apache.iceberg.shaded.org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.iceberg.shaded.org.apache.parquet.hadoop.ParquetOutputFormat;
import org.apache.iceberg.shaded.org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.iceberg.shaded.org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.iceberg.shaded.org.apache.parquet.hadoop.metadata.ColumnPath;
import org.apache.iceberg.shaded.org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.iceberg.shaded.org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.iceberg.shaded.org.apache.parquet.hadoop.metadata.GlobalMetaData;
import org.apache.iceberg.shaded.org.apache.parquet.hadoop.metadata.KeyValueMetadataMergeStrategy;
import org.apache.iceberg.shaded.org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.iceberg.shaded.org.apache.parquet.hadoop.metadata.StrictKeyValueMetadataMergeStrategy;
import org.apache.iceberg.shaded.org.apache.parquet.hadoop.util.HadoopOutputFile;
import org.apache.iceberg.shaded.org.apache.parquet.hadoop.util.HadoopStreams;
import org.apache.iceberg.shaded.org.apache.parquet.internal.column.columnindex.ColumnIndexBuilder;
import org.apache.iceberg.shaded.org.apache.parquet.internal.column.columnindex.OffsetIndex;
import org.apache.iceberg.shaded.org.apache.parquet.internal.column.columnindex.OffsetIndexBuilder;
import org.apache.iceberg.shaded.org.apache.parquet.internal.hadoop.metadata.IndexReference;
import org.apache.iceberg.shaded.org.apache.parquet.io.InputFile;
import org.apache.iceberg.shaded.org.apache.parquet.io.OutputFile;
import org.apache.iceberg.shaded.org.apache.parquet.io.ParquetEncodingException;
import org.apache.iceberg.shaded.org.apache.parquet.io.PositionOutputStream;
import org.apache.iceberg.shaded.org.apache.parquet.io.SeekableInputStream;
import org.apache.iceberg.shaded.org.apache.parquet.schema.MessageType;
import org.apache.iceberg.shaded.org.apache.parquet.schema.PrimitiveType;
import org.apache.iceberg.shaded.org.apache.parquet.schema.TypeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParquetFileWriter {
    private static final Logger LOG = LoggerFactory.getLogger(ParquetFileWriter.class);
    private final ParquetMetadataConverter metadataConverter;
    public static final String PARQUET_METADATA_FILE = "_metadata";
    public static final String MAGIC_STR = "PAR1";
    public static final byte[] MAGIC = "PAR1".getBytes(StandardCharsets.US_ASCII);
    public static final String EF_MAGIC_STR = "PARE";
    public static final byte[] EFMAGIC = "PARE".getBytes(StandardCharsets.US_ASCII);
    public static final String PARQUET_COMMON_METADATA_FILE = "_common_metadata";
    public static final int CURRENT_VERSION = 1;
    protected final PositionOutputStream out;
    private final MessageType schema;
    private final AlignmentStrategy alignment;
    private final int columnIndexTruncateLength;
    private List<BlockMetaData> blocks = new ArrayList<BlockMetaData>();
    private final List<List<org.apache.iceberg.shaded.org.apache.parquet.internal.column.columnindex.ColumnIndex>> columnIndexes = new ArrayList<List<org.apache.iceberg.shaded.org.apache.parquet.internal.column.columnindex.ColumnIndex>>();
    private final List<List<OffsetIndex>> offsetIndexes = new ArrayList<List<OffsetIndex>>();
    private final List<Map<String, BloomFilter>> bloomFilters = new ArrayList<Map<String, BloomFilter>>();
    private final InternalFileEncryptor fileEncryptor;
    private BlockMetaData currentBlock;
    private List<org.apache.iceberg.shaded.org.apache.parquet.internal.column.columnindex.ColumnIndex> currentColumnIndexes;
    private List<OffsetIndex> currentOffsetIndexes;
    private Map<String, BloomFilter> currentBloomFilters;
    private long currentRecordCount;
    private EncodingStats.Builder encodingStatsBuilder;
    private Set<Encoding> currentEncodings;
    private long uncompressedLength;
    private long compressedLength;
    private Statistics currentStatistics;
    private ColumnIndexBuilder columnIndexBuilder;
    private OffsetIndexBuilder offsetIndexBuilder;
    private CompressionCodecName currentChunkCodec;
    private ColumnPath currentChunkPath;
    private PrimitiveType currentChunkType;
    private long currentChunkValueCount;
    private long currentChunkFirstDataPage;
    private long currentChunkDictionaryPageOffset;
    private ParquetMetadata footer = null;
    private final CRC32 crc;
    private boolean pageWriteChecksumEnabled;
    private STATE state = STATE.NOT_STARTED;
    private static final ThreadLocal<byte[]> COPY_BUFFER = ThreadLocal.withInitial(() -> new byte[8192]);

    @Deprecated
    public ParquetFileWriter(Configuration configuration, MessageType schema, Path file) throws IOException {
        this(HadoopOutputFile.fromPath(file, configuration), schema, Mode.CREATE, 0x8000000L, 0x800000);
    }

    @Deprecated
    public ParquetFileWriter(Configuration configuration, MessageType schema, Path file, Mode mode) throws IOException {
        this(HadoopOutputFile.fromPath(file, configuration), schema, mode, 0x8000000L, 0x800000);
    }

    @Deprecated
    public ParquetFileWriter(Configuration configuration, MessageType schema, Path file, Mode mode, long rowGroupSize, int maxPaddingSize) throws IOException {
        this(HadoopOutputFile.fromPath(file, configuration), schema, mode, rowGroupSize, maxPaddingSize);
    }

    @Deprecated
    public ParquetFileWriter(OutputFile file, MessageType schema, Mode mode, long rowGroupSize, int maxPaddingSize) throws IOException {
        this(file, schema, mode, rowGroupSize, maxPaddingSize, 64, Integer.MAX_VALUE, true);
    }

    public ParquetFileWriter(OutputFile file, MessageType schema, Mode mode, long rowGroupSize, int maxPaddingSize, int columnIndexTruncateLength, int statisticsTruncateLength, boolean pageWriteChecksumEnabled) throws IOException {
        this(file, schema, mode, rowGroupSize, maxPaddingSize, columnIndexTruncateLength, statisticsTruncateLength, pageWriteChecksumEnabled, null, null);
    }

    public ParquetFileWriter(OutputFile file, MessageType schema, Mode mode, long rowGroupSize, int maxPaddingSize, int columnIndexTruncateLength, int statisticsTruncateLength, boolean pageWriteChecksumEnabled, FileEncryptionProperties encryptionProperties) throws IOException {
        this(file, schema, mode, rowGroupSize, maxPaddingSize, columnIndexTruncateLength, statisticsTruncateLength, pageWriteChecksumEnabled, encryptionProperties, null);
    }

    public ParquetFileWriter(OutputFile file, MessageType schema, Mode mode, long rowGroupSize, int maxPaddingSize, int columnIndexTruncateLength, int statisticsTruncateLength, boolean pageWriteChecksumEnabled, InternalFileEncryptor encryptor) throws IOException {
        this(file, schema, mode, rowGroupSize, maxPaddingSize, columnIndexTruncateLength, statisticsTruncateLength, pageWriteChecksumEnabled, null, encryptor);
    }

    private ParquetFileWriter(OutputFile file, MessageType schema, Mode mode, long rowGroupSize, int maxPaddingSize, int columnIndexTruncateLength, int statisticsTruncateLength, boolean pageWriteChecksumEnabled, FileEncryptionProperties encryptionProperties, InternalFileEncryptor encryptor) throws IOException {
        Map<ColumnPath, ColumnEncryptionProperties> columnEncryptionProperties;
        TypeUtil.checkValidWriteSchema(schema);
        this.schema = schema;
        long blockSize = rowGroupSize;
        if (file.supportsBlockSize()) {
            blockSize = Math.max(file.defaultBlockSize(), rowGroupSize);
            this.alignment = PaddingAlignment.get(blockSize, rowGroupSize, maxPaddingSize);
        } else {
            this.alignment = NoAlignment.get(rowGroupSize);
        }
        this.out = mode == Mode.OVERWRITE ? file.createOrOverwrite(blockSize) : file.create(blockSize);
        this.encodingStatsBuilder = new EncodingStats.Builder();
        this.columnIndexTruncateLength = columnIndexTruncateLength;
        this.pageWriteChecksumEnabled = pageWriteChecksumEnabled;
        this.crc = pageWriteChecksumEnabled ? new CRC32() : null;
        this.metadataConverter = new ParquetMetadataConverter(statisticsTruncateLength);
        if (null == encryptionProperties && null == encryptor) {
            this.fileEncryptor = null;
            return;
        }
        if (null == encryptionProperties) {
            encryptionProperties = encryptor.getEncryptionProperties();
        }
        if (null != (columnEncryptionProperties = encryptionProperties.getEncryptedColumns())) {
            for (Map.Entry<ColumnPath, ColumnEncryptionProperties> entry : columnEncryptionProperties.entrySet()) {
                Object[] path = entry.getKey().toArray();
                if (schema.containsPath((String[])path)) continue;
                throw new ParquetCryptoRuntimeException("Encrypted column " + Arrays.toString(path) + " not in file schema");
            }
        }
        this.fileEncryptor = null == encryptor ? new InternalFileEncryptor(encryptionProperties) : encryptor;
    }

    ParquetFileWriter(Configuration configuration, MessageType schema, Path file, long rowAndBlockSize, int maxPaddingSize) throws IOException {
        FileSystem fs = file.getFileSystem(configuration);
        this.schema = schema;
        this.alignment = PaddingAlignment.get(rowAndBlockSize, rowAndBlockSize, maxPaddingSize);
        this.out = HadoopStreams.wrap(fs.create(file, true, 8192, fs.getDefaultReplication(file), rowAndBlockSize));
        this.encodingStatsBuilder = new EncodingStats.Builder();
        this.columnIndexTruncateLength = Integer.MAX_VALUE;
        this.pageWriteChecksumEnabled = ParquetOutputFormat.getPageWriteChecksumEnabled(configuration);
        this.crc = this.pageWriteChecksumEnabled ? new CRC32() : null;
        this.metadataConverter = new ParquetMetadataConverter(Integer.MAX_VALUE);
        this.fileEncryptor = null;
    }

    public void start() throws IOException {
        this.state = this.state.start();
        LOG.debug("{}: start", (Object)this.out.getPos());
        byte[] magic = MAGIC;
        if (null != this.fileEncryptor && this.fileEncryptor.isFooterEncrypted()) {
            magic = EFMAGIC;
        }
        this.out.write(magic);
    }

    public InternalFileEncryptor getEncryptor() {
        return this.fileEncryptor;
    }

    public void startBlock(long recordCount) throws IOException {
        this.state = this.state.startBlock();
        LOG.debug("{}: start block", (Object)this.out.getPos());
        this.alignment.alignForRowGroup(this.out);
        this.currentBlock = new BlockMetaData();
        this.currentRecordCount = recordCount;
        this.currentColumnIndexes = new ArrayList<org.apache.iceberg.shaded.org.apache.parquet.internal.column.columnindex.ColumnIndex>();
        this.currentOffsetIndexes = new ArrayList<OffsetIndex>();
        this.currentBloomFilters = new HashMap<String, BloomFilter>();
    }

    public void startColumn(ColumnDescriptor descriptor, long valueCount, CompressionCodecName compressionCodecName) throws IOException {
        this.state = this.state.startColumn();
        this.encodingStatsBuilder.clear();
        this.currentEncodings = new HashSet<Encoding>();
        this.currentChunkPath = ColumnPath.get(descriptor.getPath());
        this.currentChunkType = descriptor.getPrimitiveType();
        this.currentChunkCodec = compressionCodecName;
        this.currentChunkValueCount = valueCount;
        this.currentChunkFirstDataPage = -1L;
        this.compressedLength = 0L;
        this.uncompressedLength = 0L;
        this.currentStatistics = null;
        this.columnIndexBuilder = ColumnIndexBuilder.getBuilder(this.currentChunkType, this.columnIndexTruncateLength);
        this.offsetIndexBuilder = OffsetIndexBuilder.getBuilder();
    }

    public void writeDictionaryPage(DictionaryPage dictionaryPage) throws IOException {
        this.writeDictionaryPage(dictionaryPage, null, null);
    }

    public void writeDictionaryPage(DictionaryPage dictionaryPage, BlockCipher.Encryptor headerBlockEncryptor, byte[] AAD) throws IOException {
        this.state = this.state.write();
        LOG.debug("{}: write dictionary page: {} values", (Object)this.out.getPos(), (Object)dictionaryPage.getDictionarySize());
        this.currentChunkDictionaryPageOffset = this.out.getPos();
        int uncompressedSize = dictionaryPage.getUncompressedSize();
        int compressedPageSize = (int)dictionaryPage.getBytes().size();
        if (this.pageWriteChecksumEnabled) {
            this.crc.reset();
            this.crc.update(dictionaryPage.getBytes().toByteArray());
            this.metadataConverter.writeDictionaryPageHeader(uncompressedSize, compressedPageSize, dictionaryPage.getDictionarySize(), dictionaryPage.getEncoding(), (int)this.crc.getValue(), this.out, headerBlockEncryptor, AAD);
        } else {
            this.metadataConverter.writeDictionaryPageHeader(uncompressedSize, compressedPageSize, dictionaryPage.getDictionarySize(), dictionaryPage.getEncoding(), this.out, headerBlockEncryptor, AAD);
        }
        long headerSize = this.out.getPos() - this.currentChunkDictionaryPageOffset;
        this.uncompressedLength += (long)uncompressedSize + headerSize;
        this.compressedLength += (long)compressedPageSize + headerSize;
        LOG.debug("{}: write dictionary page content {}", (Object)this.out.getPos(), (Object)compressedPageSize);
        dictionaryPage.getBytes().writeAllTo(this.out);
        this.encodingStatsBuilder.addDictEncoding(dictionaryPage.getEncoding());
        this.currentEncodings.add(dictionaryPage.getEncoding());
    }

    @Deprecated
    public void writeDataPage(int valueCount, int uncompressedPageSize, BytesInput bytes, Encoding rlEncoding, Encoding dlEncoding, Encoding valuesEncoding) throws IOException {
        this.state = this.state.write();
        this.offsetIndexBuilder = OffsetIndexBuilder.getNoOpBuilder();
        this.columnIndexBuilder = ColumnIndexBuilder.getNoOpBuilder();
        long beforeHeader = this.out.getPos();
        LOG.debug("{}: write data page: {} values", (Object)beforeHeader, (Object)valueCount);
        int compressedPageSize = (int)bytes.size();
        this.metadataConverter.writeDataPageV1Header(uncompressedPageSize, compressedPageSize, valueCount, rlEncoding, dlEncoding, valuesEncoding, this.out);
        long headerSize = this.out.getPos() - beforeHeader;
        this.uncompressedLength += (long)uncompressedPageSize + headerSize;
        this.compressedLength += (long)compressedPageSize + headerSize;
        LOG.debug("{}: write data page content {}", (Object)this.out.getPos(), (Object)compressedPageSize);
        bytes.writeAllTo(this.out);
        this.encodingStatsBuilder.addDataEncoding(valuesEncoding);
        this.currentEncodings.add(rlEncoding);
        this.currentEncodings.add(dlEncoding);
        this.currentEncodings.add(valuesEncoding);
        if (this.currentChunkFirstDataPage < 0L) {
            this.currentChunkFirstDataPage = beforeHeader;
        }
    }

    @Deprecated
    public void writeDataPage(int valueCount, int uncompressedPageSize, BytesInput bytes, Statistics statistics, Encoding rlEncoding, Encoding dlEncoding, Encoding valuesEncoding) throws IOException {
        this.offsetIndexBuilder = OffsetIndexBuilder.getNoOpBuilder();
        this.columnIndexBuilder = ColumnIndexBuilder.getNoOpBuilder();
        this.innerWriteDataPage(valueCount, uncompressedPageSize, bytes, statistics, rlEncoding, dlEncoding, valuesEncoding, null, null);
    }

    public void writeDataPage(int valueCount, int uncompressedPageSize, BytesInput bytes, Statistics statistics, long rowCount, Encoding rlEncoding, Encoding dlEncoding, Encoding valuesEncoding) throws IOException {
        this.writeDataPage(valueCount, uncompressedPageSize, bytes, statistics, rowCount, rlEncoding, dlEncoding, valuesEncoding, null, null);
    }

    public void writeDataPage(int valueCount, int uncompressedPageSize, BytesInput bytes, Statistics statistics, long rowCount, Encoding rlEncoding, Encoding dlEncoding, Encoding valuesEncoding, BlockCipher.Encryptor metadataBlockEncryptor, byte[] pageHeaderAAD) throws IOException {
        long beforeHeader = this.out.getPos();
        this.innerWriteDataPage(valueCount, uncompressedPageSize, bytes, statistics, rlEncoding, dlEncoding, valuesEncoding, metadataBlockEncryptor, pageHeaderAAD);
        this.offsetIndexBuilder.add((int)(this.out.getPos() - beforeHeader), rowCount);
    }

    private void innerWriteDataPage(int valueCount, int uncompressedPageSize, BytesInput bytes, Statistics statistics, Encoding rlEncoding, Encoding dlEncoding, Encoding valuesEncoding, BlockCipher.Encryptor metadataBlockEncryptor, byte[] pageHeaderAAD) throws IOException {
        this.writeDataPage(valueCount, uncompressedPageSize, bytes, statistics, rlEncoding, dlEncoding, valuesEncoding, metadataBlockEncryptor, pageHeaderAAD);
    }

    public void writeDataPage(int valueCount, int uncompressedPageSize, BytesInput bytes, Statistics statistics, Encoding rlEncoding, Encoding dlEncoding, Encoding valuesEncoding, BlockCipher.Encryptor metadataBlockEncryptor, byte[] pageHeaderAAD) throws IOException {
        this.state = this.state.write();
        long beforeHeader = this.out.getPos();
        if (this.currentChunkFirstDataPage < 0L) {
            this.currentChunkFirstDataPage = beforeHeader;
        }
        LOG.debug("{}: write data page: {} values", (Object)beforeHeader, (Object)valueCount);
        int compressedPageSize = (int)bytes.size();
        if (this.pageWriteChecksumEnabled) {
            this.crc.reset();
            this.crc.update(bytes.toByteArray());
            this.metadataConverter.writeDataPageV1Header(uncompressedPageSize, compressedPageSize, valueCount, rlEncoding, dlEncoding, valuesEncoding, (int)this.crc.getValue(), this.out, metadataBlockEncryptor, pageHeaderAAD);
        } else {
            this.metadataConverter.writeDataPageV1Header(uncompressedPageSize, compressedPageSize, valueCount, rlEncoding, dlEncoding, valuesEncoding, this.out, metadataBlockEncryptor, pageHeaderAAD);
        }
        long headerSize = this.out.getPos() - beforeHeader;
        this.uncompressedLength += (long)uncompressedPageSize + headerSize;
        this.compressedLength += (long)compressedPageSize + headerSize;
        LOG.debug("{}: write data page content {}", (Object)this.out.getPos(), (Object)compressedPageSize);
        bytes.writeAllTo(this.out);
        if (this.currentStatistics == null) {
            this.currentStatistics = statistics.copy();
        } else {
            this.currentStatistics.mergeStatistics(statistics);
        }
        this.columnIndexBuilder.add(statistics);
        this.encodingStatsBuilder.addDataEncoding(valuesEncoding);
        this.currentEncodings.add(rlEncoding);
        this.currentEncodings.add(dlEncoding);
        this.currentEncodings.add(valuesEncoding);
    }

    void addBloomFilter(String column, BloomFilter bloomFilter) {
        this.currentBloomFilters.put(column, bloomFilter);
    }

    public void writeDataPageV2(int rowCount, int nullCount, int valueCount, BytesInput repetitionLevels, BytesInput definitionLevels, Encoding dataEncoding, BytesInput compressedData, int uncompressedDataSize, Statistics<?> statistics) throws IOException {
        this.state = this.state.write();
        int rlByteLength = this.toIntWithCheck(repetitionLevels.size());
        int dlByteLength = this.toIntWithCheck(definitionLevels.size());
        int compressedSize = this.toIntWithCheck(compressedData.size() + repetitionLevels.size() + definitionLevels.size());
        int uncompressedSize = this.toIntWithCheck((long)uncompressedDataSize + repetitionLevels.size() + definitionLevels.size());
        long beforeHeader = this.out.getPos();
        if (this.currentChunkFirstDataPage < 0L) {
            this.currentChunkFirstDataPage = beforeHeader;
        }
        this.metadataConverter.writeDataPageV2Header(uncompressedSize, compressedSize, valueCount, nullCount, rowCount, dataEncoding, rlByteLength, dlByteLength, this.out);
        long headersSize = this.out.getPos() - beforeHeader;
        this.uncompressedLength += (long)uncompressedSize + headersSize;
        this.compressedLength += (long)compressedSize + headersSize;
        if (this.currentStatistics == null) {
            this.currentStatistics = statistics.copy();
        } else {
            this.currentStatistics.mergeStatistics(statistics);
        }
        this.columnIndexBuilder.add(statistics);
        this.currentEncodings.add(dataEncoding);
        this.encodingStatsBuilder.addDataEncoding(dataEncoding);
        BytesInput.concat(repetitionLevels, definitionLevels, compressedData).writeAllTo(this.out);
        this.offsetIndexBuilder.add((int)(this.out.getPos() - beforeHeader), rowCount);
    }

    void writeColumnChunk(ColumnDescriptor descriptor, long valueCount, CompressionCodecName compressionCodecName, DictionaryPage dictionaryPage, BytesInput bytes, long uncompressedTotalPageSize, long compressedTotalPageSize, Statistics<?> totalStats, ColumnIndexBuilder columnIndexBuilder, OffsetIndexBuilder offsetIndexBuilder, BloomFilter bloomFilter, Set<Encoding> rlEncodings, Set<Encoding> dlEncodings, List<Encoding> dataEncodings) throws IOException {
        this.writeColumnChunk(descriptor, valueCount, compressionCodecName, dictionaryPage, bytes, uncompressedTotalPageSize, compressedTotalPageSize, totalStats, columnIndexBuilder, offsetIndexBuilder, bloomFilter, rlEncodings, dlEncodings, dataEncodings, null, 0, 0, null);
    }

    void writeColumnChunk(ColumnDescriptor descriptor, long valueCount, CompressionCodecName compressionCodecName, DictionaryPage dictionaryPage, BytesInput bytes, long uncompressedTotalPageSize, long compressedTotalPageSize, Statistics<?> totalStats, ColumnIndexBuilder columnIndexBuilder, OffsetIndexBuilder offsetIndexBuilder, BloomFilter bloomFilter, Set<Encoding> rlEncodings, Set<Encoding> dlEncodings, List<Encoding> dataEncodings, BlockCipher.Encryptor headerBlockEncryptor, int rowGroupOrdinal, int columnOrdinal, byte[] fileAAD) throws IOException {
        this.startColumn(descriptor, valueCount, compressionCodecName);
        this.state = this.state.write();
        if (dictionaryPage != null) {
            byte[] dictonaryPageHeaderAAD = null;
            if (null != headerBlockEncryptor) {
                dictonaryPageHeaderAAD = AesCipher.createModuleAAD(fileAAD, ModuleCipherFactory.ModuleType.DictionaryPageHeader, rowGroupOrdinal, columnOrdinal, -1);
            }
            this.writeDictionaryPage(dictionaryPage, headerBlockEncryptor, dictonaryPageHeaderAAD);
        }
        if (bloomFilter != null) {
            boolean isWriteBloomFilter = false;
            for (Encoding encoding : dataEncodings) {
                if (encoding == Encoding.RLE_DICTIONARY) continue;
                isWriteBloomFilter = true;
                break;
            }
            if (isWriteBloomFilter) {
                this.currentBloomFilters.put(String.join((CharSequence)".", descriptor.getPath()), bloomFilter);
            }
        }
        LOG.debug("{}: write data pages", (Object)this.out.getPos());
        long headersSize = bytes.size() - compressedTotalPageSize;
        this.uncompressedLength += uncompressedTotalPageSize + headersSize;
        this.compressedLength += compressedTotalPageSize + headersSize;
        LOG.debug("{}: write data pages content", (Object)this.out.getPos());
        this.currentChunkFirstDataPage = this.out.getPos();
        bytes.writeAllTo(this.out);
        this.encodingStatsBuilder.addDataEncodings(dataEncodings);
        if (rlEncodings.isEmpty()) {
            this.encodingStatsBuilder.withV2Pages();
        }
        this.currentEncodings.addAll(rlEncodings);
        this.currentEncodings.addAll(dlEncodings);
        this.currentEncodings.addAll(dataEncodings);
        this.currentStatistics = totalStats;
        this.columnIndexBuilder = columnIndexBuilder;
        this.offsetIndexBuilder = offsetIndexBuilder;
        this.endColumn();
    }

    public void endColumn() throws IOException {
        this.state = this.state.endColumn();
        LOG.debug("{}: end column", (Object)this.out.getPos());
        if (this.columnIndexBuilder.getMinMaxSize() > (long)this.columnIndexBuilder.getPageCount() * 4096L) {
            this.currentColumnIndexes.add(null);
        } else {
            this.currentColumnIndexes.add(this.columnIndexBuilder.build());
        }
        this.currentOffsetIndexes.add(this.offsetIndexBuilder.build(this.currentChunkFirstDataPage));
        this.currentBlock.addColumn(ColumnChunkMetaData.get(this.currentChunkPath, this.currentChunkType, this.currentChunkCodec, this.encodingStatsBuilder.build(), this.currentEncodings, this.currentStatistics, this.currentChunkFirstDataPage, this.currentChunkDictionaryPageOffset, this.currentChunkValueCount, this.compressedLength, this.uncompressedLength));
        this.currentBlock.setTotalByteSize(this.currentBlock.getTotalByteSize() + this.uncompressedLength);
        this.uncompressedLength = 0L;
        this.compressedLength = 0L;
        this.currentChunkDictionaryPageOffset = 0L;
        this.columnIndexBuilder = null;
        this.offsetIndexBuilder = null;
    }

    public void endBlock() throws IOException {
        if (this.currentRecordCount == 0L) {
            throw new ParquetEncodingException("End block with zero record");
        }
        this.state = this.state.endBlock();
        LOG.debug("{}: end block", (Object)this.out.getPos());
        this.currentBlock.setRowCount(this.currentRecordCount);
        this.currentBlock.setOrdinal(this.blocks.size());
        this.blocks.add(this.currentBlock);
        this.columnIndexes.add(this.currentColumnIndexes);
        this.offsetIndexes.add(this.currentOffsetIndexes);
        this.bloomFilters.add(this.currentBloomFilters);
        this.currentColumnIndexes = null;
        this.currentOffsetIndexes = null;
        this.currentBloomFilters = null;
        this.currentBlock = null;
    }

    @Deprecated
    public void appendFile(Configuration conf, Path file) throws IOException {
        try (ParquetFileReader reader = ParquetFileReader.open(conf, file);){
            reader.appendTo(this);
        }
    }

    public void appendFile(InputFile file) throws IOException {
        try (ParquetFileReader reader = ParquetFileReader.open(file);){
            reader.appendTo(this);
        }
    }

    @Deprecated
    public void appendRowGroups(FSDataInputStream file, List<BlockMetaData> rowGroups, boolean dropColumns) throws IOException {
        this.appendRowGroups(HadoopStreams.wrap(file), rowGroups, dropColumns);
    }

    public void appendRowGroups(SeekableInputStream file, List<BlockMetaData> rowGroups, boolean dropColumns) throws IOException {
        for (BlockMetaData block : rowGroups) {
            this.appendRowGroup(file, block, dropColumns);
        }
    }

    @Deprecated
    public void appendRowGroup(FSDataInputStream from, BlockMetaData rowGroup, boolean dropColumns) throws IOException {
        this.appendRowGroup(HadoopStreams.wrap(from), rowGroup, dropColumns);
    }

    public void appendRowGroup(SeekableInputStream from, BlockMetaData rowGroup, boolean dropColumns) throws IOException {
        this.startBlock(rowGroup.getRowCount());
        HashMap<String, ColumnChunkMetaData> columnsToCopy = new HashMap<String, ColumnChunkMetaData>();
        for (ColumnChunkMetaData columnChunkMetaData : rowGroup.getColumns()) {
            columnsToCopy.put(columnChunkMetaData.getPath().toDotString(), columnChunkMetaData);
        }
        ArrayList<ColumnChunkMetaData> columnsInOrder = new ArrayList<ColumnChunkMetaData>();
        for (ColumnDescriptor descriptor : this.schema.getColumns()) {
            String path = ColumnPath.get(descriptor.getPath()).toDotString();
            ColumnChunkMetaData chunk = (ColumnChunkMetaData)columnsToCopy.remove(path);
            if (chunk != null) {
                columnsInOrder.add(chunk);
                continue;
            }
            throw new IllegalArgumentException(String.format("Missing column '%s', cannot copy row group: %s", path, rowGroup));
        }
        if (!dropColumns && !columnsToCopy.isEmpty()) {
            throw new IllegalArgumentException(String.format("Columns cannot be copied (missing from target schema): %s", String.join((CharSequence)", ", columnsToCopy.keySet())));
        }
        long l = -1L;
        long length = 0L;
        long blockUncompressedSize = 0L;
        for (int i = 0; i < columnsInOrder.size(); ++i) {
            ColumnChunkMetaData chunk = (ColumnChunkMetaData)columnsInOrder.get(i);
            long newChunkStart = this.out.getPos() + length;
            if (l < 0L) {
                l = chunk.getStartingPos();
            }
            if (i + 1 == columnsInOrder.size() || ((ColumnChunkMetaData)columnsInOrder.get(i + 1)).getStartingPos() != l + (length += chunk.getTotalSize())) {
                ParquetFileWriter.copy(from, this.out, l, length);
                l = -1L;
                length = 0L;
            }
            this.currentColumnIndexes.add(null);
            this.currentOffsetIndexes.add(null);
            Offsets offsets = Offsets.getOffsets(from, chunk, newChunkStart);
            this.currentBlock.addColumn(ColumnChunkMetaData.get(chunk.getPath(), chunk.getPrimitiveType(), chunk.getCodec(), chunk.getEncodingStats(), chunk.getEncodings(), chunk.getStatistics(), offsets.firstDataPageOffset, offsets.dictionaryPageOffset, chunk.getValueCount(), chunk.getTotalSize(), chunk.getTotalUncompressedSize()));
            blockUncompressedSize += chunk.getTotalUncompressedSize();
        }
        this.currentBlock.setTotalByteSize(blockUncompressedSize);
        this.endBlock();
    }

    public void appendColumnChunk(ColumnDescriptor descriptor, SeekableInputStream from, ColumnChunkMetaData chunk, BloomFilter bloomFilter, org.apache.iceberg.shaded.org.apache.parquet.internal.column.columnindex.ColumnIndex columnIndex, OffsetIndex offsetIndex) throws IOException {
        long start = chunk.getStartingPos();
        long length = chunk.getTotalSize();
        long newChunkStart = this.out.getPos();
        if (newChunkStart != start) {
            offsetIndex = OffsetIndexBuilder.getBuilder().fromOffsetIndex(offsetIndex).build(newChunkStart - start);
        }
        ParquetFileWriter.copy(from, this.out, start, length);
        this.currentBloomFilters.put(String.join((CharSequence)".", descriptor.getPath()), bloomFilter);
        this.currentColumnIndexes.add(columnIndex);
        this.currentOffsetIndexes.add(offsetIndex);
        Offsets offsets = Offsets.getOffsets(from, chunk, newChunkStart);
        this.currentBlock.addColumn(ColumnChunkMetaData.get(chunk.getPath(), chunk.getPrimitiveType(), chunk.getCodec(), chunk.getEncodingStats(), chunk.getEncodings(), chunk.getStatistics(), offsets.firstDataPageOffset, offsets.dictionaryPageOffset, chunk.getValueCount(), chunk.getTotalSize(), chunk.getTotalUncompressedSize()));
        this.currentBlock.setTotalByteSize(this.currentBlock.getTotalByteSize() + chunk.getTotalUncompressedSize());
    }

    private static void copy(SeekableInputStream from, PositionOutputStream to, long start, long length) throws IOException {
        int bytesRead;
        LOG.debug("Copying {} bytes at {} to {}", new Object[]{length, start, to.getPos()});
        from.seek(start);
        byte[] buffer = COPY_BUFFER.get();
        for (long bytesCopied = 0L; bytesCopied < length; bytesCopied += (long)bytesRead) {
            long bytesLeft = length - bytesCopied;
            bytesRead = from.read(buffer, 0, (long)buffer.length < bytesLeft ? buffer.length : (int)bytesLeft);
            if (bytesRead < 0) {
                throw new IllegalArgumentException("Unexpected end of input file at " + start + bytesCopied);
            }
            to.write(buffer, 0, bytesRead);
        }
    }

    public void end(Map<String, String> extraMetaData) throws IOException {
        this.state = this.state.end();
        ParquetFileWriter.serializeColumnIndexes(this.columnIndexes, this.blocks, this.out, this.fileEncryptor);
        ParquetFileWriter.serializeOffsetIndexes(this.offsetIndexes, this.blocks, this.out, this.fileEncryptor);
        ParquetFileWriter.serializeBloomFilters(this.bloomFilters, this.blocks, this.out, this.fileEncryptor);
        LOG.debug("{}: end", (Object)this.out.getPos());
        this.footer = new ParquetMetadata(new FileMetaData(this.schema, extraMetaData, "parquet-mr version 1.12.3 (build f8dced182c4c1fbdec6ccb3185537b5a01e6ed6b)"), this.blocks);
        ParquetFileWriter.serializeFooter(this.footer, this.out, this.fileEncryptor);
        this.out.close();
    }

    private static void serializeColumnIndexes(List<List<org.apache.iceberg.shaded.org.apache.parquet.internal.column.columnindex.ColumnIndex>> columnIndexes, List<BlockMetaData> blocks, PositionOutputStream out, InternalFileEncryptor fileEncryptor) throws IOException {
        LOG.debug("{}: column indexes", (Object)out.getPos());
        int bSize = blocks.size();
        for (int bIndex = 0; bIndex < bSize; ++bIndex) {
            BlockMetaData block = blocks.get(bIndex);
            List<ColumnChunkMetaData> columns = block.getColumns();
            List<org.apache.iceberg.shaded.org.apache.parquet.internal.column.columnindex.ColumnIndex> blockColumnIndexes = columnIndexes.get(bIndex);
            int cSize = columns.size();
            for (int cIndex = 0; cIndex < cSize; ++cIndex) {
                InternalColumnEncryptionSetup columnEncryptionSetup;
                ColumnChunkMetaData column = columns.get(cIndex);
                ColumnIndex columnIndex = ParquetMetadataConverter.toParquetColumnIndex(column.getPrimitiveType(), blockColumnIndexes.get(cIndex));
                if (columnIndex == null) continue;
                BlockCipher.Encryptor columnIndexEncryptor = null;
                byte[] columnIndexAAD = null;
                if (null != fileEncryptor && (columnEncryptionSetup = fileEncryptor.getColumnSetup(column.getPath(), false, cIndex)).isEncrypted()) {
                    columnIndexEncryptor = columnEncryptionSetup.getMetaDataEncryptor();
                    columnIndexAAD = AesCipher.createModuleAAD(fileEncryptor.getFileAAD(), ModuleCipherFactory.ModuleType.ColumnIndex, block.getOrdinal(), columnEncryptionSetup.getOrdinal(), -1);
                }
                long offset = out.getPos();
                Util.writeColumnIndex(columnIndex, out, columnIndexEncryptor, columnIndexAAD);
                column.setColumnIndexReference(new IndexReference(offset, (int)(out.getPos() - offset)));
            }
        }
    }

    private int toIntWithCheck(long size) {
        if ((long)((int)size) != size) {
            throw new ParquetEncodingException("Cannot write page larger than 2147483647 bytes: " + size);
        }
        return (int)size;
    }

    private static void serializeOffsetIndexes(List<List<OffsetIndex>> offsetIndexes, List<BlockMetaData> blocks, PositionOutputStream out, InternalFileEncryptor fileEncryptor) throws IOException {
        LOG.debug("{}: offset indexes", (Object)out.getPos());
        int bSize = blocks.size();
        for (int bIndex = 0; bIndex < bSize; ++bIndex) {
            BlockMetaData block = blocks.get(bIndex);
            List<ColumnChunkMetaData> columns = block.getColumns();
            List<OffsetIndex> blockOffsetIndexes = offsetIndexes.get(bIndex);
            int cSize = columns.size();
            for (int cIndex = 0; cIndex < cSize; ++cIndex) {
                InternalColumnEncryptionSetup columnEncryptionSetup;
                OffsetIndex offsetIndex = blockOffsetIndexes.get(cIndex);
                if (offsetIndex == null) continue;
                ColumnChunkMetaData column = columns.get(cIndex);
                BlockCipher.Encryptor offsetIndexEncryptor = null;
                byte[] offsetIndexAAD = null;
                if (null != fileEncryptor && (columnEncryptionSetup = fileEncryptor.getColumnSetup(column.getPath(), false, cIndex)).isEncrypted()) {
                    offsetIndexEncryptor = columnEncryptionSetup.getMetaDataEncryptor();
                    offsetIndexAAD = AesCipher.createModuleAAD(fileEncryptor.getFileAAD(), ModuleCipherFactory.ModuleType.OffsetIndex, block.getOrdinal(), columnEncryptionSetup.getOrdinal(), -1);
                }
                long offset = out.getPos();
                Util.writeOffsetIndex(ParquetMetadataConverter.toParquetOffsetIndex(offsetIndex), out, offsetIndexEncryptor, offsetIndexAAD);
                column.setOffsetIndexReference(new IndexReference(offset, (int)(out.getPos() - offset)));
            }
        }
    }

    private static void serializeBloomFilters(List<Map<String, BloomFilter>> bloomFilters, List<BlockMetaData> blocks, PositionOutputStream out, InternalFileEncryptor fileEncryptor) throws IOException {
        LOG.debug("{}: bloom filters", (Object)out.getPos());
        int bSize = blocks.size();
        for (int bIndex = 0; bIndex < bSize; ++bIndex) {
            BlockMetaData block = blocks.get(bIndex);
            List<ColumnChunkMetaData> columns = block.getColumns();
            Map<String, BloomFilter> blockBloomFilters = bloomFilters.get(bIndex);
            if (blockBloomFilters.isEmpty()) continue;
            int cSize = columns.size();
            for (int cIndex = 0; cIndex < cSize; ++cIndex) {
                InternalColumnEncryptionSetup columnEncryptionSetup;
                ColumnChunkMetaData column = columns.get(cIndex);
                BloomFilter bloomFilter = blockBloomFilters.get(column.getPath().toDotString());
                if (bloomFilter == null) continue;
                long offset = out.getPos();
                column.setBloomFilterOffset(offset);
                BlockCipher.Encryptor bloomFilterEncryptor = null;
                byte[] bloomFilterHeaderAAD = null;
                byte[] bloomFilterBitsetAAD = null;
                if (null != fileEncryptor && (columnEncryptionSetup = fileEncryptor.getColumnSetup(column.getPath(), false, cIndex)).isEncrypted()) {
                    bloomFilterEncryptor = columnEncryptionSetup.getMetaDataEncryptor();
                    int columnOrdinal = columnEncryptionSetup.getOrdinal();
                    bloomFilterHeaderAAD = AesCipher.createModuleAAD(fileEncryptor.getFileAAD(), ModuleCipherFactory.ModuleType.BloomFilterHeader, block.getOrdinal(), columnOrdinal, -1);
                    bloomFilterBitsetAAD = AesCipher.createModuleAAD(fileEncryptor.getFileAAD(), ModuleCipherFactory.ModuleType.BloomFilterBitset, block.getOrdinal(), columnOrdinal, -1);
                }
                Util.writeBloomFilterHeader(ParquetMetadataConverter.toBloomFilterHeader(bloomFilter), out, bloomFilterEncryptor, bloomFilterHeaderAAD);
                ByteArrayOutputStream tempOutStream = new ByteArrayOutputStream();
                bloomFilter.writeTo(tempOutStream);
                byte[] serializedBitset = tempOutStream.toByteArray();
                if (null != bloomFilterEncryptor) {
                    serializedBitset = bloomFilterEncryptor.encrypt(serializedBitset, bloomFilterBitsetAAD);
                }
                out.write(serializedBitset);
            }
        }
    }

    private static void serializeFooter(ParquetMetadata footer, PositionOutputStream out, InternalFileEncryptor fileEncryptor) throws IOException {
        ParquetMetadataConverter metadataConverter = new ParquetMetadataConverter();
        if (null == fileEncryptor) {
            long footerIndex = out.getPos();
            org.apache.iceberg.shaded.org.apache.parquet.format.FileMetaData parquetMetadata = metadataConverter.toParquetMetadata(1, footer);
            Util.writeFileMetaData(parquetMetadata, out);
            LOG.debug("{}: footer length = {}", (Object)out.getPos(), (Object)(out.getPos() - footerIndex));
            BytesUtils.writeIntLittleEndian(out, (int)(out.getPos() - footerIndex));
            out.write(MAGIC);
            return;
        }
        org.apache.iceberg.shaded.org.apache.parquet.format.FileMetaData parquetMetadata = metadataConverter.toParquetMetadata(1, footer, fileEncryptor);
        if (!fileEncryptor.isFooterEncrypted()) {
            long footerIndex = out.getPos();
            parquetMetadata.setEncryption_algorithm(fileEncryptor.getEncryptionAlgorithm());
            byte[] footerSigningKeyMetaData = fileEncryptor.getFooterSigningKeyMetaData();
            if (null != footerSigningKeyMetaData) {
                parquetMetadata.setFooter_signing_key_metadata(footerSigningKeyMetaData);
            }
            ByteArrayOutputStream tempOutStream = new ByteArrayOutputStream();
            Util.writeFileMetaData(parquetMetadata, tempOutStream);
            byte[] serializedFooter = tempOutStream.toByteArray();
            byte[] footerAAD = AesCipher.createFooterAAD(fileEncryptor.getFileAAD());
            byte[] encryptedFooter = fileEncryptor.getSignedFooterEncryptor().encrypt(serializedFooter, footerAAD);
            byte[] signature = new byte[28];
            System.arraycopy(encryptedFooter, 4, signature, 0, 12);
            System.arraycopy(encryptedFooter, encryptedFooter.length - 16, signature, 12, 16);
            out.write(serializedFooter);
            out.write(signature);
            LOG.debug("{}: footer and signature length = {}", (Object)out.getPos(), (Object)(out.getPos() - footerIndex));
            BytesUtils.writeIntLittleEndian(out, (int)(out.getPos() - footerIndex));
            out.write(MAGIC);
            return;
        }
        long cryptoFooterIndex = out.getPos();
        Util.writeFileCryptoMetaData(fileEncryptor.getFileCryptoMetaData(), out);
        byte[] footerAAD = AesCipher.createFooterAAD(fileEncryptor.getFileAAD());
        Util.writeFileMetaData(parquetMetadata, out, fileEncryptor.getFooterEncryptor(), footerAAD);
        int combinedMetaDataLength = (int)(out.getPos() - cryptoFooterIndex);
        LOG.debug("{}: crypto metadata and footer length = {}", (Object)out.getPos(), (Object)combinedMetaDataLength);
        BytesUtils.writeIntLittleEndian(out, combinedMetaDataLength);
        out.write(EFMAGIC);
    }

    public ParquetMetadata getFooter() {
        Preconditions.checkState(this.state == STATE.ENDED, "Cannot return unfinished footer.");
        return this.footer;
    }

    @Deprecated
    public static ParquetMetadata mergeMetadataFiles(List<Path> files, Configuration conf) throws IOException {
        return ParquetFileWriter.mergeMetadataFiles(files, conf, new StrictKeyValueMetadataMergeStrategy());
    }

    @Deprecated
    public static ParquetMetadata mergeMetadataFiles(List<Path> files, Configuration conf, KeyValueMetadataMergeStrategy keyValueMetadataMergeStrategy) throws IOException {
        Preconditions.checkArgument(!files.isEmpty(), "Cannot merge an empty list of metadata");
        GlobalMetaData globalMetaData = null;
        ArrayList<BlockMetaData> blocks = new ArrayList<BlockMetaData>();
        for (Path p : files) {
            ParquetMetadata pmd = ParquetFileReader.readFooter(conf, p, ParquetMetadataConverter.NO_FILTER);
            FileMetaData fmd = pmd.getFileMetaData();
            globalMetaData = ParquetFileWriter.mergeInto(fmd, globalMetaData, true);
            blocks.addAll(pmd.getBlocks());
        }
        return new ParquetMetadata(globalMetaData.merge(keyValueMetadataMergeStrategy), blocks);
    }

    @Deprecated
    public static void writeMergedMetadataFile(List<Path> files, Path outputPath, Configuration conf) throws IOException {
        ParquetMetadata merged = ParquetFileWriter.mergeMetadataFiles(files, conf);
        ParquetFileWriter.writeMetadataFile(outputPath, merged, outputPath.getFileSystem(conf));
    }

    @Deprecated
    public static void writeMetadataFile(Configuration configuration, Path outputPath, List<Footer> footers) throws IOException {
        ParquetFileWriter.writeMetadataFile(configuration, outputPath, footers, ParquetOutputFormat.JobSummaryLevel.ALL);
    }

    @Deprecated
    public static void writeMetadataFile(Configuration configuration, Path outputPath, List<Footer> footers, ParquetOutputFormat.JobSummaryLevel level) throws IOException {
        Preconditions.checkArgument(level == ParquetOutputFormat.JobSummaryLevel.ALL || level == ParquetOutputFormat.JobSummaryLevel.COMMON_ONLY, "Unsupported level: " + (Object)((Object)level));
        FileSystem fs = outputPath.getFileSystem(configuration);
        outputPath = outputPath.makeQualified(fs);
        ParquetMetadata metadataFooter = ParquetFileWriter.mergeFooters(outputPath, footers);
        if (level == ParquetOutputFormat.JobSummaryLevel.ALL) {
            ParquetFileWriter.writeMetadataFile(outputPath, metadataFooter, fs, PARQUET_METADATA_FILE);
        }
        metadataFooter.getBlocks().clear();
        ParquetFileWriter.writeMetadataFile(outputPath, metadataFooter, fs, PARQUET_COMMON_METADATA_FILE);
    }

    @Deprecated
    private static void writeMetadataFile(Path outputPathRoot, ParquetMetadata metadataFooter, FileSystem fs, String parquetMetadataFile) throws IOException {
        Path metaDataPath = new Path(outputPathRoot, parquetMetadataFile);
        ParquetFileWriter.writeMetadataFile(metaDataPath, metadataFooter, fs);
    }

    @Deprecated
    private static void writeMetadataFile(Path outputPath, ParquetMetadata metadataFooter, FileSystem fs) throws IOException {
        PositionOutputStream metadata = HadoopStreams.wrap(fs.create(outputPath));
        metadata.write(MAGIC);
        ParquetFileWriter.serializeFooter(metadataFooter, metadata, null);
        metadata.close();
    }

    static ParquetMetadata mergeFooters(Path root, List<Footer> footers) {
        return ParquetFileWriter.mergeFooters(root, footers, new StrictKeyValueMetadataMergeStrategy());
    }

    static ParquetMetadata mergeFooters(Path root, List<Footer> footers, KeyValueMetadataMergeStrategy keyValueMergeStrategy) {
        String rootPath = root.toUri().getPath();
        GlobalMetaData fileMetaData = null;
        ArrayList<BlockMetaData> blocks = new ArrayList<BlockMetaData>();
        for (Footer footer : footers) {
            String footerPath = footer.getFile().toUri().getPath();
            if (!footerPath.startsWith(rootPath)) {
                throw new ParquetEncodingException(footerPath + " invalid: all the files must be contained in the root " + root);
            }
            footerPath = footerPath.substring(rootPath.length());
            while (footerPath.startsWith("/")) {
                footerPath = footerPath.substring(1);
            }
            fileMetaData = ParquetFileWriter.mergeInto(footer.getParquetMetadata().getFileMetaData(), fileMetaData);
            for (BlockMetaData block : footer.getParquetMetadata().getBlocks()) {
                block.setPath(footerPath);
                blocks.add(block);
            }
        }
        return new ParquetMetadata(fileMetaData.merge(keyValueMergeStrategy), blocks);
    }

    public long getPos() throws IOException {
        return this.out.getPos();
    }

    public long getNextRowGroupSize() throws IOException {
        return this.alignment.nextRowGroupSize(this.out);
    }

    static GlobalMetaData getGlobalMetaData(List<Footer> footers) {
        return ParquetFileWriter.getGlobalMetaData(footers, true);
    }

    static GlobalMetaData getGlobalMetaData(List<Footer> footers, boolean strict) {
        GlobalMetaData fileMetaData = null;
        for (Footer footer : footers) {
            ParquetMetadata currentMetadata = footer.getParquetMetadata();
            fileMetaData = ParquetFileWriter.mergeInto(currentMetadata.getFileMetaData(), fileMetaData, strict);
        }
        return fileMetaData;
    }

    static GlobalMetaData mergeInto(FileMetaData toMerge, GlobalMetaData mergedMetadata) {
        return ParquetFileWriter.mergeInto(toMerge, mergedMetadata, true);
    }

    static GlobalMetaData mergeInto(FileMetaData toMerge, GlobalMetaData mergedMetadata, boolean strict) {
        MessageType schema = null;
        HashMap<String, Set<String>> newKeyValues = new HashMap<String, Set<String>>();
        HashSet<String> createdBy = new HashSet<String>();
        if (mergedMetadata != null) {
            schema = mergedMetadata.getSchema();
            newKeyValues.putAll(mergedMetadata.getKeyValueMetaData());
            createdBy.addAll(mergedMetadata.getCreatedBy());
        }
        if (schema == null && toMerge.getSchema() != null || schema != null && !schema.equals((Object)toMerge.getSchema())) {
            schema = ParquetFileWriter.mergeInto(toMerge.getSchema(), schema, strict);
        }
        for (Map.Entry<String, String> entry : toMerge.getKeyValueMetaData().entrySet()) {
            LinkedHashSet<String> values = (LinkedHashSet<String>)newKeyValues.get(entry.getKey());
            if (values == null) {
                values = new LinkedHashSet<String>();
                newKeyValues.put(entry.getKey(), values);
            }
            values.add(entry.getValue());
        }
        createdBy.add(toMerge.getCreatedBy());
        return new GlobalMetaData(schema, newKeyValues, createdBy);
    }

    static MessageType mergeInto(MessageType toMerge, MessageType mergedSchema) {
        return ParquetFileWriter.mergeInto(toMerge, mergedSchema, true);
    }

    static MessageType mergeInto(MessageType toMerge, MessageType mergedSchema, boolean strict) {
        if (mergedSchema == null) {
            return toMerge;
        }
        return mergedSchema.union(toMerge, strict);
    }

    private static class PaddingAlignment
    implements AlignmentStrategy {
        private static final byte[] zeros = new byte[4096];
        protected final long dfsBlockSize;
        protected final long rowGroupSize;
        protected final int maxPaddingSize;

        public static PaddingAlignment get(long dfsBlockSize, long rowGroupSize, int maxPaddingSize) {
            return new PaddingAlignment(dfsBlockSize, rowGroupSize, maxPaddingSize);
        }

        private PaddingAlignment(long dfsBlockSize, long rowGroupSize, int maxPaddingSize) {
            this.dfsBlockSize = dfsBlockSize;
            this.rowGroupSize = rowGroupSize;
            this.maxPaddingSize = maxPaddingSize;
        }

        @Override
        public void alignForRowGroup(PositionOutputStream out) throws IOException {
            long remaining = this.dfsBlockSize - out.getPos() % this.dfsBlockSize;
            if (this.isPaddingNeeded(remaining)) {
                LOG.debug("Adding {} bytes of padding (row group size={}B, block size={}B)", new Object[]{remaining, this.rowGroupSize, this.dfsBlockSize});
                while (remaining > 0L) {
                    out.write(zeros, 0, (int)Math.min((long)zeros.length, remaining));
                    remaining -= (long)zeros.length;
                }
            }
        }

        @Override
        public long nextRowGroupSize(PositionOutputStream out) throws IOException {
            if (this.maxPaddingSize <= 0) {
                return this.rowGroupSize;
            }
            long remaining = this.dfsBlockSize - out.getPos() % this.dfsBlockSize;
            if (this.isPaddingNeeded(remaining)) {
                return this.rowGroupSize;
            }
            return Math.min(remaining, this.rowGroupSize);
        }

        protected boolean isPaddingNeeded(long remaining) {
            return remaining <= (long)this.maxPaddingSize;
        }
    }

    private static class NoAlignment
    implements AlignmentStrategy {
        private final long rowGroupSize;

        public static NoAlignment get(long rowGroupSize) {
            return new NoAlignment(rowGroupSize);
        }

        private NoAlignment(long rowGroupSize) {
            this.rowGroupSize = rowGroupSize;
        }

        @Override
        public void alignForRowGroup(PositionOutputStream out) {
        }

        @Override
        public long nextRowGroupSize(PositionOutputStream out) {
            return this.rowGroupSize;
        }
    }

    private static interface AlignmentStrategy {
        public void alignForRowGroup(PositionOutputStream var1) throws IOException;

        public long nextRowGroupSize(PositionOutputStream var1) throws IOException;
    }

    private static enum STATE {
        NOT_STARTED{

            @Override
            STATE start() {
                return STARTED;
            }
        }
        ,
        STARTED{

            @Override
            STATE startBlock() {
                return BLOCK;
            }

            @Override
            STATE end() {
                return ENDED;
            }
        }
        ,
        BLOCK{

            @Override
            STATE startColumn() {
                return COLUMN;
            }

            @Override
            STATE endBlock() {
                return STARTED;
            }
        }
        ,
        COLUMN{

            @Override
            STATE endColumn() {
                return BLOCK;
            }

            @Override
            STATE write() {
                return this;
            }
        }
        ,
        ENDED;


        STATE start() throws IOException {
            return this.error();
        }

        STATE startBlock() throws IOException {
            return this.error();
        }

        STATE startColumn() throws IOException {
            return this.error();
        }

        STATE write() throws IOException {
            return this.error();
        }

        STATE endColumn() throws IOException {
            return this.error();
        }

        STATE endBlock() throws IOException {
            return this.error();
        }

        STATE end() throws IOException {
            return this.error();
        }

        private final STATE error() throws IOException {
            throw new IOException("The file being written is in an invalid state. Probably caused by an error thrown previously. Current state: " + this.name());
        }
    }

    public static enum Mode {
        CREATE,
        OVERWRITE;

    }
}

