/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.aws;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.iceberg.aws.AwsProperties;
import org.apache.iceberg.exceptions.RESTException;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.signer.Aws4Signer;
import software.amazon.awssdk.auth.signer.params.Aws4SignerParams;
import software.amazon.awssdk.auth.signer.params.SignerChecksumParams;
import software.amazon.awssdk.core.checksums.Algorithm;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.awssdk.regions.Region;

public class RESTSigV4Signer
implements HttpRequestInterceptor {
    static final String EMPTY_BODY_SHA256 = "e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855";
    static final String RELOCATED_HEADER_PREFIX = "Original-";
    private final Aws4Signer signer = Aws4Signer.create();
    private AwsCredentialsProvider credentialsProvider;
    private String signingName;
    private Region signingRegion;

    public void initialize(Map<String, String> properties) {
        AwsProperties awsProperties = new AwsProperties(properties);
        this.signingRegion = awsProperties.restSigningRegion();
        this.signingName = awsProperties.restSigningName();
        this.credentialsProvider = awsProperties.restCredentialsProvider();
    }

    @Override
    public void process(HttpRequest request, EntityDetails entity, HttpContext context) {
        URI requestUri;
        try {
            requestUri = request.getUri();
        }
        catch (URISyntaxException e) {
            throw new RESTException(e, "Invalid uri for request: %s", request);
        }
        Aws4SignerParams params = Aws4SignerParams.builder().signingName(this.signingName).signingRegion(this.signingRegion).awsCredentials(this.credentialsProvider.resolveCredentials()).checksumParams(SignerChecksumParams.builder().algorithm(Algorithm.SHA256).isStreamingRequest(false).checksumHeaderName("x-amz-content-sha256").build()).build();
        SdkHttpFullRequest.Builder sdkRequestBuilder = SdkHttpFullRequest.builder();
        sdkRequestBuilder.method(SdkHttpMethod.fromValue((String)request.getMethod())).protocol(request.getScheme()).uri(requestUri).headers(this.convertHeaders(request.getHeaders()));
        if (entity == null) {
            sdkRequestBuilder.putHeader("x-amz-content-sha256", EMPTY_BODY_SHA256);
        } else if (entity instanceof StringEntity) {
            sdkRequestBuilder.contentStreamProvider(() -> {
                try {
                    return ((StringEntity)entity).getContent();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
        } else {
            throw new UnsupportedOperationException("Unsupported entity type: " + entity.getClass());
        }
        SdkHttpFullRequest signedSdkRequest = this.signer.sign(sdkRequestBuilder.build(), params);
        this.updateRequestHeaders(request, signedSdkRequest.headers());
    }

    private Map<String, List<String>> convertHeaders(Header[] headers) {
        return Arrays.stream(headers).collect(Collectors.groupingBy(header -> "Authorization".equals(header.getName()) ? RELOCATED_HEADER_PREFIX + header.getName() : header.getName(), Collectors.mapping(NameValuePair::getValue, Collectors.toList())));
    }

    private void updateRequestHeaders(HttpRequest request, Map<String, List<String>> headers) {
        headers.forEach((name, values) -> {
            if (request.containsHeader((String)name)) {
                Header[] original = request.getHeaders((String)name);
                request.removeHeaders((String)name);
                Arrays.asList(original).forEach(header -> {
                    if (!values.contains(header.getValue())) {
                        request.addHeader(RELOCATED_HEADER_PREFIX + name, header.getValue());
                    }
                });
            }
            values.forEach(value -> request.setHeader((String)name, value));
        });
    }
}

