/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink.shuffle;

import java.io.Serializable;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.data.RowData;
import org.apache.iceberg.flink.sink.shuffle.DataStatistics;
import org.apache.iceberg.relocated.com.google.common.base.MoreObjects;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;

class DataStatisticsOrRecord<D extends DataStatistics<D, S>, S>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private DataStatistics<D, S> statistics;
    private RowData record;

    private DataStatisticsOrRecord(DataStatistics<D, S> statistics, RowData record) {
        Preconditions.checkArgument(record != null ^ statistics != null, "A DataStatisticsOrRecord contain either statistics or record, not neither or both");
        this.statistics = statistics;
        this.record = record;
    }

    static <D extends DataStatistics<D, S>, S> DataStatisticsOrRecord<D, S> fromRecord(RowData record) {
        return new DataStatisticsOrRecord<D, S>(null, record);
    }

    static <D extends DataStatistics<D, S>, S> DataStatisticsOrRecord<D, S> fromDataStatistics(DataStatistics<D, S> statistics) {
        return new DataStatisticsOrRecord<D, S>(statistics, null);
    }

    static <D extends DataStatistics<D, S>, S> DataStatisticsOrRecord<D, S> reuseRecord(DataStatisticsOrRecord<D, S> reuse, TypeSerializer<RowData> recordSerializer) {
        if (reuse.hasRecord()) {
            return reuse;
        }
        return DataStatisticsOrRecord.fromRecord((RowData)recordSerializer.createInstance());
    }

    static <D extends DataStatistics<D, S>, S> DataStatisticsOrRecord<D, S> reuseStatistics(DataStatisticsOrRecord<D, S> reuse, TypeSerializer<DataStatistics<D, S>> statisticsSerializer) {
        if (reuse.hasDataStatistics()) {
            return reuse;
        }
        return DataStatisticsOrRecord.fromDataStatistics((DataStatistics)statisticsSerializer.createInstance());
    }

    boolean hasDataStatistics() {
        return this.statistics != null;
    }

    boolean hasRecord() {
        return this.record != null;
    }

    DataStatistics<D, S> dataStatistics() {
        return this.statistics;
    }

    void dataStatistics(DataStatistics<D, S> newStatistics) {
        this.statistics = newStatistics;
    }

    RowData record() {
        return this.record;
    }

    void record(RowData newRecord) {
        this.record = newRecord;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("statistics", this.statistics).add("record", this.record).toString();
    }
}

