/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink.shuffle;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.CompositeTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.api.common.typeutils.base.MapSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.table.data.RowData;
import org.apache.flink.util.Preconditions;
import org.apache.iceberg.flink.sink.shuffle.DataStatistics;
import org.apache.iceberg.flink.sink.shuffle.MapDataStatistics;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;

@Internal
class MapDataStatisticsSerializer
extends TypeSerializer<DataStatistics<MapDataStatistics, Map<RowData, Long>>> {
    private final MapSerializer<RowData, Long> mapSerializer;

    static TypeSerializer<DataStatistics<MapDataStatistics, Map<RowData, Long>>> fromKeySerializer(TypeSerializer<RowData> keySerializer) {
        return new MapDataStatisticsSerializer((MapSerializer<RowData, Long>)new MapSerializer(keySerializer, (TypeSerializer)LongSerializer.INSTANCE));
    }

    MapDataStatisticsSerializer(MapSerializer<RowData, Long> mapSerializer) {
        this.mapSerializer = mapSerializer;
    }

    public boolean isImmutableType() {
        return false;
    }

    public TypeSerializer<DataStatistics<MapDataStatistics, Map<RowData, Long>>> duplicate() {
        MapSerializer duplicateMapSerializer = (MapSerializer)this.mapSerializer.duplicate();
        return duplicateMapSerializer == this.mapSerializer ? this : new MapDataStatisticsSerializer((MapSerializer<RowData, Long>)duplicateMapSerializer);
    }

    public DataStatistics<MapDataStatistics, Map<RowData, Long>> createInstance() {
        return new MapDataStatistics();
    }

    public DataStatistics<MapDataStatistics, Map<RowData, Long>> copy(DataStatistics obj) {
        Preconditions.checkArgument((boolean)(obj instanceof MapDataStatistics), (Object)("Invalid data statistics type: " + obj.getClass()));
        MapDataStatistics from = (MapDataStatistics)obj;
        TypeSerializer keySerializer = this.mapSerializer.getKeySerializer();
        HashMap<RowData, Long> newMap = Maps.newHashMapWithExpectedSize(from.statistics().size());
        for (Map.Entry entry : from.statistics().entrySet()) {
            RowData newKey = (RowData)keySerializer.copy((Object)((RowData)entry.getKey()));
            newMap.put(newKey, (Long)entry.getValue());
        }
        return new MapDataStatistics(newMap);
    }

    public DataStatistics<MapDataStatistics, Map<RowData, Long>> copy(DataStatistics from, DataStatistics reuse) {
        return this.copy(from);
    }

    public int getLength() {
        return -1;
    }

    public void serialize(DataStatistics obj, DataOutputView target) throws IOException {
        Preconditions.checkArgument((boolean)(obj instanceof MapDataStatistics), (Object)("Invalid data statistics type: " + obj.getClass()));
        MapDataStatistics mapStatistics = (MapDataStatistics)obj;
        this.mapSerializer.serialize((Map)mapStatistics.statistics(), target);
    }

    public DataStatistics<MapDataStatistics, Map<RowData, Long>> deserialize(DataInputView source) throws IOException {
        return new MapDataStatistics(this.mapSerializer.deserialize(source));
    }

    public DataStatistics<MapDataStatistics, Map<RowData, Long>> deserialize(DataStatistics reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        this.mapSerializer.copy(source, target);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MapDataStatisticsSerializer)) {
            return false;
        }
        MapDataStatisticsSerializer other = (MapDataStatisticsSerializer)((Object)obj);
        return Objects.equals(this.mapSerializer, other.mapSerializer);
    }

    public int hashCode() {
        return this.mapSerializer.hashCode();
    }

    public TypeSerializerSnapshot<DataStatistics<MapDataStatistics, Map<RowData, Long>>> snapshotConfiguration() {
        return new MapDataStatisticsSerializerSnapshot(this);
    }

    public static class MapDataStatisticsSerializerSnapshot
    extends CompositeTypeSerializerSnapshot<DataStatistics<MapDataStatistics, Map<RowData, Long>>, MapDataStatisticsSerializer> {
        private static final int CURRENT_VERSION = 1;

        public MapDataStatisticsSerializerSnapshot() {
            super(MapDataStatisticsSerializer.class);
        }

        public MapDataStatisticsSerializerSnapshot(MapDataStatisticsSerializer serializer) {
            super((TypeSerializer)serializer);
        }

        protected int getCurrentOuterSnapshotVersion() {
            return 1;
        }

        protected TypeSerializer<?>[] getNestedSerializers(MapDataStatisticsSerializer outerSerializer) {
            return new TypeSerializer[]{outerSerializer.mapSerializer};
        }

        protected MapDataStatisticsSerializer createOuterSerializerWithNestedSerializers(TypeSerializer<?>[] nestedSerializers) {
            MapSerializer mapSerializer = (MapSerializer)nestedSerializers[0];
            return new MapDataStatisticsSerializer((MapSerializer<RowData, Long>)mapSerializer);
        }
    }
}

