/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.shaded.org.apache.parquet.hadoop;

import java.io.IOException;
import java.util.Objects;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.iceberg.shaded.org.apache.parquet.column.ParquetProperties;
import org.apache.iceberg.shaded.org.apache.parquet.crypto.EncryptionPropertiesFactory;
import org.apache.iceberg.shaded.org.apache.parquet.crypto.FileEncryptionProperties;
import org.apache.iceberg.shaded.org.apache.parquet.hadoop.BadConfigurationException;
import org.apache.iceberg.shaded.org.apache.parquet.hadoop.ColumnConfigParser;
import org.apache.iceberg.shaded.org.apache.parquet.hadoop.MemoryManager;
import org.apache.iceberg.shaded.org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.iceberg.shaded.org.apache.parquet.hadoop.ParquetOutputCommitter;
import org.apache.iceberg.shaded.org.apache.parquet.hadoop.ParquetRecordWriter;
import org.apache.iceberg.shaded.org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.iceberg.shaded.org.apache.parquet.hadoop.codec.CodecConfig;
import org.apache.iceberg.shaded.org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.iceberg.shaded.org.apache.parquet.hadoop.util.ConfigurationUtil;
import org.apache.iceberg.shaded.org.apache.parquet.hadoop.util.ContextUtil;
import org.apache.iceberg.shaded.org.apache.parquet.hadoop.util.HadoopOutputFile;
import org.apache.iceberg.shaded.org.apache.parquet.io.OutputFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParquetOutputFormat<T>
extends FileOutputFormat<Void, T> {
    private static final Logger LOG = LoggerFactory.getLogger(ParquetOutputFormat.class);
    @Deprecated
    public static final String ENABLE_JOB_SUMMARY = "parquet.enable.summary-metadata";
    public static final String JOB_SUMMARY_LEVEL = "parquet.summary.metadata.level";
    public static final String BLOCK_SIZE = "parquet.block.size";
    public static final String PAGE_SIZE = "parquet.page.size";
    public static final String COMPRESSION = "parquet.compression";
    public static final String WRITE_SUPPORT_CLASS = "parquet.write.support.class";
    public static final String DICTIONARY_PAGE_SIZE = "parquet.dictionary.page.size";
    public static final String ENABLE_DICTIONARY = "parquet.enable.dictionary";
    public static final String VALIDATION = "parquet.validation";
    public static final String WRITER_VERSION = "parquet.writer.version";
    public static final String MEMORY_POOL_RATIO = "parquet.memory.pool.ratio";
    public static final String MIN_MEMORY_ALLOCATION = "parquet.memory.min.chunk.size";
    public static final String MAX_PADDING_BYTES = "parquet.writer.max-padding";
    public static final String MIN_ROW_COUNT_FOR_PAGE_SIZE_CHECK = "parquet.page.size.row.check.min";
    public static final String MAX_ROW_COUNT_FOR_PAGE_SIZE_CHECK = "parquet.page.size.row.check.max";
    public static final String ESTIMATE_PAGE_SIZE_CHECK = "parquet.page.size.check.estimate";
    public static final String COLUMN_INDEX_TRUNCATE_LENGTH = "parquet.columnindex.truncate.length";
    public static final String STATISTICS_TRUNCATE_LENGTH = "parquet.statistics.truncate.length";
    public static final String BLOOM_FILTER_ENABLED = "parquet.bloom.filter.enabled";
    public static final String BLOOM_FILTER_EXPECTED_NDV = "parquet.bloom.filter.expected.ndv";
    public static final String BLOOM_FILTER_MAX_BYTES = "parquet.bloom.filter.max.bytes";
    public static final String BLOOM_FILTER_FPP = "parquet.bloom.filter.fpp";
    public static final String PAGE_ROW_COUNT_LIMIT = "parquet.page.row.count.limit";
    public static final String PAGE_WRITE_CHECKSUM_ENABLED = "parquet.page.write-checksum.enabled";
    private WriteSupport<T> writeSupport;
    private ParquetOutputCommitter committer;
    private static MemoryManager memoryManager;

    public static JobSummaryLevel getJobSummaryLevel(Configuration conf) {
        String level = conf.get(JOB_SUMMARY_LEVEL);
        String deprecatedFlag = conf.get(ENABLE_JOB_SUMMARY);
        if (deprecatedFlag != null) {
            LOG.warn("Setting parquet.enable.summary-metadata is deprecated, please use parquet.summary.metadata.level");
        }
        if (level != null && deprecatedFlag != null) {
            LOG.warn("Both parquet.summary.metadata.level and parquet.enable.summary-metadata are set! parquet.enable.summary-metadata will be ignored.");
        }
        if (level != null) {
            return JobSummaryLevel.valueOf(level.toUpperCase());
        }
        if (deprecatedFlag != null) {
            return Boolean.valueOf(deprecatedFlag) != false ? JobSummaryLevel.ALL : JobSummaryLevel.NONE;
        }
        return JobSummaryLevel.ALL;
    }

    public static void setWriteSupportClass(Job job, Class<?> writeSupportClass) {
        ContextUtil.getConfiguration((JobContext)job).set(WRITE_SUPPORT_CLASS, writeSupportClass.getName());
    }

    public static void setWriteSupportClass(JobConf job, Class<?> writeSupportClass) {
        job.set(WRITE_SUPPORT_CLASS, writeSupportClass.getName());
    }

    public static Class<?> getWriteSupportClass(Configuration configuration) {
        String className = configuration.get(WRITE_SUPPORT_CLASS);
        if (className == null) {
            return null;
        }
        Class<?> writeSupportClass = ConfigurationUtil.getClassFromConfig(configuration, WRITE_SUPPORT_CLASS, WriteSupport.class);
        return writeSupportClass;
    }

    public static void setBlockSize(Job job, int blockSize) {
        ContextUtil.getConfiguration((JobContext)job).setInt(BLOCK_SIZE, blockSize);
    }

    public static void setPageSize(Job job, int pageSize) {
        ContextUtil.getConfiguration((JobContext)job).setInt(PAGE_SIZE, pageSize);
    }

    public static void setDictionaryPageSize(Job job, int pageSize) {
        ContextUtil.getConfiguration((JobContext)job).setInt(DICTIONARY_PAGE_SIZE, pageSize);
    }

    public static void setCompression(Job job, CompressionCodecName compression) {
        ContextUtil.getConfiguration((JobContext)job).set(COMPRESSION, compression.name());
    }

    public static void setEnableDictionary(Job job, boolean enableDictionary) {
        ContextUtil.getConfiguration((JobContext)job).setBoolean(ENABLE_DICTIONARY, enableDictionary);
    }

    public static boolean getEnableDictionary(JobContext jobContext) {
        return ParquetOutputFormat.getEnableDictionary(ContextUtil.getConfiguration(jobContext));
    }

    public static int getBloomFilterMaxBytes(Configuration conf) {
        return conf.getInt(BLOOM_FILTER_MAX_BYTES, 0x100000);
    }

    public static boolean getBloomFilterEnabled(Configuration conf) {
        return conf.getBoolean(BLOOM_FILTER_ENABLED, false);
    }

    public static int getBlockSize(JobContext jobContext) {
        return ParquetOutputFormat.getBlockSize(ContextUtil.getConfiguration(jobContext));
    }

    public static int getPageSize(JobContext jobContext) {
        return ParquetOutputFormat.getPageSize(ContextUtil.getConfiguration(jobContext));
    }

    public static int getDictionaryPageSize(JobContext jobContext) {
        return ParquetOutputFormat.getDictionaryPageSize(ContextUtil.getConfiguration(jobContext));
    }

    public static CompressionCodecName getCompression(JobContext jobContext) {
        return ParquetOutputFormat.getCompression(ContextUtil.getConfiguration(jobContext));
    }

    public static boolean isCompressionSet(JobContext jobContext) {
        return ParquetOutputFormat.isCompressionSet(ContextUtil.getConfiguration(jobContext));
    }

    public static void setValidation(JobContext jobContext, boolean validating) {
        ParquetOutputFormat.setValidation(ContextUtil.getConfiguration(jobContext), validating);
    }

    public static boolean getValidation(JobContext jobContext) {
        return ParquetOutputFormat.getValidation(ContextUtil.getConfiguration(jobContext));
    }

    public static boolean getEnableDictionary(Configuration configuration) {
        return configuration.getBoolean(ENABLE_DICTIONARY, true);
    }

    public static int getMinRowCountForPageSizeCheck(Configuration configuration) {
        return configuration.getInt(MIN_ROW_COUNT_FOR_PAGE_SIZE_CHECK, 100);
    }

    public static int getMaxRowCountForPageSizeCheck(Configuration configuration) {
        return configuration.getInt(MAX_ROW_COUNT_FOR_PAGE_SIZE_CHECK, 10000);
    }

    public static boolean getEstimatePageSizeCheck(Configuration configuration) {
        return configuration.getBoolean(ESTIMATE_PAGE_SIZE_CHECK, true);
    }

    @Deprecated
    public static int getBlockSize(Configuration configuration) {
        return configuration.getInt(BLOCK_SIZE, 0x8000000);
    }

    public static long getLongBlockSize(Configuration configuration) {
        return configuration.getLong(BLOCK_SIZE, 0x8000000L);
    }

    public static int getPageSize(Configuration configuration) {
        return configuration.getInt(PAGE_SIZE, 0x100000);
    }

    public static int getDictionaryPageSize(Configuration configuration) {
        return configuration.getInt(DICTIONARY_PAGE_SIZE, 0x100000);
    }

    public static ParquetProperties.WriterVersion getWriterVersion(Configuration configuration) {
        String writerVersion = configuration.get(WRITER_VERSION, ParquetProperties.DEFAULT_WRITER_VERSION.toString());
        return ParquetProperties.WriterVersion.fromString(writerVersion);
    }

    public static CompressionCodecName getCompression(Configuration configuration) {
        return CodecConfig.getParquetCompressionCodec(configuration);
    }

    public static boolean isCompressionSet(Configuration configuration) {
        return CodecConfig.isParquetCompressionSet(configuration);
    }

    public static void setValidation(Configuration configuration, boolean validating) {
        configuration.setBoolean(VALIDATION, validating);
    }

    public static boolean getValidation(Configuration configuration) {
        return configuration.getBoolean(VALIDATION, false);
    }

    private CompressionCodecName getCodec(TaskAttemptContext taskAttemptContext) {
        return CodecConfig.from(taskAttemptContext).getCodec();
    }

    public static void setMaxPaddingSize(JobContext jobContext, int maxPaddingSize) {
        ParquetOutputFormat.setMaxPaddingSize(ContextUtil.getConfiguration(jobContext), maxPaddingSize);
    }

    public static void setMaxPaddingSize(Configuration conf, int maxPaddingSize) {
        conf.setInt(MAX_PADDING_BYTES, maxPaddingSize);
    }

    private static int getMaxPaddingSize(Configuration conf) {
        return conf.getInt(MAX_PADDING_BYTES, 0x800000);
    }

    public static void setColumnIndexTruncateLength(JobContext jobContext, int length) {
        ParquetOutputFormat.setColumnIndexTruncateLength(ContextUtil.getConfiguration(jobContext), length);
    }

    public static void setColumnIndexTruncateLength(Configuration conf, int length) {
        conf.setInt(COLUMN_INDEX_TRUNCATE_LENGTH, length);
    }

    private static int getColumnIndexTruncateLength(Configuration conf) {
        return conf.getInt(COLUMN_INDEX_TRUNCATE_LENGTH, 64);
    }

    public static void setStatisticsTruncateLength(JobContext jobContext, int length) {
        ParquetOutputFormat.setStatisticsTruncateLength(ContextUtil.getConfiguration(jobContext), length);
    }

    private static void setStatisticsTruncateLength(Configuration conf, int length) {
        conf.setInt(STATISTICS_TRUNCATE_LENGTH, length);
    }

    private static int getStatisticsTruncateLength(Configuration conf) {
        return conf.getInt(STATISTICS_TRUNCATE_LENGTH, Integer.MAX_VALUE);
    }

    public static void setPageRowCountLimit(JobContext jobContext, int rowCount) {
        ParquetOutputFormat.setPageRowCountLimit(ContextUtil.getConfiguration(jobContext), rowCount);
    }

    public static void setPageRowCountLimit(Configuration conf, int rowCount) {
        conf.setInt(PAGE_ROW_COUNT_LIMIT, rowCount);
    }

    private static int getPageRowCountLimit(Configuration conf) {
        return conf.getInt(PAGE_ROW_COUNT_LIMIT, 20000);
    }

    public static void setPageWriteChecksumEnabled(JobContext jobContext, boolean val) {
        ParquetOutputFormat.setPageWriteChecksumEnabled(ContextUtil.getConfiguration(jobContext), val);
    }

    public static void setPageWriteChecksumEnabled(Configuration conf, boolean val) {
        conf.setBoolean(PAGE_WRITE_CHECKSUM_ENABLED, val);
    }

    public static boolean getPageWriteChecksumEnabled(Configuration conf) {
        return conf.getBoolean(PAGE_WRITE_CHECKSUM_ENABLED, true);
    }

    public <S extends WriteSupport<T>> ParquetOutputFormat(S writeSupport) {
        this.writeSupport = writeSupport;
    }

    public <S extends WriteSupport<T>> ParquetOutputFormat() {
    }

    public RecordWriter<Void, T> getRecordWriter(TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        return this.getRecordWriter(taskAttemptContext, ParquetFileWriter.Mode.CREATE);
    }

    public RecordWriter<Void, T> getRecordWriter(TaskAttemptContext taskAttemptContext, ParquetFileWriter.Mode mode) throws IOException, InterruptedException {
        Configuration conf = ContextUtil.getConfiguration((JobContext)taskAttemptContext);
        CompressionCodecName codec = this.getCodec(taskAttemptContext);
        String extension = codec.getExtension() + ".parquet";
        Path file = this.getDefaultWorkFile(taskAttemptContext, extension);
        return this.getRecordWriter(conf, file, codec, mode);
    }

    public RecordWriter<Void, T> getRecordWriter(TaskAttemptContext taskAttemptContext, Path file) throws IOException, InterruptedException {
        return this.getRecordWriter(taskAttemptContext, file, ParquetFileWriter.Mode.CREATE);
    }

    public RecordWriter<Void, T> getRecordWriter(TaskAttemptContext taskAttemptContext, Path file, ParquetFileWriter.Mode mode) throws IOException, InterruptedException {
        return this.getRecordWriter(ContextUtil.getConfiguration((JobContext)taskAttemptContext), file, this.getCodec(taskAttemptContext), mode);
    }

    public RecordWriter<Void, T> getRecordWriter(Configuration conf, Path file, CompressionCodecName codec) throws IOException, InterruptedException {
        return this.getRecordWriter(conf, file, codec, ParquetFileWriter.Mode.CREATE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecordWriter<Void, T> getRecordWriter(Configuration conf, Path file, CompressionCodecName codec, ParquetFileWriter.Mode mode) throws IOException, InterruptedException {
        WriteSupport<T> writeSupport = this.getWriteSupport(conf);
        ParquetProperties.Builder propsBuilder = ParquetProperties.builder().withPageSize(ParquetOutputFormat.getPageSize(conf)).withDictionaryPageSize(ParquetOutputFormat.getDictionaryPageSize(conf)).withDictionaryEncoding(ParquetOutputFormat.getEnableDictionary(conf)).withWriterVersion(ParquetOutputFormat.getWriterVersion(conf)).estimateRowCountForPageSizeCheck(ParquetOutputFormat.getEstimatePageSizeCheck(conf)).withMinRowCountForPageSizeCheck(ParquetOutputFormat.getMinRowCountForPageSizeCheck(conf)).withMaxRowCountForPageSizeCheck(ParquetOutputFormat.getMaxRowCountForPageSizeCheck(conf)).withColumnIndexTruncateLength(ParquetOutputFormat.getColumnIndexTruncateLength(conf)).withStatisticsTruncateLength(ParquetOutputFormat.getStatisticsTruncateLength(conf)).withMaxBloomFilterBytes(ParquetOutputFormat.getBloomFilterMaxBytes(conf)).withBloomFilterEnabled(ParquetOutputFormat.getBloomFilterEnabled(conf)).withPageRowCountLimit(ParquetOutputFormat.getPageRowCountLimit(conf)).withPageWriteChecksumEnabled(ParquetOutputFormat.getPageWriteChecksumEnabled(conf));
        new ColumnConfigParser().withColumnConfig(ENABLE_DICTIONARY, key -> conf.getBoolean(key, false), propsBuilder::withDictionaryEncoding).withColumnConfig(BLOOM_FILTER_ENABLED, key -> conf.getBoolean(key, false), propsBuilder::withBloomFilterEnabled).withColumnConfig(BLOOM_FILTER_EXPECTED_NDV, key -> conf.getLong(key, -1L), propsBuilder::withBloomFilterNDV).withColumnConfig(BLOOM_FILTER_FPP, key -> conf.getDouble(key, 0.01), propsBuilder::withBloomFilterFPP).parseConfig(conf);
        ParquetProperties props = propsBuilder.build();
        long blockSize = ParquetOutputFormat.getLongBlockSize(conf);
        int maxPaddingSize = ParquetOutputFormat.getMaxPaddingSize(conf);
        boolean validating = ParquetOutputFormat.getValidation(conf);
        LOG.info("ParquetRecordWriter [block size: {}b, row group padding size: {}b, validating: {}]", new Object[]{blockSize, maxPaddingSize, validating});
        LOG.debug("Parquet properties are:\n{}", (Object)props);
        WriteSupport.WriteContext fileWriteContext = writeSupport.init(conf);
        FileEncryptionProperties encryptionProperties = ParquetOutputFormat.createEncryptionProperties(conf, file, fileWriteContext);
        ParquetFileWriter w = new ParquetFileWriter((OutputFile)HadoopOutputFile.fromPath(file, conf), fileWriteContext.getSchema(), mode, blockSize, maxPaddingSize, props.getColumnIndexTruncateLength(), props.getStatisticsTruncateLength(), props.getPageWriteChecksumEnabled(), encryptionProperties);
        w.start();
        float maxLoad = conf.getFloat(MEMORY_POOL_RATIO, 0.95f);
        long minAllocation = conf.getLong(MIN_MEMORY_ALLOCATION, 0x100000L);
        Class<ParquetOutputFormat> clazz = ParquetOutputFormat.class;
        synchronized (ParquetOutputFormat.class) {
            if (memoryManager == null) {
                memoryManager = new MemoryManager(maxLoad, minAllocation);
            }
            // ** MonitorExit[var18_16] (shouldn't be in output)
            if (memoryManager.getMemoryPoolRatio() != maxLoad) {
                LOG.warn("The configuration parquet.memory.pool.ratio has been set. It should not be reset by the new value: " + maxLoad);
            }
            return new ParquetRecordWriter<T>(w, writeSupport, fileWriteContext.getSchema(), fileWriteContext.getExtraMetaData(), blockSize, codec, validating, props, memoryManager, conf);
        }
    }

    public WriteSupport<T> getWriteSupport(Configuration configuration) {
        if (this.writeSupport != null) {
            return this.writeSupport;
        }
        Class<?> writeSupportClass = ParquetOutputFormat.getWriteSupportClass(configuration);
        try {
            return (WriteSupport)Objects.requireNonNull(writeSupportClass, "writeSupportClass cannot be null").newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new BadConfigurationException("could not instantiate write support class: " + writeSupportClass, e);
        }
    }

    public OutputCommitter getOutputCommitter(TaskAttemptContext context) throws IOException {
        if (this.committer == null) {
            Path output = ParquetOutputFormat.getOutputPath((JobContext)context);
            this.committer = new ParquetOutputCommitter(output, context);
        }
        return this.committer;
    }

    public static synchronized MemoryManager getMemoryManager() {
        return memoryManager;
    }

    public static FileEncryptionProperties createEncryptionProperties(Configuration fileHadoopConfig, Path tempFilePath, WriteSupport.WriteContext fileWriteContext) {
        EncryptionPropertiesFactory cryptoFactory = EncryptionPropertiesFactory.loadFactory(fileHadoopConfig);
        if (null == cryptoFactory) {
            return null;
        }
        return cryptoFactory.getFileEncryptionProperties(fileHadoopConfig, tempFilePath, fileWriteContext);
    }

    public static enum JobSummaryLevel {
        NONE,
        ALL,
        COMMON_ONLY;

    }
}

