/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.avro;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.avro.AvroSchemaVisitor;
import org.apache.iceberg.avro.LogicalMap;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.shaded.org.apache.avro.LogicalType;
import org.apache.iceberg.shaded.org.apache.avro.LogicalTypes;
import org.apache.iceberg.shaded.org.apache.avro.Schema;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

class SchemaToType
extends AvroSchemaVisitor<Type> {
    private final Schema root;
    private int nextId = 1;

    SchemaToType(Schema root) {
        this.root = root;
        if (root.getType() == Schema.Type.RECORD) {
            this.nextId = root.getFields().size();
        }
    }

    private int getElementId(Schema schema) {
        if (schema.getObjectProp("element-id") != null) {
            return AvroSchemaUtil.getElementId(schema);
        }
        return this.allocateId();
    }

    private int getKeyId(Schema schema) {
        if (schema.getObjectProp("key-id") != null) {
            return AvroSchemaUtil.getKeyId(schema);
        }
        return this.allocateId();
    }

    private int getValueId(Schema schema) {
        if (schema.getObjectProp("value-id") != null) {
            return AvroSchemaUtil.getValueId(schema);
        }
        return this.allocateId();
    }

    private int getId(Schema.Field field) {
        if (field.getObjectProp("field-id") != null) {
            return AvroSchemaUtil.getFieldId(field);
        }
        return this.allocateId();
    }

    private int allocateId() {
        int current = this.nextId++;
        return current;
    }

    @Override
    public Type record(Schema record, List<String> names, List<Type> fieldTypes) {
        List<Schema.Field> fields = record.getFields();
        ArrayList<Types.NestedField> newFields = Lists.newArrayListWithExpectedSize(fields.size());
        if (Objects.equals(this.root, record)) {
            this.nextId = 0;
        }
        for (int i = 0; i < fields.size(); ++i) {
            Schema.Field field = fields.get(i);
            Type fieldType = fieldTypes.get(i);
            int fieldId = this.getId(field);
            if (AvroSchemaUtil.isOptionSchema(field.schema())) {
                newFields.add(Types.NestedField.optional(fieldId, field.name(), fieldType, field.doc()));
                continue;
            }
            newFields.add(Types.NestedField.required(fieldId, field.name(), fieldType, field.doc()));
        }
        return Types.StructType.of(newFields);
    }

    @Override
    public Type union(Schema union, List<Type> options) {
        if (AvroSchemaUtil.isOptionSchema(union)) {
            if (options.get(0) == null) {
                return options.get(1);
            }
            return options.get(0);
        }
        ArrayList<Types.NestedField> fields = Lists.newArrayListWithExpectedSize(options.size());
        int tagIndex = 0;
        fields.add(Types.NestedField.required(this.allocateId(), "tag", Types.IntegerType.get()));
        for (Type option : options) {
            if (option == null) continue;
            fields.add(Types.NestedField.optional(this.allocateId(), "field" + tagIndex, option));
            ++tagIndex;
        }
        return Types.StructType.of(fields);
    }

    @Override
    public Type array(Schema array, Type elementType) {
        if (array.getLogicalType() instanceof LogicalMap) {
            Schema keyValueSchema = array.getElementType();
            Preconditions.checkArgument(AvroSchemaUtil.isKeyValueSchema(keyValueSchema), "Invalid key-value pair schema: %s", (Object)keyValueSchema);
            Types.StructType keyValueType = elementType.asStructType();
            Types.NestedField keyField = keyValueType.field("key");
            Types.NestedField valueField = keyValueType.field("value");
            if (keyValueType.field("value").isOptional()) {
                return Types.MapType.ofOptional(keyField.fieldId(), valueField.fieldId(), keyField.type(), valueField.type());
            }
            return Types.MapType.ofRequired(keyField.fieldId(), valueField.fieldId(), keyField.type(), valueField.type());
        }
        Schema elementSchema = array.getElementType();
        int id = this.getElementId(array);
        if (AvroSchemaUtil.isOptionSchema(elementSchema)) {
            return Types.ListType.ofOptional(id, elementType);
        }
        return Types.ListType.ofRequired(id, elementType);
    }

    @Override
    public Type map(Schema map, Type valueType) {
        Schema valueSchema = map.getValueType();
        int keyId = this.getKeyId(map);
        int valueId = this.getValueId(map);
        if (AvroSchemaUtil.isOptionSchema(valueSchema)) {
            return Types.MapType.ofOptional(keyId, valueId, Types.StringType.get(), valueType);
        }
        return Types.MapType.ofRequired(keyId, valueId, Types.StringType.get(), valueType);
    }

    @Override
    public Type primitive(Schema primitive) {
        LogicalType logical = primitive.getLogicalType();
        if (logical != null) {
            String name = logical.getName();
            if (logical instanceof LogicalTypes.Decimal) {
                return Types.DecimalType.of(((LogicalTypes.Decimal)logical).getPrecision(), ((LogicalTypes.Decimal)logical).getScale());
            }
            if (logical instanceof LogicalTypes.Date) {
                return Types.DateType.get();
            }
            if (logical instanceof LogicalTypes.TimeMillis || logical instanceof LogicalTypes.TimeMicros) {
                return Types.TimeType.get();
            }
            if (logical instanceof LogicalTypes.TimestampMillis || logical instanceof LogicalTypes.TimestampMicros) {
                if (AvroSchemaUtil.isTimestamptz(primitive)) {
                    return Types.TimestampType.withZone();
                }
                return Types.TimestampType.withoutZone();
            }
            if (LogicalTypes.uuid().getName().equals(name)) {
                return Types.UUIDType.get();
            }
        }
        switch (primitive.getType()) {
            case BOOLEAN: {
                return Types.BooleanType.get();
            }
            case INT: {
                return Types.IntegerType.get();
            }
            case LONG: {
                return Types.LongType.get();
            }
            case FLOAT: {
                return Types.FloatType.get();
            }
            case DOUBLE: {
                return Types.DoubleType.get();
            }
            case STRING: 
            case ENUM: {
                return Types.StringType.get();
            }
            case FIXED: {
                return Types.FixedType.ofLength(primitive.getFixedSize());
            }
            case BYTES: {
                return Types.BinaryType.get();
            }
            case NULL: {
                return null;
            }
        }
        throw new UnsupportedOperationException("Unsupported primitive type: " + primitive);
    }
}

