/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.aws;

import java.time.Duration;
import java.util.Map;
import org.apache.iceberg.relocated.com.google.common.annotations.VisibleForTesting;
import org.apache.iceberg.util.PropertyUtil;
import software.amazon.awssdk.awscore.client.builder.AwsSyncClientBuilder;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.apache.ApacheHttpClient;

class ApacheHttpClientConfigurations {
    private Long connectionTimeoutMs;
    private Long socketTimeoutMs;
    private Long acquisitionTimeoutMs;
    private Long connectionMaxIdleTimeMs;
    private Long connectionTimeToLiveMs;
    private Boolean expectContinueEnabled;
    private Integer maxConnections;
    private Boolean tcpKeepAliveEnabled;
    private Boolean useIdleConnectionReaperEnabled;

    private ApacheHttpClientConfigurations() {
    }

    public <T extends AwsSyncClientBuilder> void configureHttpClientBuilder(T awsClientBuilder) {
        ApacheHttpClient.Builder apacheHttpClientBuilder = ApacheHttpClient.builder();
        this.configureApacheHttpClientBuilder(apacheHttpClientBuilder);
        awsClientBuilder.httpClientBuilder((SdkHttpClient.Builder)apacheHttpClientBuilder);
    }

    private void initialize(Map<String, String> httpClientProperties) {
        this.connectionTimeoutMs = PropertyUtil.propertyAsNullableLong(httpClientProperties, "http-client.apache.connection-timeout-ms");
        this.socketTimeoutMs = PropertyUtil.propertyAsNullableLong(httpClientProperties, "http-client.apache.socket-timeout-ms");
        this.acquisitionTimeoutMs = PropertyUtil.propertyAsNullableLong(httpClientProperties, "http-client.apache.connection-acquisition-timeout-ms");
        this.connectionMaxIdleTimeMs = PropertyUtil.propertyAsNullableLong(httpClientProperties, "http-client.apache.connection-max-idle-time-ms");
        this.connectionTimeToLiveMs = PropertyUtil.propertyAsNullableLong(httpClientProperties, "http-client.apache.connection-time-to-live-ms");
        this.expectContinueEnabled = PropertyUtil.propertyAsNullableBoolean(httpClientProperties, "http-client.apache.expect-continue-enabled");
        this.maxConnections = PropertyUtil.propertyAsNullableInt(httpClientProperties, "http-client.apache.max-connections");
        this.tcpKeepAliveEnabled = PropertyUtil.propertyAsNullableBoolean(httpClientProperties, "http-client.apache.tcp-keep-alive-enabled");
        this.useIdleConnectionReaperEnabled = PropertyUtil.propertyAsNullableBoolean(httpClientProperties, "http-client.apache.use-idle-connection-reaper-enabled");
    }

    @VisibleForTesting
    void configureApacheHttpClientBuilder(ApacheHttpClient.Builder apacheHttpClientBuilder) {
        if (this.connectionTimeoutMs != null) {
            apacheHttpClientBuilder.connectionTimeout(Duration.ofMillis(this.connectionTimeoutMs));
        }
        if (this.socketTimeoutMs != null) {
            apacheHttpClientBuilder.socketTimeout(Duration.ofMillis(this.socketTimeoutMs));
        }
        if (this.acquisitionTimeoutMs != null) {
            apacheHttpClientBuilder.connectionAcquisitionTimeout(Duration.ofMillis(this.acquisitionTimeoutMs));
        }
        if (this.connectionMaxIdleTimeMs != null) {
            apacheHttpClientBuilder.connectionMaxIdleTime(Duration.ofMillis(this.connectionMaxIdleTimeMs));
        }
        if (this.connectionTimeToLiveMs != null) {
            apacheHttpClientBuilder.connectionTimeToLive(Duration.ofMillis(this.connectionTimeToLiveMs));
        }
        if (this.expectContinueEnabled != null) {
            apacheHttpClientBuilder.expectContinueEnabled(this.expectContinueEnabled);
        }
        if (this.maxConnections != null) {
            apacheHttpClientBuilder.maxConnections(this.maxConnections);
        }
        if (this.tcpKeepAliveEnabled != null) {
            apacheHttpClientBuilder.tcpKeepAlive(this.tcpKeepAliveEnabled);
        }
        if (this.useIdleConnectionReaperEnabled != null) {
            apacheHttpClientBuilder.useIdleConnectionReaper(this.useIdleConnectionReaperEnabled);
        }
    }

    public static ApacheHttpClientConfigurations create(Map<String, String> properties) {
        ApacheHttpClientConfigurations configurations = new ApacheHttpClientConfigurations();
        configurations.initialize(properties);
        return configurations;
    }
}

