/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.expressions;

import java.util.Comparator;
import java.util.Set;
import org.apache.iceberg.expressions.BoundPredicate;
import org.apache.iceberg.expressions.BoundTerm;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Literal;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.types.Type;

public class BoundLiteralPredicate<T>
extends BoundPredicate<T> {
    private static final Set<Type.TypeID> INTEGRAL_TYPES = Sets.newHashSet(Type.TypeID.INTEGER, Type.TypeID.LONG, Type.TypeID.DATE, Type.TypeID.TIME, Type.TypeID.TIMESTAMP);
    private final Literal<T> literal;

    private static long toLong(Literal<?> lit) {
        return ((Number)lit.value()).longValue();
    }

    BoundLiteralPredicate(Expression.Operation op, BoundTerm<T> term, Literal<T> lit) {
        super(op, term);
        Preconditions.checkArgument(op != Expression.Operation.IN && op != Expression.Operation.NOT_IN, "Bound literal predicate does not support operation: %s", (Object)op);
        this.literal = lit;
    }

    @Override
    public Expression negate() {
        return new BoundLiteralPredicate<T>(this.op().negate(), (BoundTerm)this.term(), this.literal);
    }

    public Literal<T> literal() {
        return this.literal;
    }

    @Override
    public boolean isLiteralPredicate() {
        return true;
    }

    @Override
    public BoundLiteralPredicate<T> asLiteralPredicate() {
        return this;
    }

    @Override
    public boolean test(T value) {
        Comparator<T> cmp = this.literal.comparator();
        switch (this.op()) {
            case LT: {
                return cmp.compare(value, this.literal.value()) < 0;
            }
            case LT_EQ: {
                return cmp.compare(value, this.literal.value()) <= 0;
            }
            case GT: {
                return cmp.compare(value, this.literal.value()) > 0;
            }
            case GT_EQ: {
                return cmp.compare(value, this.literal.value()) >= 0;
            }
            case EQ: {
                return cmp.compare(value, this.literal.value()) == 0;
            }
            case NOT_EQ: {
                return cmp.compare(value, this.literal.value()) != 0;
            }
            case STARTS_WITH: {
                return String.valueOf(value).startsWith((String)this.literal.value());
            }
            case NOT_STARTS_WITH: {
                return !String.valueOf(value).startsWith((String)this.literal.value());
            }
        }
        throw new IllegalStateException("Invalid operation for BoundLiteralPredicate: " + (Object)((Object)this.op()));
    }

    @Override
    public boolean isEquivalentTo(Expression expr) {
        if (this.op() == expr.op()) {
            BoundLiteralPredicate other = (BoundLiteralPredicate)expr;
            if (((BoundTerm)this.term()).isEquivalentTo((BoundTerm)other.term())) {
                Literal<T> otherLiteral = other.literal();
                Comparator<T> cmp = this.literal.comparator();
                return cmp.compare(this.literal.value(), otherLiteral.value()) == 0;
            }
        } else if (expr instanceof BoundLiteralPredicate) {
            BoundLiteralPredicate other = (BoundLiteralPredicate)expr;
            if (INTEGRAL_TYPES.contains((Object)((BoundTerm)this.term()).type().typeId()) && ((BoundTerm)this.term()).isEquivalentTo((BoundTerm)other.term())) {
                switch (this.op()) {
                    case LT: {
                        if (other.op() != Expression.Operation.LT_EQ) break;
                        return BoundLiteralPredicate.toLong(this.literal()) == BoundLiteralPredicate.toLong(other.literal()) + 1L;
                    }
                    case LT_EQ: {
                        if (other.op() != Expression.Operation.LT) break;
                        return BoundLiteralPredicate.toLong(this.literal()) == BoundLiteralPredicate.toLong(other.literal()) - 1L;
                    }
                    case GT: {
                        if (other.op() != Expression.Operation.GT_EQ) break;
                        return BoundLiteralPredicate.toLong(this.literal()) == BoundLiteralPredicate.toLong(other.literal()) - 1L;
                    }
                    case GT_EQ: {
                        if (other.op() != Expression.Operation.GT) break;
                        return BoundLiteralPredicate.toLong(this.literal()) == BoundLiteralPredicate.toLong(other.literal()) + 1L;
                    }
                }
            }
        }
        return false;
    }

    public String toString() {
        switch (this.op()) {
            case LT: {
                return this.term() + " < " + this.literal;
            }
            case LT_EQ: {
                return this.term() + " <= " + this.literal;
            }
            case GT: {
                return this.term() + " > " + this.literal;
            }
            case GT_EQ: {
                return this.term() + " >= " + this.literal;
            }
            case EQ: {
                return this.term() + " == " + this.literal;
            }
            case NOT_EQ: {
                return this.term() + " != " + this.literal;
            }
            case STARTS_WITH: {
                return this.term() + " startsWith \"" + this.literal + "\"";
            }
            case NOT_STARTS_WITH: {
                return this.term() + " notStartsWith \"" + this.literal + "\"";
            }
            case IN: {
                return this.term() + " in { " + this.literal + " }";
            }
            case NOT_IN: {
                return this.term() + " not in { " + this.literal + " }";
            }
        }
        return "Invalid literal predicate: operation = " + (Object)((Object)this.op());
    }
}

