/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink;

import org.apache.flink.api.common.functions.FilterFunction;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.logical.RowType;
import org.apache.iceberg.Schema;
import org.apache.iceberg.expressions.Evaluator;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.flink.FlinkSchemaUtil;
import org.apache.iceberg.flink.RowDataWrapper;
import org.apache.iceberg.types.Types;

public class FlinkSourceFilter
implements FilterFunction<RowData> {
    private final RowType rowType;
    private final Evaluator evaluator;
    private final Types.StructType struct;
    private volatile RowDataWrapper wrapper;

    public FlinkSourceFilter(Schema schema, Expression expr, boolean caseSensitive) {
        this.rowType = FlinkSchemaUtil.convert(schema);
        this.struct = schema.asStruct();
        this.evaluator = new Evaluator(this.struct, expr, caseSensitive);
    }

    public boolean filter(RowData value) {
        if (this.wrapper == null) {
            this.wrapper = new RowDataWrapper(this.rowType, this.struct);
        }
        return this.evaluator.eval(this.wrapper.wrap(value));
    }
}

