/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink;

import java.io.IOException;
import java.util.List;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.logical.RowType;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.PartitionKey;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.flink.FlinkSchemaUtil;
import org.apache.iceberg.flink.RowDataWrapper;
import org.apache.iceberg.flink.data.RowDataProjection;
import org.apache.iceberg.io.BaseTaskWriter;
import org.apache.iceberg.io.FileAppenderFactory;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.OutputFileFactory;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.types.TypeUtil;

abstract class BaseDeltaTaskWriter
extends BaseTaskWriter<RowData> {
    private final Schema schema;
    private final Schema deleteSchema;
    private final RowDataWrapper wrapper;
    private final RowDataWrapper keyWrapper;
    private final RowDataProjection keyProjection;
    private final boolean upsert;

    BaseDeltaTaskWriter(PartitionSpec spec, FileFormat format, FileAppenderFactory<RowData> appenderFactory, OutputFileFactory fileFactory, FileIO io, long targetFileSize, Schema schema, RowType flinkSchema, List<Integer> equalityFieldIds, boolean upsert) {
        super(spec, format, appenderFactory, fileFactory, io, targetFileSize);
        this.schema = schema;
        this.deleteSchema = TypeUtil.select(schema, Sets.newHashSet(equalityFieldIds));
        this.wrapper = new RowDataWrapper(flinkSchema, schema.asStruct());
        this.keyWrapper = new RowDataWrapper(FlinkSchemaUtil.convert(this.deleteSchema), this.deleteSchema.asStruct());
        this.keyProjection = RowDataProjection.create(flinkSchema, schema.asStruct(), this.deleteSchema.asStruct());
        this.upsert = upsert;
    }

    abstract RowDataDeltaWriter route(RowData var1);

    RowDataWrapper wrapper() {
        return this.wrapper;
    }

    @Override
    public void write(RowData row) throws IOException {
        RowDataDeltaWriter writer = this.route(row);
        switch (row.getRowKind()) {
            case INSERT: 
            case UPDATE_AFTER: {
                if (this.upsert) {
                    writer.deleteKey(this.keyProjection.wrap(row));
                }
                writer.write(row);
                break;
            }
            case UPDATE_BEFORE: {
                if (this.upsert) break;
                writer.delete(row);
                break;
            }
            case DELETE: {
                if (this.upsert) {
                    writer.deleteKey(this.keyProjection.wrap(row));
                    break;
                }
                writer.delete(row);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown row kind: " + row.getRowKind());
            }
        }
    }

    protected class RowDataDeltaWriter
    extends BaseTaskWriter.BaseEqualityDeltaWriter {
        RowDataDeltaWriter(PartitionKey partition) {
            super(BaseDeltaTaskWriter.this, partition, BaseDeltaTaskWriter.this.schema, BaseDeltaTaskWriter.this.deleteSchema);
        }

        protected StructLike asStructLike(RowData data) {
            return BaseDeltaTaskWriter.this.wrapper.wrap(data);
        }

        protected StructLike asStructLikeKey(RowData data) {
            return BaseDeltaTaskWriter.this.keyWrapper.wrap(data);
        }
    }
}

