/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink.shuffle;

import java.io.Serializable;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.iceberg.flink.sink.shuffle.DataStatistics;
import org.apache.iceberg.relocated.com.google.common.base.MoreObjects;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;

class AggregatedStatistics<D extends DataStatistics<D, S>, S>
implements Serializable {
    private final long checkpointId;
    private final DataStatistics<D, S> dataStatistics;

    AggregatedStatistics(long checkpoint, TypeSerializer<DataStatistics<D, S>> statisticsSerializer) {
        this.checkpointId = checkpoint;
        this.dataStatistics = (DataStatistics)statisticsSerializer.createInstance();
    }

    AggregatedStatistics(long checkpoint, DataStatistics<D, S> dataStatistics) {
        this.checkpointId = checkpoint;
        this.dataStatistics = dataStatistics;
    }

    long checkpointId() {
        return this.checkpointId;
    }

    DataStatistics<D, S> dataStatistics() {
        return this.dataStatistics;
    }

    void mergeDataStatistic(String operatorName, long eventCheckpointId, D eventDataStatistics) {
        Preconditions.checkArgument(this.checkpointId == eventCheckpointId, "Received unexpected event from operator %s checkpoint %s. Expected checkpoint %s", (Object)operatorName, (Object)eventCheckpointId, (Object)this.checkpointId);
        this.dataStatistics.merge(eventDataStatistics);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("checkpointId", this.checkpointId).add("dataStatistics", this.dataStatistics).toString();
    }
}

