/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink.shuffle;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.operators.coordination.OperatorEvent;
import org.apache.iceberg.flink.sink.shuffle.DataStatistics;
import org.apache.iceberg.flink.sink.shuffle.DataStatisticsUtil;

@Internal
class DataStatisticsEvent<D extends DataStatistics<D, S>, S>
implements OperatorEvent {
    private static final long serialVersionUID = 1L;
    private final long checkpointId;
    private final byte[] statisticsBytes;

    private DataStatisticsEvent(long checkpointId, byte[] statisticsBytes) {
        this.checkpointId = checkpointId;
        this.statisticsBytes = statisticsBytes;
    }

    static <D extends DataStatistics<D, S>, S> DataStatisticsEvent<D, S> create(long checkpointId, DataStatistics<D, S> dataStatistics, TypeSerializer<DataStatistics<D, S>> statisticsSerializer) {
        return new DataStatisticsEvent<D, S>(checkpointId, DataStatisticsUtil.serializeDataStatistics(dataStatistics, statisticsSerializer));
    }

    long checkpointId() {
        return this.checkpointId;
    }

    byte[] statisticsBytes() {
        return this.statisticsBytes;
    }
}

