/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.source;

import java.util.List;
import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.logical.RowType;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.avro.Avro;
import org.apache.iceberg.data.DeleteFilter;
import org.apache.iceberg.encryption.InputFilesDecryptor;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.flink.FlinkSchemaUtil;
import org.apache.iceberg.flink.FlinkSourceFilter;
import org.apache.iceberg.flink.RowDataWrapper;
import org.apache.iceberg.flink.data.FlinkAvroReader;
import org.apache.iceberg.flink.data.FlinkOrcReader;
import org.apache.iceberg.flink.data.FlinkParquetReaders;
import org.apache.iceberg.flink.data.RowDataProjection;
import org.apache.iceberg.flink.data.RowDataUtil;
import org.apache.iceberg.flink.source.FileScanTaskReader;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.mapping.NameMappingParser;
import org.apache.iceberg.orc.ORC;
import org.apache.iceberg.parquet.Parquet;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.shaded.org.apache.orc.TypeDescription;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.util.PartitionUtil;

@Internal
public class RowDataFileScanTaskReader
implements FileScanTaskReader<RowData> {
    private final Schema tableSchema;
    private final Schema projectedSchema;
    private final String nameMapping;
    private final boolean caseSensitive;
    private final FlinkSourceFilter rowFilter;

    public RowDataFileScanTaskReader(Schema tableSchema, Schema projectedSchema, String nameMapping, boolean caseSensitive, List<Expression> filters) {
        this.tableSchema = tableSchema;
        this.projectedSchema = projectedSchema;
        this.nameMapping = nameMapping;
        this.caseSensitive = caseSensitive;
        if (filters != null && !filters.isEmpty()) {
            Expression combinedExpression = filters.stream().reduce(Expressions.alwaysTrue(), Expressions::and);
            this.rowFilter = new FlinkSourceFilter(this.projectedSchema, combinedExpression, this.caseSensitive);
        } else {
            this.rowFilter = null;
        }
    }

    @Override
    public CloseableIterator<RowData> open(FileScanTask task, InputFilesDecryptor inputFilesDecryptor) {
        Schema partitionSchema = TypeUtil.select(this.projectedSchema, task.spec().identitySourceIds());
        ImmutableMap idToConstant = partitionSchema.columns().isEmpty() ? ImmutableMap.of() : PartitionUtil.constantsMap(task, RowDataUtil::convertConstant);
        FlinkDeleteFilter deletes = new FlinkDeleteFilter(task, this.tableSchema, this.projectedSchema, inputFilesDecryptor);
        CloseableIterable<RowData> iterable = deletes.filter(this.newIterable(task, deletes.requiredSchema(), idToConstant, inputFilesDecryptor));
        if (!this.projectedSchema.sameSchema(deletes.requiredSchema())) {
            RowDataProjection rowDataProjection = RowDataProjection.create(deletes.requiredRowType(), deletes.requiredSchema().asStruct(), this.projectedSchema.asStruct());
            iterable = CloseableIterable.transform(iterable, rowDataProjection::wrap);
        }
        return iterable.iterator();
    }

    private CloseableIterable<RowData> newIterable(FileScanTask task, Schema schema, Map<Integer, ?> idToConstant, InputFilesDecryptor inputFilesDecryptor) {
        CloseableIterable<RowData> iter;
        if (task.isDataTask()) {
            throw new UnsupportedOperationException("Cannot read data task.");
        }
        switch (((DataFile)task.file()).format()) {
            case PARQUET: {
                iter = this.newParquetIterable(task, schema, idToConstant, inputFilesDecryptor);
                break;
            }
            case AVRO: {
                iter = this.newAvroIterable(task, schema, idToConstant, inputFilesDecryptor);
                break;
            }
            case ORC: {
                iter = this.newOrcIterable(task, schema, idToConstant, inputFilesDecryptor);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Cannot read unknown format: " + (Object)((Object)((DataFile)task.file()).format()));
            }
        }
        if (this.rowFilter != null) {
            return CloseableIterable.filter(iter, this.rowFilter::filter);
        }
        return iter;
    }

    private CloseableIterable<RowData> newAvroIterable(FileScanTask task, Schema schema, Map<Integer, ?> idToConstant, InputFilesDecryptor inputFilesDecryptor) {
        Avro.ReadBuilder builder = Avro.read(inputFilesDecryptor.getInputFile(task)).reuseContainers().project(schema).split(task.start(), task.length()).createReaderFunc(readSchema -> new FlinkAvroReader(schema, (org.apache.iceberg.shaded.org.apache.avro.Schema)readSchema, idToConstant));
        if (this.nameMapping != null) {
            builder.withNameMapping(NameMappingParser.fromJson(this.nameMapping));
        }
        return builder.build();
    }

    private CloseableIterable<RowData> newParquetIterable(FileScanTask task, Schema schema, Map<Integer, ?> idToConstant, InputFilesDecryptor inputFilesDecryptor) {
        Parquet.ReadBuilder builder = Parquet.read(inputFilesDecryptor.getInputFile(task)).split(task.start(), task.length()).project(schema).createReaderFunc(fileSchema -> FlinkParquetReaders.buildReader(schema, fileSchema, idToConstant)).filter(task.residual()).caseSensitive(this.caseSensitive).reuseContainers();
        if (this.nameMapping != null) {
            builder.withNameMapping(NameMappingParser.fromJson(this.nameMapping));
        }
        return builder.build();
    }

    private CloseableIterable<RowData> newOrcIterable(FileScanTask task, Schema schema, Map<Integer, ?> idToConstant, InputFilesDecryptor inputFilesDecryptor) {
        Schema readSchemaWithoutConstantAndMetadataFields = TypeUtil.selectNot(schema, Sets.union(idToConstant.keySet(), MetadataColumns.metadataFieldIds()));
        ORC.ReadBuilder builder = ORC.read(inputFilesDecryptor.getInputFile(task)).project(readSchemaWithoutConstantAndMetadataFields).split(task.start(), task.length()).createReaderFunc(readOrcSchema -> new FlinkOrcReader(schema, (TypeDescription)readOrcSchema, idToConstant)).filter(task.residual()).caseSensitive(this.caseSensitive);
        if (this.nameMapping != null) {
            builder.withNameMapping(NameMappingParser.fromJson(this.nameMapping));
        }
        return builder.build();
    }

    private static class FlinkDeleteFilter
    extends DeleteFilter<RowData> {
        private final RowType requiredRowType = FlinkSchemaUtil.convert(this.requiredSchema());
        private final RowDataWrapper asStructLike = new RowDataWrapper(this.requiredRowType, this.requiredSchema().asStruct());
        private final InputFilesDecryptor inputFilesDecryptor;

        FlinkDeleteFilter(FileScanTask task, Schema tableSchema, Schema requestedSchema, InputFilesDecryptor inputFilesDecryptor) {
            super(((DataFile)task.file()).path().toString(), task.deletes(), tableSchema, requestedSchema);
            this.inputFilesDecryptor = inputFilesDecryptor;
        }

        public RowType requiredRowType() {
            return this.requiredRowType;
        }

        @Override
        protected StructLike asStructLike(RowData row) {
            return this.asStructLike.wrap(row);
        }

        @Override
        protected InputFile getInputFile(String location) {
            return this.inputFilesDecryptor.getInputFile(location);
        }
    }
}

