/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.parquet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.iceberg.parquet.ParquetSchemaUtil;
import org.apache.iceberg.parquet.ParquetTypeVisitor;
import org.apache.iceberg.relocated.com.google.common.base.Objects;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.shaded.org.apache.parquet.schema.GroupType;
import org.apache.iceberg.shaded.org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.iceberg.shaded.org.apache.parquet.schema.MessageType;
import org.apache.iceberg.shaded.org.apache.parquet.schema.PrimitiveType;
import org.apache.iceberg.shaded.org.apache.parquet.schema.Type;
import org.apache.iceberg.shaded.org.apache.parquet.schema.Types;

class PruneColumns
extends ParquetTypeVisitor<Type> {
    private final Set<Integer> selectedIds;

    PruneColumns(Set<Integer> selectedIds) {
        Preconditions.checkNotNull(selectedIds, "Selected field ids cannot be null");
        this.selectedIds = selectedIds;
    }

    @Override
    public Type message(MessageType message, List<Type> fields) {
        Types.MessageTypeBuilder builder = Types.buildMessage();
        boolean hasChange = false;
        int fieldCount = 0;
        for (int i = 0; i < fields.size(); ++i) {
            Type originalField = message.getType(i);
            Type field = fields.get(i);
            Integer fieldId = this.getId(originalField);
            if (fieldId != null && this.selectedIds.contains(fieldId)) {
                if (field != null) {
                    hasChange = true;
                    builder.addField(field);
                } else if (this.isStruct(originalField)) {
                    hasChange = true;
                    builder.addField(originalField.asGroupType().withNewFields(Collections.emptyList()));
                } else {
                    builder.addField(originalField);
                }
                ++fieldCount;
                continue;
            }
            if (field == null) continue;
            hasChange = true;
            builder.addField(field);
            ++fieldCount;
        }
        if (hasChange) {
            return builder.named(message.getName());
        }
        if (message.getFieldCount() == fieldCount) {
            return message;
        }
        return builder.named(message.getName());
    }

    @Override
    public Type struct(GroupType struct, List<Type> fields) {
        boolean hasChange = false;
        ArrayList<Type> filteredFields = Lists.newArrayListWithExpectedSize(fields.size());
        for (int i = 0; i < fields.size(); ++i) {
            Type originalField = struct.getType(i);
            Type field = fields.get(i);
            Integer fieldId = this.getId(originalField);
            if (fieldId != null && this.selectedIds.contains(fieldId)) {
                filteredFields.add(originalField);
                continue;
            }
            if (field == null) continue;
            filteredFields.add(originalField);
            hasChange = true;
        }
        if (hasChange) {
            return struct.withNewFields(filteredFields);
        }
        if (struct.getFieldCount() == filteredFields.size()) {
            return struct;
        }
        if (!filteredFields.isEmpty()) {
            return struct.withNewFields(filteredFields);
        }
        return null;
    }

    @Override
    public Type list(GroupType list, Type element) {
        Type repeated = list.getType(0);
        Type originalElement = ParquetSchemaUtil.determineListElementType(list);
        Integer elementId = this.getId(originalElement);
        if (elementId != null && this.selectedIds.contains(elementId)) {
            return list;
        }
        if (element != null) {
            if (!Objects.equal(element, originalElement)) {
                if (originalElement.isRepetition(Type.Repetition.REPEATED)) {
                    return list.withNewFields(element);
                }
                return list.withNewFields(repeated.asGroupType().withNewFields(element));
            }
            return list;
        }
        return null;
    }

    @Override
    public Type map(GroupType map, Type key, Type value) {
        GroupType repeated = map.getType(0).asGroupType();
        Type originalKey = repeated.getType(0);
        Type originalValue = repeated.getType(1);
        Integer keyId = this.getId(originalKey);
        Integer valueId = this.getId(originalValue);
        if (keyId != null && this.selectedIds.contains(keyId) || valueId != null && this.selectedIds.contains(valueId)) {
            return map;
        }
        if (value != null) {
            if (!Objects.equal(value, originalValue)) {
                return map.withNewFields(repeated.withNewFields(originalKey, value));
            }
            return map;
        }
        return null;
    }

    @Override
    public Type primitive(PrimitiveType primitive) {
        return null;
    }

    private Integer getId(Type type) {
        return type.getId() == null ? null : Integer.valueOf(type.getId().intValue());
    }

    private boolean isStruct(Type field) {
        if (field.isPrimitive()) {
            return false;
        }
        GroupType groupType = field.asGroupType();
        LogicalTypeAnnotation logicalTypeAnnotation = groupType.getLogicalTypeAnnotation();
        return !LogicalTypeAnnotation.mapType().equals(logicalTypeAnnotation) && !LogicalTypeAnnotation.listType().equals(logicalTypeAnnotation);
    }
}

