/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.api.v2.params;

import javax.annotation.Nullable;
import javax.validation.constraints.Pattern;
import javax.ws.rs.QueryParam;
import org.eclipse.microprofile.openapi.annotations.media.ExampleObject;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;
import org.immutables.builder.Builder;
import org.projectnessie.api.v2.params.AbstractParams;
import org.projectnessie.api.v2.params.CommitLogParamsBuilder;
import org.projectnessie.model.FetchOption;

public class CommitLogParams
extends AbstractParams<CommitLogParams> {
    @Nullable
    @Pattern(regexp="^([0-9a-fA-F]{8,64})?((?:([~*^])([0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}[.][0-9]{1,9}Z|([0-9]+)))*)$", message="Hash with optional relative part must consist of either a valid commit hash (which in turn must consist of the hex representation of 4-32 bytes), or a valid relative part (which must be either '~' + a number representing the n-th predecessor of a commit, '^' + a number representing the n-th parent within a commit, or '*' + a number representing the created timestamp of a commit, in milliseconds since epoch or in ISO-8601 format), or both.")
    @Parameter(description="Hash on the given ref to identify the commit where the operation of fetching the log should stop, i.e. the 'far' end of the commit log, returned late in the result.", examples={@ExampleObject(ref="nullHash"), @ExampleObject(ref="hash")})
    @QueryParam(value="limit-hash")
    private @Pattern(regexp="^([0-9a-fA-F]{8,64})?((?:([~*^])([0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}[.][0-9]{1,9}Z|([0-9]+)))*)$", message="Hash with optional relative part must consist of either a valid commit hash (which in turn must consist of the hex representation of 4-32 bytes), or a valid relative part (which must be either '~' + a number representing the n-th predecessor of a commit, '^' + a number representing the n-th parent within a commit, or '*' + a number representing the created timestamp of a commit, in milliseconds since epoch or in ISO-8601 format), or both.") String startHash;
    @Nullable
    @Parameter(description="A Common Expression Language (CEL) expression. An intro to CEL can be found at https://github.com/google/cel-spec/blob/master/doc/intro.md.\n\nUsable variables within the expression are:\n\n- 'commit' with fields 'author' (string), 'committer' (string), 'commitTime' (timestamp), 'hash' (string), ',message' (string), 'properties' (map)\n\n- 'operations' (list), each operation has the fields 'type' (string, either 'PUT' or 'DELETE'), 'key' (string, namespace + table name), 'keyElements' (list of strings), 'namespace' (string), 'namespaceElements' (list of strings) and 'name' (string, the \"simple\" table name)\n\nNote that the expression can only test against 'operations', if 'fetch' is set to 'ALL'.\n\nHint: when filtering commits, you can determine whether commits are \"missing\" (filtered) by checking whether 'LogEntry.parentCommitHash' is different from the hash of the previous commit in the log response.", examples={@ExampleObject(ref="expr_by_commit_author"), @ExampleObject(ref="expr_by_commit_committer"), @ExampleObject(ref="expr_by_commitTime"), @ExampleObject(ref="expr_by_commit_operations_table_name"), @ExampleObject(ref="expr_by_commit_operations_type")})
    @QueryParam(value="filter")
    private String filter;
    @Parameter(description="Specify how much information to be returned. Will fetch additional metadata such as parent commit hash and operations in a commit, for each commit if set to 'ALL'.")
    @QueryParam(value="fetch")
    @Nullable
    private FetchOption fetchOption;

    public CommitLogParams() {
    }

    @Builder.Constructor
    CommitLogParams(@Nullable String startHash, @Nullable Integer maxRecords, @Nullable String pageToken, @Nullable String filter, @Nullable FetchOption fetchOption) {
        super(maxRecords, pageToken);
        this.startHash = startHash;
        this.filter = filter;
        this.fetchOption = fetchOption;
    }

    @Nullable
    public String startHash() {
        return this.startHash;
    }

    @Nullable
    public String filter() {
        return this.filter;
    }

    @Nullable
    public FetchOption fetchOption() {
        return this.fetchOption;
    }

    public static CommitLogParamsBuilder builder() {
        return new CommitLogParamsBuilder();
    }

    public static CommitLogParams empty() {
        return CommitLogParams.builder().build();
    }

    @Override
    public CommitLogParams forNextPage(String pageToken) {
        return new CommitLogParams(this.startHash, this.maxRecords(), pageToken, this.filter, this.fetchOption);
    }
}

