/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.http;

import java.util.function.Function;
import org.apache.iceberg.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.projectnessie.client.NessieClientBuilder;
import org.projectnessie.client.http.HttpResponseFactory;

public interface NessieHttpClientBuilder
extends NessieClientBuilder {
    @CanIgnoreReturnValue
    public NessieHttpClientBuilder withHttp2Upgrade(boolean var1);

    @CanIgnoreReturnValue
    public NessieHttpClientBuilder withFollowRedirects(String var1);

    @CanIgnoreReturnValue
    public NessieHttpClientBuilder withForceUrlConnectionClient(boolean var1);

    @CanIgnoreReturnValue
    public NessieHttpClientBuilder withResponseFactory(HttpResponseFactory var1);

    public static abstract class AbstractNessieHttpClientBuilder
    extends NessieClientBuilder.AbstractNessieClientBuilder
    implements NessieHttpClientBuilder {
        @Override
        public NessieHttpClientBuilder fromConfig(Function<String, String> configuration) {
            super.fromConfig(configuration);
            String s2 = configuration.apply("nessie.http2-upgrade");
            if (s2 != null) {
                this.withHttp2Upgrade(Boolean.parseBoolean(s2.trim()));
            }
            if ((s2 = configuration.apply("nessie.http-redirects")) != null) {
                this.withFollowRedirects(s2.trim());
            }
            if ((s2 = configuration.apply("nessie.force-url-connection-client")) != null) {
                this.withForceUrlConnectionClient(Boolean.parseBoolean(s2.trim()));
            }
            return this;
        }

        @Override
        public NessieHttpClientBuilder withHttp2Upgrade(boolean http2Upgrade) {
            return this;
        }

        @Override
        public NessieHttpClientBuilder withFollowRedirects(String redirects) {
            return this;
        }

        @Override
        public NessieHttpClientBuilder withForceUrlConnectionClient(boolean forceUrlConnectionClient) {
            return this;
        }

        @Override
        public NessieHttpClientBuilder withResponseFactory(HttpResponseFactory responseFactory) {
            return this;
        }
    }
}

