/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import org.apache.iceberg.ContentFile;
import org.apache.iceberg.ContentScanTask;
import org.apache.iceberg.FixedSizeSplitScanTaskIterator;
import org.apache.iceberg.OffsetsAwareSplitScanTaskIterator;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.SplittableScanTask;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.ResidualEvaluator;
import org.apache.iceberg.relocated.com.google.common.base.MoreObjects;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Ordering;

abstract class BaseContentScanTask<ThisT extends ContentScanTask<F>, F extends ContentFile<F>>
implements ContentScanTask<F>,
SplittableScanTask<ThisT> {
    private static final Ordering<Comparable<Long>> OFFSET_ORDERING = Ordering.natural();
    private final F file;
    private final String schemaString;
    private final String specString;
    private final ResidualEvaluator residuals;
    private volatile transient PartitionSpec spec = null;

    BaseContentScanTask(F file, String schemaString, String specString, ResidualEvaluator residuals) {
        this.file = file;
        this.schemaString = schemaString;
        this.specString = specString;
        this.residuals = residuals;
    }

    protected abstract ThisT self();

    protected abstract ThisT newSplitTask(ThisT var1, long var2, long var4);

    @Override
    public F file() {
        return this.file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PartitionSpec spec() {
        if (this.spec == null) {
            BaseContentScanTask baseContentScanTask = this;
            synchronized (baseContentScanTask) {
                if (this.spec == null) {
                    this.spec = PartitionSpecParser.fromJson(SchemaParser.fromJson(this.schemaString), this.specString);
                }
            }
        }
        return this.spec;
    }

    @Override
    public long start() {
        return 0L;
    }

    @Override
    public long length() {
        return this.file.fileSizeInBytes();
    }

    @Override
    public Expression residual() {
        return this.residuals.residualFor(this.file.partition());
    }

    @Override
    public Iterable<ThisT> split(long targetSplitSize) {
        if (this.file.format().isSplittable()) {
            if (this.file.splitOffsets() != null && OFFSET_ORDERING.isOrdered(this.file.splitOffsets())) {
                return () -> new OffsetsAwareSplitScanTaskIterator<ContentScanTask>((ContentScanTask)this.self(), this.length(), this.file.splitOffsets(), this::newSplitTask);
            }
            return () -> new FixedSizeSplitScanTaskIterator<ContentScanTask>((ContentScanTask)this.self(), this.length(), targetSplitSize, this::newSplitTask);
        }
        return ImmutableList.of(this.self());
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("file", this.file().path()).add("partition_data", this.file().partition()).add("residual", this.residual()).toString();
    }
}

