/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.aws.s3.signer;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.iceberg.aws.s3.signer.S3V4RestSignerClient;
import org.apache.iceberg.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="S3V4RestSignerClient.SignedComponent", generator="Immutables")
@Immutable
final class ImmutableSignedComponent
implements S3V4RestSignerClient.SignedComponent {
    private final Map<String, List<String>> headers;
    private final URI signedURI;

    private ImmutableSignedComponent(Map<String, List<String>> headers, URI signedURI) {
        this.headers = headers;
        this.signedURI = signedURI;
    }

    @Override
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    @Override
    public URI signedURI() {
        return this.signedURI;
    }

    public final ImmutableSignedComponent withHeaders(Map<String, ? extends List<String>> entries) {
        if (this.headers == entries) {
            return this;
        }
        Map<String, List<String>> newValue = ImmutableSignedComponent.createUnmodifiableMap(true, false, entries);
        return new ImmutableSignedComponent(newValue, this.signedURI);
    }

    public final ImmutableSignedComponent withSignedURI(URI value) {
        if (this.signedURI == value) {
            return this;
        }
        URI newValue = Objects.requireNonNull(value, "signedURI");
        return new ImmutableSignedComponent(this.headers, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSignedComponent && this.equalTo(0, (ImmutableSignedComponent)another);
    }

    private boolean equalTo(int synthetic, ImmutableSignedComponent another) {
        return this.headers.equals(another.headers) && this.signedURI.equals(another.signedURI);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.headers.hashCode();
        h2 += (h2 << 5) + this.signedURI.hashCode();
        return h2;
    }

    public String toString() {
        return "SignedComponent{headers=" + this.headers + ", signedURI=" + this.signedURI + "}";
    }

    public static ImmutableSignedComponent copyOf(S3V4RestSignerClient.SignedComponent instance) {
        if (instance instanceof ImmutableSignedComponent) {
            return (ImmutableSignedComponent)instance;
        }
        return ImmutableSignedComponent.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    if (v == null) {
                        Objects.requireNonNull(v, "value for key: " + k);
                    }
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    if (v == null) {
                        Objects.requireNonNull(v, "value for key: " + k);
                    }
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="S3V4RestSignerClient.SignedComponent", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_SIGNED_U_R_I = 1L;
        private long initBits = 1L;
        private Map<String, List<String>> headers = new LinkedHashMap<String, List<String>>();
        @Nullable
        private URI signedURI;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(S3V4RestSignerClient.SignedComponent instance) {
            Objects.requireNonNull(instance, "instance");
            this.putAllHeaders(instance.headers());
            this.signedURI(instance.signedURI());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putHeaders(String key, List<String> value) {
            this.headers.put(Objects.requireNonNull(key, "headers key"), value == null ? Objects.requireNonNull(value, "headers value for key: " + key) : value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putHeaders(Map.Entry<String, ? extends List<String>> entry) {
            List<String> v;
            String k = entry.getKey();
            this.headers.put(Objects.requireNonNull(k, "headers key"), (v = entry.getValue()) == null ? Objects.requireNonNull(v, "headers value for key: " + k) : v);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder headers(Map<String, ? extends List<String>> entries) {
            this.headers.clear();
            return this.putAllHeaders(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllHeaders(Map<String, ? extends List<String>> entries) {
            for (Map.Entry<String, ? extends List<String>> e : entries.entrySet()) {
                List<String> v;
                String k = e.getKey();
                this.headers.put(Objects.requireNonNull(k, "headers key"), (v = e.getValue()) == null ? Objects.requireNonNull(v, "headers value for key: " + k) : v);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder signedURI(URI signedURI) {
            this.signedURI = Objects.requireNonNull(signedURI, "signedURI");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableSignedComponent build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSignedComponent(ImmutableSignedComponent.createUnmodifiableMap(false, false, this.headers), this.signedURI);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("signedURI");
            }
            return "Cannot build SignedComponent, some of required attributes are not set " + attributes;
        }
    }
}

