/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.HasTableOperations;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestFiles;
import org.apache.iceberg.ManifestReader;
import org.apache.iceberg.ManifestWriter;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.flink.sink.DeltaManifests;
import org.apache.iceberg.flink.sink.ManifestOutputFileFactory;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.io.WriteResult;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;

class FlinkManifestUtil {
    private static final int FORMAT_V2 = 2;
    private static final Long DUMMY_SNAPSHOT_ID = 0L;

    private FlinkManifestUtil() {
    }

    static ManifestFile writeDataFiles(OutputFile outputFile, PartitionSpec spec, List<DataFile> dataFiles) throws IOException {
        ManifestWriter<DataFile> writer;
        try (ManifestWriter<DataFile> closeableWriter = writer = ManifestFiles.write(2, spec, outputFile, DUMMY_SNAPSHOT_ID);){
            closeableWriter.addAll(dataFiles);
        }
        return writer.toManifestFile();
    }

    static List<DataFile> readDataFiles(ManifestFile manifestFile, FileIO io, Map<Integer, PartitionSpec> specsById) throws IOException {
        try (ManifestReader<DataFile> dataFiles = ManifestFiles.read(manifestFile, io, specsById);){
            ArrayList<DataFile> arrayList = Lists.newArrayList(dataFiles);
            return arrayList;
        }
    }

    static ManifestOutputFileFactory createOutputFileFactory(Table table, String flinkJobId, String operatorUniqueId, int subTaskId, long attemptNumber) {
        TableOperations ops = ((HasTableOperations)((Object)table)).operations();
        return new ManifestOutputFileFactory(ops, table.io(), table.properties(), flinkJobId, operatorUniqueId, subTaskId, attemptNumber);
    }

    static DeltaManifests writeCompletedFiles(WriteResult result, Supplier<OutputFile> outputFileSupplier, PartitionSpec spec) throws IOException {
        ManifestFile dataManifest = null;
        ManifestFile deleteManifest = null;
        if (result.dataFiles() != null && result.dataFiles().length > 0) {
            dataManifest = FlinkManifestUtil.writeDataFiles(outputFileSupplier.get(), spec, Lists.newArrayList(result.dataFiles()));
        }
        if (result.deleteFiles() != null && result.deleteFiles().length > 0) {
            ManifestWriter<DeleteFile> deleteManifestWriter;
            OutputFile deleteManifestFile = outputFileSupplier.get();
            try (ManifestWriter<DeleteFile> writer = deleteManifestWriter = ManifestFiles.writeDeleteManifest(2, spec, deleteManifestFile, DUMMY_SNAPSHOT_ID);){
                for (DeleteFile deleteFile : result.deleteFiles()) {
                    writer.add(deleteFile);
                }
            }
            deleteManifest = deleteManifestWriter.toManifestFile();
        }
        return new DeltaManifests(dataManifest, deleteManifest, result.referencedDataFiles());
    }

    static WriteResult readCompletedFiles(DeltaManifests deltaManifests, FileIO io, Map<Integer, PartitionSpec> specsById) throws IOException {
        WriteResult.Builder builder = WriteResult.builder();
        if (deltaManifests.dataManifest() != null) {
            builder.addDataFiles(FlinkManifestUtil.readDataFiles(deltaManifests.dataManifest(), io, specsById));
        }
        if (deltaManifests.deleteManifest() != null) {
            try (ManifestReader<DeleteFile> deleteFiles = ManifestFiles.readDeleteManifest(deltaManifests.deleteManifest(), io, specsById);){
                builder.addDeleteFiles(deleteFiles);
            }
        }
        return builder.addReferencedDataFiles(deltaManifests.referencedDataFiles()).build();
    }
}

