/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.source.split;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.connector.source.SourceSplit;
import org.apache.flink.util.InstantiationUtil;
import org.apache.iceberg.CombinedScanTask;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.relocated.com.google.common.base.MoreObjects;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;

@Internal
public class IcebergSourceSplit
implements SourceSplit,
Serializable {
    private static final long serialVersionUID = 1L;
    private final CombinedScanTask task;
    private int fileOffset;
    private long recordOffset;
    @Nullable
    private transient byte[] serializedBytesCache;

    private IcebergSourceSplit(CombinedScanTask task, int fileOffset, long recordOffset) {
        this.task = task;
        this.fileOffset = fileOffset;
        this.recordOffset = recordOffset;
    }

    public static IcebergSourceSplit fromCombinedScanTask(CombinedScanTask combinedScanTask) {
        return IcebergSourceSplit.fromCombinedScanTask(combinedScanTask, 0, 0L);
    }

    public static IcebergSourceSplit fromCombinedScanTask(CombinedScanTask combinedScanTask, int fileOffset, long recordOffset) {
        return new IcebergSourceSplit(combinedScanTask, fileOffset, recordOffset);
    }

    public CombinedScanTask task() {
        return this.task;
    }

    public int fileOffset() {
        return this.fileOffset;
    }

    public long recordOffset() {
        return this.recordOffset;
    }

    public String splitId() {
        return MoreObjects.toStringHelper(this).add("files", this.toString(this.task.files())).toString();
    }

    public void updatePosition(int newFileOffset, long newRecordOffset) {
        this.serializedBytesCache = null;
        this.fileOffset = newFileOffset;
        this.recordOffset = newRecordOffset;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("files", this.toString(this.task.files())).add("fileOffset", this.fileOffset).add("recordOffset", this.recordOffset).toString();
    }

    private String toString(Collection<FileScanTask> files) {
        return Iterables.toString(files.stream().map(fileScanTask -> MoreObjects.toStringHelper(fileScanTask).add("file", ((DataFile)fileScanTask.file()).path().toString()).add("start", fileScanTask.start()).add("length", fileScanTask.length()).toString()).collect(Collectors.toList()));
    }

    byte[] serializeV1() throws IOException {
        if (this.serializedBytesCache == null) {
            this.serializedBytesCache = InstantiationUtil.serializeObject((Object)this);
        }
        return this.serializedBytesCache;
    }

    static IcebergSourceSplit deserializeV1(byte[] serialized) throws IOException {
        try {
            return (IcebergSourceSplit)InstantiationUtil.deserializeObject((byte[])serialized, (ClassLoader)IcebergSourceSplit.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Failed to deserialize the split.", e);
        }
    }
}

