/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.nessie;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import org.apache.iceberg.BaseMetastoreCatalog;
import org.apache.iceberg.CatalogUtil;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.catalog.SupportsNamespaces;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.common.DynMethods;
import org.apache.iceberg.exceptions.NamespaceNotEmptyException;
import org.apache.iceberg.exceptions.NoSuchNamespaceException;
import org.apache.iceberg.hadoop.Configurable;
import org.apache.iceberg.io.CloseableGroup;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.nessie.NessieIcebergClient;
import org.apache.iceberg.nessie.NessieTableOperations;
import org.apache.iceberg.nessie.NessieUtil;
import org.apache.iceberg.relocated.com.google.common.annotations.VisibleForTesting;
import org.apache.iceberg.relocated.com.google.common.base.Joiner;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.projectnessie.client.NessieClientBuilder;
import org.projectnessie.client.api.NessieApiV1;
import org.projectnessie.client.http.HttpClientBuilder;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.Namespace;
import org.projectnessie.model.TableReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NessieCatalog
extends BaseMetastoreCatalog
implements AutoCloseable,
SupportsNamespaces,
Configurable<Object> {
    private static final Logger LOG = LoggerFactory.getLogger(NessieCatalog.class);
    private static final Joiner SLASH = Joiner.on("/");
    private static final String NAMESPACE_LOCATION_PROPS = "location";
    private NessieIcebergClient client;
    private String warehouseLocation;
    private Object config;
    private String name;
    private FileIO fileIO;
    private Map<String, String> catalogOptions;
    private CloseableGroup closeableGroup;

    @Override
    public void initialize(String name, Map<String, String> options) {
        ImmutableMap<String, String> catalogOptions = ImmutableMap.copyOf(options);
        String fileIOImpl = options.getOrDefault("io-impl", "org.apache.iceberg.hadoop.HadoopFileIO");
        Function<String, String> removePrefix = x -> x.replace("nessie.", "");
        String requestedRef = options.get(removePrefix.apply("nessie.ref"));
        String requestedHash = options.get(removePrefix.apply("nessie.ref.hash"));
        NessieApiV1 api = NessieCatalog.createNessieClientBuilder(options.get("nessie.client-builder-impl")).fromConfig(x -> (String)options.get(removePrefix.apply((String)x))).build(NessieApiV1.class);
        this.initialize(name, new NessieIcebergClient(api, requestedRef, requestedHash, catalogOptions), CatalogUtil.loadFileIO(fileIOImpl, options, this.config), catalogOptions);
    }

    public void initialize(String name, NessieIcebergClient client, FileIO fileIO, Map<String, String> catalogOptions) {
        this.name = name == null ? "nessie" : name;
        this.client = Preconditions.checkNotNull(client, "client must be non-null");
        this.fileIO = Preconditions.checkNotNull(fileIO, "fileIO must be non-null");
        this.catalogOptions = Preconditions.checkNotNull(catalogOptions, "catalogOptions must be non-null");
        this.warehouseLocation = this.validateWarehouseLocation(name, catalogOptions);
        this.closeableGroup = new CloseableGroup();
        this.closeableGroup.addCloseable(client);
        this.closeableGroup.addCloseable(fileIO);
        this.closeableGroup.setSuppressCloseFailure(true);
    }

    private String validateWarehouseLocation(String name, Map<String, String> catalogOptions) {
        String warehouseLocation = catalogOptions.get("warehouse");
        if (warehouseLocation == null) {
            LOG.warn("Catalog creation for inputName={} and options {} failed, because parameter 'warehouse' is not set, Nessie can't store data.", (Object)name, catalogOptions);
            throw new IllegalStateException("Parameter 'warehouse' not set, Nessie can't store data.");
        }
        return warehouseLocation;
    }

    private static NessieClientBuilder<?> createNessieClientBuilder(String customBuilder) {
        NessieClientBuilder<HttpClientBuilder> clientBuilder;
        if (customBuilder != null) {
            try {
                clientBuilder = (NessieClientBuilder)DynMethods.builder("builder").impl(customBuilder, new Class[0]).build().asStatic().invoke(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Failed to use custom NessieClientBuilder '%s'.", customBuilder), e);
            }
        } else {
            clientBuilder = HttpClientBuilder.builder();
        }
        return clientBuilder;
    }

    @Override
    public void close() throws IOException {
        if (null != this.closeableGroup) {
            this.closeableGroup.close();
        }
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    protected TableOperations newTableOps(TableIdentifier tableIdentifier) {
        TableReference tr = this.parseTableReference(tableIdentifier);
        return new NessieTableOperations(ContentKey.of(Namespace.of(tableIdentifier.namespace().levels()), tr.getName()), this.client.withReference(tr.getReference(), tr.getHash()), this.fileIO, this.catalogOptions);
    }

    @Override
    protected String defaultWarehouseLocation(TableIdentifier table) {
        String location;
        if (table.hasNamespace()) {
            String baseLocation = SLASH.join(this.warehouseLocation, table.namespace().toString(), new Object[0]);
            try {
                baseLocation = this.loadNamespaceMetadata(table.namespace()).getOrDefault(NAMESPACE_LOCATION_PROPS, baseLocation);
            }
            catch (NoSuchNamespaceException noSuchNamespaceException) {
                // empty catch block
            }
            location = SLASH.join(baseLocation, table.name(), new Object[0]);
        } else {
            location = SLASH.join(this.warehouseLocation, table.name(), new Object[0]);
        }
        return location + "_" + UUID.randomUUID();
    }

    @Override
    public List<TableIdentifier> listTables(org.apache.iceberg.catalog.Namespace namespace) {
        return this.client.listTables(namespace);
    }

    @Override
    public boolean dropTable(TableIdentifier identifier, boolean purge) {
        TableReference tableReference = this.parseTableReference(identifier);
        return this.client.withReference(tableReference.getReference(), tableReference.getHash()).dropTable(this.identifierWithoutTableReference(identifier, tableReference), purge);
    }

    @Override
    public void renameTable(TableIdentifier from, TableIdentifier to) {
        TableReference fromTableReference = this.parseTableReference(from);
        TableReference toTableReference = this.parseTableReference(to);
        String fromReference = fromTableReference.hasReference() ? fromTableReference.getReference() : this.client.getRef().getName();
        String toReference = toTableReference.hasReference() ? toTableReference.getReference() : this.client.getRef().getName();
        Preconditions.checkArgument(fromReference.equalsIgnoreCase(toReference), "from: %s and to: %s reference name must be same", (Object)fromReference, (Object)toReference);
        this.client.withReference(fromTableReference.getReference(), fromTableReference.getHash()).renameTable(this.identifierWithoutTableReference(from, fromTableReference), NessieUtil.removeCatalogName(this.identifierWithoutTableReference(to, toTableReference), this.name()));
    }

    @Override
    public void createNamespace(org.apache.iceberg.catalog.Namespace namespace, Map<String, String> metadata) {
        this.client.createNamespace(namespace, metadata);
    }

    @Override
    public List<org.apache.iceberg.catalog.Namespace> listNamespaces(org.apache.iceberg.catalog.Namespace namespace) throws NoSuchNamespaceException {
        return this.client.listNamespaces(namespace);
    }

    @Override
    public Map<String, String> loadNamespaceMetadata(org.apache.iceberg.catalog.Namespace namespace) throws NoSuchNamespaceException {
        return this.client.loadNamespaceMetadata(namespace);
    }

    @Override
    public boolean dropNamespace(org.apache.iceberg.catalog.Namespace namespace) throws NamespaceNotEmptyException {
        return this.client.dropNamespace(namespace);
    }

    @Override
    public boolean setProperties(org.apache.iceberg.catalog.Namespace namespace, Map<String, String> properties) {
        return this.client.setProperties(namespace, properties);
    }

    @Override
    public boolean removeProperties(org.apache.iceberg.catalog.Namespace namespace, Set<String> properties) {
        return this.client.removeProperties(namespace, properties);
    }

    @Override
    public void setConf(Object conf) {
        this.config = conf;
    }

    @VisibleForTesting
    String currentHash() {
        return this.client.getRef().getHash();
    }

    @VisibleForTesting
    String currentRefName() {
        return this.client.getRef().getName();
    }

    @VisibleForTesting
    FileIO fileIO() {
        return this.fileIO;
    }

    private TableReference parseTableReference(TableIdentifier tableIdentifier) {
        TableReference tr = TableReference.parse(tableIdentifier.name());
        Preconditions.checkArgument(!tr.hasTimestamp(), "Invalid table name: # is only allowed for hashes (reference by timestamp is not supported)");
        return tr;
    }

    private TableIdentifier identifierWithoutTableReference(TableIdentifier identifier, TableReference tableReference) {
        if (tableReference.hasReference()) {
            return TableIdentifier.of(identifier.namespace(), tableReference.getName());
        }
        return identifier;
    }

    @Override
    protected Map<String, String> properties() {
        return this.catalogOptions == null ? ImmutableMap.of() : this.catalogOptions;
    }
}

