/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import org.apache.iceberg.FileCleanupStrategy;
import org.apache.iceberg.ManifestEntry;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestFiles;
import org.apache.iceberg.ManifestReader;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.SnapshotRef;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.util.PropertyUtil;
import org.apache.iceberg.util.SnapshotUtil;
import org.apache.iceberg.util.Tasks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class IncrementalFileCleanup
extends FileCleanupStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(IncrementalFileCleanup.class);

    IncrementalFileCleanup(FileIO fileIO, ExecutorService deleteExecutorService, ExecutorService planExecutorService, Consumer<String> deleteFunc) {
        super(fileIO, deleteExecutorService, planExecutorService, deleteFunc);
    }

    @Override
    public void cleanFiles(TableMetadata beforeExpiration, TableMetadata afterExpiration) {
        if (afterExpiration.refs().size() > 1) {
            throw new UnsupportedOperationException("Cannot incrementally clean files for tables with more than 1 ref");
        }
        HashSet<Long> validIds = Sets.newHashSet();
        for (Snapshot snapshot2 : afterExpiration.snapshots()) {
            validIds.add(snapshot2.snapshotId());
        }
        HashSet<Long> expiredIds = Sets.newHashSet();
        for (Snapshot snapshot3 : beforeExpiration.snapshots()) {
            long snapshotId = snapshot3.snapshotId();
            if (validIds.contains(snapshotId)) continue;
            LOG.info("Expired snapshot: {}", (Object)snapshot3);
            expiredIds.add(snapshotId);
        }
        if (expiredIds.isEmpty()) {
            return;
        }
        SnapshotRef snapshotRef = Iterables.getFirst(beforeExpiration.refs().values(), null);
        if (snapshotRef == null) {
            return;
        }
        Snapshot latest = beforeExpiration.snapshot(snapshotRef.snapshotId());
        List<Snapshot> snapshots = afterExpiration.snapshots();
        HashSet<Long> ancestorIds = Sets.newHashSet(SnapshotUtil.ancestorIds(latest, beforeExpiration::snapshot));
        HashSet<Long> pickedAncestorSnapshotIds = Sets.newHashSet();
        Iterator iterator = ancestorIds.iterator();
        while (iterator.hasNext()) {
            long snapshotId = (Long)iterator.next();
            String sourceSnapshotId = beforeExpiration.snapshot(snapshotId).summary().get("source-snapshot-id");
            if (sourceSnapshotId == null) continue;
            pickedAncestorSnapshotIds.add(Long.parseLong(sourceSnapshotId));
        }
        HashSet validManifests = Sets.newHashSet();
        HashSet<ManifestFile> manifestsToScan = Sets.newHashSet();
        Tasks.foreach(snapshots).retry(3).suppressFailureWhenFinished().onFailure((snapshot, exc) -> LOG.warn("Failed on snapshot {} while reading manifest list: {}", new Object[]{snapshot.snapshotId(), snapshot.manifestListLocation(), exc})).run(snapshot -> {
            try {
                CloseableIterable<ManifestFile> manifests = this.readManifests((Snapshot)snapshot);
                Throwable throwable = null;
                try {
                    for (ManifestFile manifest : manifests) {
                        validManifests.add(manifest.path());
                        long snapshotId = manifest.snapshotId();
                        boolean fromValidSnapshots = validIds.contains(snapshotId);
                        boolean isFromAncestor = ancestorIds.contains(snapshotId);
                        boolean isPicked = pickedAncestorSnapshotIds.contains(snapshotId);
                        if (fromValidSnapshots || !isFromAncestor && !isPicked || !manifest.hasDeletedFiles()) continue;
                        manifestsToScan.add(manifest.copy());
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (manifests != null) {
                        IncrementalFileCleanup.$closeResource(throwable, manifests);
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeIOException(e, "Failed to close manifest list: %s", snapshot.manifestListLocation());
            }
        });
        HashSet<String> manifestListsToDelete = Sets.newHashSet();
        HashSet<String> manifestsToDelete = Sets.newHashSet();
        HashSet<ManifestFile> manifestsToRevert = Sets.newHashSet();
        Tasks.foreach(beforeExpiration.snapshots()).retry(3).suppressFailureWhenFinished().onFailure((snapshot, exc) -> LOG.warn("Failed on snapshot {} while reading manifest list: {}", new Object[]{snapshot.snapshotId(), snapshot.manifestListLocation(), exc})).run(snapshot -> {
            long snapshotId = snapshot.snapshotId();
            if (!validIds.contains(snapshotId)) {
                if (pickedAncestorSnapshotIds.contains(snapshotId)) {
                    return;
                }
                long sourceSnapshotId = PropertyUtil.propertyAsLong(snapshot.summary(), "source-snapshot-id", -1L);
                if (ancestorIds.contains(sourceSnapshotId)) {
                    return;
                }
                if (pickedAncestorSnapshotIds.contains(sourceSnapshotId)) {
                    return;
                }
                try {
                    CloseableIterable<ManifestFile> manifests = this.readManifests((Snapshot)snapshot);
                    Throwable throwable = null;
                    try {
                        for (ManifestFile manifest : manifests) {
                            if (validManifests.contains(manifest.path())) continue;
                            manifestsToDelete.add(manifest.path());
                            boolean isFromAncestor = ancestorIds.contains(manifest.snapshotId());
                            boolean isFromExpiringSnapshot = expiredIds.contains(manifest.snapshotId());
                            if (isFromAncestor && manifest.hasDeletedFiles()) {
                                manifestsToScan.add(manifest.copy());
                            }
                            if (isFromAncestor || !isFromExpiringSnapshot || !manifest.hasAddedFiles()) continue;
                            manifestsToRevert.add(manifest.copy());
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (manifests != null) {
                            IncrementalFileCleanup.$closeResource(throwable, manifests);
                        }
                    }
                }
                catch (IOException e) {
                    throw new RuntimeIOException(e, "Failed to close manifest list: %s", snapshot.manifestListLocation());
                }
                if (snapshot.manifestListLocation() != null) {
                    manifestListsToDelete.add(snapshot.manifestListLocation());
                }
            }
        });
        Set<String> filesToDelete = this.findFilesToDelete(manifestsToScan, manifestsToRevert, validIds, afterExpiration);
        this.deleteFiles(filesToDelete, "data");
        this.deleteFiles(manifestsToDelete, "manifest");
        this.deleteFiles(manifestListsToDelete, "manifest list");
        if (!beforeExpiration.statisticsFiles().isEmpty()) {
            Set<String> expiredStatisticsFilesLocations = this.expiredStatisticsFilesLocations(beforeExpiration, afterExpiration);
            this.deleteFiles(expiredStatisticsFilesLocations, "statistics files");
        }
    }

    private Set<String> findFilesToDelete(Set<ManifestFile> manifestsToScan, Set<ManifestFile> manifestsToRevert, Set<Long> validIds, TableMetadata current) {
        ConcurrentHashMap.KeySetView filesToDelete = ConcurrentHashMap.newKeySet();
        Tasks.foreach(manifestsToScan).retry(3).suppressFailureWhenFinished().executeWith(this.planExecutorService).onFailure((item, exc) -> LOG.warn("Failed to get deleted files: this may cause orphaned data files", (Throwable)exc)).run(manifest -> {
            try {
                ManifestReader<?> reader = ManifestFiles.open(manifest, this.fileIO, current.specsById());
                Throwable throwable = null;
                try {
                    for (ManifestEntry manifestEntry : reader.entries()) {
                        if (manifestEntry.status() != ManifestEntry.Status.DELETED || validIds.contains(manifestEntry.snapshotId())) continue;
                        filesToDelete.add(manifestEntry.file().path().toString());
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (reader != null) {
                        IncrementalFileCleanup.$closeResource(throwable, reader);
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeIOException(e, "Failed to read manifest file: %s", manifest);
            }
        });
        Tasks.foreach(manifestsToRevert).retry(3).suppressFailureWhenFinished().executeWith(this.planExecutorService).onFailure((item, exc) -> LOG.warn("Failed to get added files: this may cause orphaned data files", (Throwable)exc)).run(manifest -> {
            try {
                ManifestReader<?> reader = ManifestFiles.open(manifest, this.fileIO, current.specsById());
                Throwable throwable = null;
                try {
                    for (ManifestEntry manifestEntry : reader.entries()) {
                        if (manifestEntry.status() != ManifestEntry.Status.ADDED) continue;
                        filesToDelete.add(manifestEntry.file().path().toString());
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (reader != null) {
                        IncrementalFileCleanup.$closeResource(throwable, reader);
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeIOException(e, "Failed to read manifest file: %s", manifest);
            }
        });
        return filesToDelete;
    }

    private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
        if (x0 != null) {
            try {
                x1.close();
            }
            catch (Throwable throwable) {
                x0.addSuppressed(throwable);
            }
        } else {
            x1.close();
        }
    }
}

