/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink;

import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.Table;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.flink.CatalogLoader;
import org.apache.iceberg.flink.FlinkCatalogFactory;
import org.apache.iceberg.flink.FlinkEnvironmentContext;
import org.apache.iceberg.hadoop.HadoopTables;
import org.apache.iceberg.hadoop.SerializableConfiguration;
import org.apache.iceberg.relocated.com.google.common.base.MoreObjects;

public interface TableLoader
extends Closeable,
Serializable,
Cloneable {
    public void open();

    public Table loadTable();

    public TableLoader clone();

    public static TableLoader fromCatalog(CatalogLoader catalogLoader, TableIdentifier identifier) {
        return new CatalogTableLoader(catalogLoader, identifier);
    }

    public static TableLoader fromHadoopTable(String location) {
        return TableLoader.fromHadoopTable(location, FlinkCatalogFactory.clusterHadoopConf());
    }

    public static TableLoader fromHadoopTable(String location, Configuration hadoopConf) {
        return new HadoopTableLoader(location, hadoopConf);
    }

    public static class CatalogTableLoader
    implements TableLoader {
        private static final long serialVersionUID = 1L;
        private final CatalogLoader catalogLoader;
        private final String identifier;
        private transient Catalog catalog;

        private CatalogTableLoader(CatalogLoader catalogLoader, TableIdentifier tableIdentifier) {
            this.catalogLoader = catalogLoader;
            this.identifier = tableIdentifier.toString();
        }

        @Override
        public void open() {
            this.catalog = this.catalogLoader.loadCatalog();
        }

        @Override
        public Table loadTable() {
            FlinkEnvironmentContext.init();
            return this.catalog.loadTable(TableIdentifier.parse(this.identifier));
        }

        @Override
        public void close() throws IOException {
            if (this.catalog instanceof Closeable) {
                ((Closeable)((Object)this.catalog)).close();
            }
        }

        @Override
        public TableLoader clone() {
            return new CatalogTableLoader(this.catalogLoader.clone(), TableIdentifier.parse(this.identifier));
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("tableIdentifier", this.identifier).add("catalogLoader", this.catalogLoader).toString();
        }
    }

    public static class HadoopTableLoader
    implements TableLoader {
        private static final long serialVersionUID = 1L;
        private final String location;
        private final SerializableConfiguration hadoopConf;
        private transient HadoopTables tables;

        private HadoopTableLoader(String location, Configuration conf) {
            this.location = location;
            this.hadoopConf = new SerializableConfiguration(conf);
        }

        @Override
        public void open() {
            this.tables = new HadoopTables(this.hadoopConf.get());
        }

        @Override
        public Table loadTable() {
            FlinkEnvironmentContext.init();
            return this.tables.load(this.location);
        }

        @Override
        public TableLoader clone() {
            return new HadoopTableLoader(this.location, new Configuration(this.hadoopConf.get()));
        }

        @Override
        public void close() {
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("location", this.location).toString();
        }
    }
}

