/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.types;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.apache.iceberg.Schema;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;

public abstract class FixupTypes
extends TypeUtil.CustomOrderSchemaVisitor<Type> {
    private final Schema referenceSchema;
    private Type sourceType;

    protected FixupTypes(Schema referenceSchema) {
        this.referenceSchema = referenceSchema;
        this.sourceType = referenceSchema.asStruct();
    }

    @Override
    public Type schema(Schema schema, Supplier<Type> future) {
        this.sourceType = this.referenceSchema.asStruct();
        return future.get();
    }

    @Override
    public Type struct(Types.StructType struct, Iterable<Type> fieldTypes) {
        Preconditions.checkArgument(this.sourceType.isStructType(), "Not a struct: %s", (Object)this.sourceType);
        List<Types.NestedField> fields = struct.fields();
        int length = fields.size();
        ArrayList<Type> types = Lists.newArrayList(fieldTypes);
        ArrayList<Types.NestedField> newFields = Lists.newArrayListWithExpectedSize(length);
        boolean hasChange = false;
        for (int i = 0; i < length; ++i) {
            Types.NestedField field = fields.get(i);
            Type resultType = (Type)types.get(i);
            if (field.type() == resultType) {
                newFields.add(field);
                continue;
            }
            if (field.isRequired()) {
                hasChange = true;
                newFields.add(Types.NestedField.required(field.fieldId(), field.name(), resultType));
                continue;
            }
            hasChange = true;
            newFields.add(Types.NestedField.optional(field.fieldId(), field.name(), resultType));
        }
        if (hasChange) {
            return Types.StructType.of(newFields);
        }
        return struct;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Type field(Types.NestedField field, Supplier<Type> future) {
        Preconditions.checkArgument(this.sourceType.isStructType(), "Not a struct: %s", (Object)this.sourceType);
        Types.StructType sourceStruct = this.sourceType.asStructType();
        Types.NestedField sourceField = sourceStruct.field(field.fieldId());
        if (sourceField != null) {
            this.sourceType = sourceField.type();
            try {
                Type type = future.get();
                return type;
            }
            finally {
                this.sourceType = sourceStruct;
            }
        }
        return field.type();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Type list(Types.ListType list, Supplier<Type> elementTypeFuture) {
        Preconditions.checkArgument(this.sourceType.isListType(), "Not a list: %s", (Object)this.sourceType);
        Types.ListType sourceList = this.sourceType.asListType();
        this.sourceType = sourceList.elementType();
        try {
            Type elementType = elementTypeFuture.get();
            if (list.elementType() == elementType) {
                Types.ListType listType = list;
                return listType;
            }
            if (list.isElementOptional()) {
                Types.ListType listType = Types.ListType.ofOptional(list.elementId(), elementType);
                return listType;
            }
            Types.ListType listType = Types.ListType.ofRequired(list.elementId(), elementType);
            return listType;
        }
        finally {
            this.sourceType = sourceList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Type map(Types.MapType map, Supplier<Type> keyTypeFuture, Supplier<Type> valueTypeFuture) {
        Preconditions.checkArgument(this.sourceType.isMapType(), "Not a map: %s", (Object)this.sourceType);
        Types.MapType sourceMap = this.sourceType.asMapType();
        try {
            this.sourceType = sourceMap.keyType();
            Type keyType = keyTypeFuture.get();
            this.sourceType = sourceMap.valueType();
            Type valueType = valueTypeFuture.get();
            if (map.keyType() == keyType && map.valueType() == valueType) {
                Types.MapType mapType = map;
                return mapType;
            }
            if (map.isValueOptional()) {
                Types.MapType mapType = Types.MapType.ofOptional(map.keyId(), map.valueId(), keyType, valueType);
                return mapType;
            }
            Types.MapType mapType = Types.MapType.ofRequired(map.keyId(), map.valueId(), keyType, valueType);
            return mapType;
        }
        finally {
            this.sourceType = sourceMap;
        }
    }

    @Override
    public Type primitive(Type.PrimitiveType primitive) {
        if (this.sourceType.equals(primitive)) {
            return primitive;
        }
        if (this.fixupPrimitive(primitive, this.sourceType)) {
            return this.sourceType;
        }
        return primitive;
    }

    protected abstract boolean fixupPrimitive(Type.PrimitiveType var1, Type var2);
}

