/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.error;

import java.io.IOException;
import org.projectnessie.error.ErrorCode;
import org.projectnessie.error.ErrorCodeAware;
import org.projectnessie.error.NessieError;

public abstract class BaseNessieClientServerException
extends IOException
implements ErrorCodeAware {
    private final String serverStackTrace;

    protected BaseNessieClientServerException(String message, Throwable cause) {
        super(message, cause);
        this.serverStackTrace = null;
    }

    protected BaseNessieClientServerException(String message) {
        super(message);
        this.serverStackTrace = null;
    }

    protected BaseNessieClientServerException(NessieError error) {
        super(error.getMessage());
        this.serverStackTrace = error.getServerStackTrace();
    }

    public int getStatus() {
        return this.getErrorCode().httpStatus();
    }

    @Override
    public ErrorCode getErrorCode() {
        return ErrorCode.UNKNOWN;
    }

    public String getServerStackTrace() {
        return this.serverStackTrace;
    }
}

