/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model.types;

import java.io.IOException;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonUnwrapped;
import org.apache.iceberg.shaded.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.iceberg.shaded.com.fasterxml.jackson.core.JsonParser;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.JsonDeserializer;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.JsonSerializer;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.immutables.value.Value;
import org.projectnessie.model.Content;
import org.projectnessie.model.types.ImmutableGenericContent;

@JsonSerialize(using=ContentUnknownTypeSerializer.class)
@JsonDeserialize(using=ContentUnknownTypeDeserializer.class)
@Value.Immutable
public abstract class GenericContent
extends Content {
    @Override
    @Value.Parameter(order=1)
    public abstract Content.Type getType();

    @Override
    @Nullable
    @Value.Parameter(order=2)
    public abstract String getId();

    @Nullable
    @Schema(type=SchemaType.OBJECT)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonUnwrapped
    @Value.Parameter(order=3)
    public abstract Map<String, Object> getAttributes();

    public static GenericContent contentUnknownType(String type, String id, Map<String, Object> all) {
        return ImmutableGenericContent.of(new Content.Type(){

            @Override
            public String name() {
                return type;
            }

            @Override
            public Class<? extends Content> type() {
                return GenericContent.class;
            }
        }, id, all);
    }

    static final class ContentUnknownTypeDeserializer
    extends JsonDeserializer<GenericContent> {
        ContentUnknownTypeDeserializer() {
        }

        @Override
        public GenericContent deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            Map all = p.readValueAs(Map.class);
            Object type = all.remove("type");
            Object id = all.remove("id");
            if (type == null) {
                type = "UNKNOWN_CONTENT_TYPE";
            }
            return GenericContent.contentUnknownType(type.toString(), id != null ? id.toString() : null, all);
        }
    }

    static final class ContentUnknownTypeSerializer
    extends JsonSerializer<GenericContent> {
        ContentUnknownTypeSerializer() {
        }

        @Override
        public void serializeWithType(GenericContent value, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
            gen.writeStartObject();
            gen.writeStringField("type", value.getType().name());
            String id = value.getId();
            if (id != null) {
                gen.writeStringField("id", id);
            }
            for (Map.Entry<String, Object> entry : value.getAttributes().entrySet()) {
                gen.writeFieldName(entry.getKey());
                gen.writeObject(entry.getValue());
            }
            gen.writeEndObject();
        }

        @Override
        public void serialize(GenericContent value, JsonGenerator gen, SerializerProvider serializers) {
            throw new UnsupportedOperationException();
        }
    }
}

