/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFiles;
import org.apache.iceberg.MergingSnapshotProducer;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.expressions.Expression;

public class StreamingDelete
extends MergingSnapshotProducer<DeleteFiles>
implements DeleteFiles {
    private boolean validateFilesToDeleteExist = false;

    protected StreamingDelete(String tableName, TableOperations ops) {
        super(tableName, ops);
    }

    @Override
    protected DeleteFiles self() {
        return this;
    }

    @Override
    protected String operation() {
        return "delete";
    }

    @Override
    public StreamingDelete deleteFile(CharSequence path) {
        this.delete(path);
        return this;
    }

    @Override
    public StreamingDelete deleteFile(DataFile file) {
        this.delete(file);
        return this;
    }

    @Override
    public StreamingDelete deleteFromRowFilter(Expression expr) {
        this.deleteByRowFilter(expr);
        return this;
    }

    @Override
    public DeleteFiles validateFilesExist() {
        this.validateFilesToDeleteExist = true;
        return this;
    }

    @Override
    public StreamingDelete toBranch(String branch) {
        this.targetBranch(branch);
        return this;
    }

    @Override
    protected void validate(TableMetadata base, Snapshot parent) {
        if (this.validateFilesToDeleteExist) {
            this.failMissingDeletePaths();
        }
    }
}

