/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink.shuffle;

import java.io.IOException;
import java.util.Objects;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.CompositeTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.table.data.RowData;
import org.apache.iceberg.flink.sink.shuffle.DataStatistics;
import org.apache.iceberg.flink.sink.shuffle.DataStatisticsOrRecord;

@Internal
class DataStatisticsOrRecordSerializer<D extends DataStatistics<D, S>, S>
extends TypeSerializer<DataStatisticsOrRecord<D, S>> {
    private final TypeSerializer<DataStatistics<D, S>> statisticsSerializer;
    private final TypeSerializer<RowData> recordSerializer;

    DataStatisticsOrRecordSerializer(TypeSerializer<DataStatistics<D, S>> statisticsSerializer, TypeSerializer<RowData> recordSerializer) {
        this.statisticsSerializer = statisticsSerializer;
        this.recordSerializer = recordSerializer;
    }

    public boolean isImmutableType() {
        return false;
    }

    public TypeSerializer<DataStatisticsOrRecord<D, S>> duplicate() {
        TypeSerializer duplicateStatisticsSerializer = this.statisticsSerializer.duplicate();
        TypeSerializer duplicateRowDataSerializer = this.recordSerializer.duplicate();
        if (this.statisticsSerializer != duplicateStatisticsSerializer || this.recordSerializer != duplicateRowDataSerializer) {
            return new DataStatisticsOrRecordSerializer<D, S>(duplicateStatisticsSerializer, (TypeSerializer<RowData>)duplicateRowDataSerializer);
        }
        return this;
    }

    public DataStatisticsOrRecord<D, S> createInstance() {
        return DataStatisticsOrRecord.fromRecord((RowData)this.recordSerializer.createInstance());
    }

    public DataStatisticsOrRecord<D, S> copy(DataStatisticsOrRecord<D, S> from) {
        if (from.hasRecord()) {
            return DataStatisticsOrRecord.fromRecord((RowData)this.recordSerializer.copy((Object)from.record()));
        }
        return DataStatisticsOrRecord.fromDataStatistics((DataStatistics)this.statisticsSerializer.copy(from.dataStatistics()));
    }

    public DataStatisticsOrRecord<D, S> copy(DataStatisticsOrRecord<D, S> from, DataStatisticsOrRecord<D, S> reuse) {
        DataStatisticsOrRecord<D, S> to;
        if (from.hasRecord()) {
            to = DataStatisticsOrRecord.reuseRecord(reuse, this.recordSerializer);
            RowData record = (RowData)this.recordSerializer.copy((Object)from.record(), (Object)to.record());
            to.record(record);
        } else {
            to = DataStatisticsOrRecord.reuseStatistics(reuse, this.statisticsSerializer);
            DataStatistics statistics = (DataStatistics)this.statisticsSerializer.copy(from.dataStatistics(), to.dataStatistics());
            to.dataStatistics(statistics);
        }
        return to;
    }

    public int getLength() {
        return -1;
    }

    public void serialize(DataStatisticsOrRecord<D, S> statisticsOrRecord, DataOutputView target) throws IOException {
        if (statisticsOrRecord.hasRecord()) {
            target.writeBoolean(true);
            this.recordSerializer.serialize((Object)statisticsOrRecord.record(), target);
        } else {
            target.writeBoolean(false);
            this.statisticsSerializer.serialize(statisticsOrRecord.dataStatistics(), target);
        }
    }

    public DataStatisticsOrRecord<D, S> deserialize(DataInputView source) throws IOException {
        boolean isRecord = source.readBoolean();
        if (isRecord) {
            return DataStatisticsOrRecord.fromRecord((RowData)this.recordSerializer.deserialize(source));
        }
        return DataStatisticsOrRecord.fromDataStatistics((DataStatistics)this.statisticsSerializer.deserialize(source));
    }

    public DataStatisticsOrRecord<D, S> deserialize(DataStatisticsOrRecord<D, S> reuse, DataInputView source) throws IOException {
        DataStatisticsOrRecord<D, S> to;
        boolean isRecord = source.readBoolean();
        if (isRecord) {
            to = DataStatisticsOrRecord.reuseRecord(reuse, this.recordSerializer);
            RowData record = (RowData)this.recordSerializer.deserialize((Object)to.record(), source);
            to.record(record);
        } else {
            to = DataStatisticsOrRecord.reuseStatistics(reuse, this.statisticsSerializer);
            DataStatistics statistics = (DataStatistics)this.statisticsSerializer.deserialize(to.dataStatistics(), source);
            to.dataStatistics(statistics);
        }
        return to;
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        boolean hasRecord = source.readBoolean();
        target.writeBoolean(hasRecord);
        if (hasRecord) {
            this.recordSerializer.copy(source, target);
        } else {
            this.statisticsSerializer.copy(source, target);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DataStatisticsOrRecordSerializer)) {
            return false;
        }
        DataStatisticsOrRecordSerializer other = (DataStatisticsOrRecordSerializer)((Object)obj);
        return Objects.equals(this.statisticsSerializer, other.statisticsSerializer) && Objects.equals(this.recordSerializer, other.recordSerializer);
    }

    public int hashCode() {
        return Objects.hash(this.statisticsSerializer, this.recordSerializer);
    }

    public TypeSerializerSnapshot<DataStatisticsOrRecord<D, S>> snapshotConfiguration() {
        return new DataStatisticsOrRecordSerializerSnapshot(this);
    }

    public static class DataStatisticsOrRecordSerializerSnapshot<D extends DataStatistics<D, S>, S>
    extends CompositeTypeSerializerSnapshot<DataStatisticsOrRecord<D, S>, DataStatisticsOrRecordSerializer<D, S>> {
        private static final int CURRENT_VERSION = 1;

        public DataStatisticsOrRecordSerializerSnapshot() {
            super(DataStatisticsOrRecordSerializer.class);
        }

        public DataStatisticsOrRecordSerializerSnapshot(DataStatisticsOrRecordSerializer<D, S> serializer) {
            super(serializer);
        }

        protected int getCurrentOuterSnapshotVersion() {
            return 1;
        }

        protected TypeSerializer<?>[] getNestedSerializers(DataStatisticsOrRecordSerializer<D, S> outerSerializer) {
            return new TypeSerializer[]{((DataStatisticsOrRecordSerializer)outerSerializer).statisticsSerializer, ((DataStatisticsOrRecordSerializer)outerSerializer).recordSerializer};
        }

        protected DataStatisticsOrRecordSerializer<D, S> createOuterSerializerWithNestedSerializers(TypeSerializer<?>[] nestedSerializers) {
            TypeSerializer<?> statisticsSerializer = nestedSerializers[0];
            TypeSerializer<?> recordSerializer = nestedSerializers[1];
            return new DataStatisticsOrRecordSerializer(statisticsSerializer, recordSerializer);
        }
    }
}

