/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink.shuffle;

import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.data.RowData;
import org.apache.iceberg.flink.sink.shuffle.DataStatistics;
import org.apache.iceberg.relocated.com.google.common.base.MoreObjects;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;

@Internal
class MapDataStatistics
implements DataStatistics<MapDataStatistics, Map<RowData, Long>> {
    private final Map<RowData, Long> statistics;

    MapDataStatistics() {
        this.statistics = Maps.newHashMap();
    }

    MapDataStatistics(Map<RowData, Long> statistics) {
        this.statistics = statistics;
    }

    @Override
    public boolean isEmpty() {
        return this.statistics.size() == 0;
    }

    @Override
    public void add(RowData key) {
        this.statistics.merge(key, 1L, Long::sum);
    }

    @Override
    public void merge(MapDataStatistics otherStatistics) {
        otherStatistics.statistics().forEach((key, count) -> this.statistics.merge((RowData)key, (Long)count, Long::sum));
    }

    @Override
    public Map<RowData, Long> statistics() {
        return this.statistics;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("statistics", this.statistics).toString();
    }
}

