/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.hive;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.iceberg.Schema;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HiveSchemaConverter {
    private static final Logger LOG = LoggerFactory.getLogger(HiveSchemaConverter.class);
    private int id;
    private boolean autoConvert;

    private HiveSchemaConverter(boolean autoConvert) {
        this.autoConvert = autoConvert;
        this.id = 0;
    }

    static Schema convert(List<String> names, List<TypeInfo> typeInfos, List<String> comments, boolean autoConvert) {
        HiveSchemaConverter converter = new HiveSchemaConverter(autoConvert);
        return new Schema(converter.convertInternal(names, typeInfos, comments));
    }

    static Type convert(TypeInfo typeInfo, boolean autoConvert) {
        HiveSchemaConverter converter = new HiveSchemaConverter(autoConvert);
        return converter.convertType(typeInfo);
    }

    List<Types.NestedField> convertInternal(List<String> names, List<TypeInfo> typeInfos, List<String> comments) {
        ArrayList<Types.NestedField> result = Lists.newArrayListWithExpectedSize(names.size());
        for (int i = 0; i < names.size(); ++i) {
            result.add(Types.NestedField.optional(this.id++, names.get(i), this.convertType(typeInfos.get(i)), comments.isEmpty() || i >= comments.size() ? null : comments.get(i)));
        }
        return result;
    }

    Type convertType(TypeInfo typeInfo) {
        switch (typeInfo.getCategory()) {
            case PRIMITIVE: {
                switch (((PrimitiveTypeInfo)typeInfo).getPrimitiveCategory()) {
                    case FLOAT: {
                        return Types.FloatType.get();
                    }
                    case DOUBLE: {
                        return Types.DoubleType.get();
                    }
                    case BOOLEAN: {
                        return Types.BooleanType.get();
                    }
                    case BYTE: 
                    case SHORT: {
                        Preconditions.checkArgument(this.autoConvert, "Unsupported Hive type: %s, use integer instead", (Object)((PrimitiveTypeInfo)typeInfo).getPrimitiveCategory());
                        LOG.debug("Using auto conversion from SHORT/BYTE to INTEGER");
                        return Types.IntegerType.get();
                    }
                    case INT: {
                        return Types.IntegerType.get();
                    }
                    case LONG: {
                        return Types.LongType.get();
                    }
                    case BINARY: {
                        return Types.BinaryType.get();
                    }
                    case CHAR: 
                    case VARCHAR: {
                        Preconditions.checkArgument(this.autoConvert, "Unsupported Hive type: %s, use string instead", (Object)((PrimitiveTypeInfo)typeInfo).getPrimitiveCategory());
                        LOG.debug("Using auto conversion from CHAR/VARCHAR to STRING");
                        return Types.StringType.get();
                    }
                    case STRING: {
                        return Types.StringType.get();
                    }
                    case TIMESTAMP: {
                        return Types.TimestampType.withoutZone();
                    }
                    case DATE: {
                        return Types.DateType.get();
                    }
                    case DECIMAL: {
                        DecimalTypeInfo decimalTypeInfo = (DecimalTypeInfo)typeInfo;
                        return Types.DecimalType.of(decimalTypeInfo.precision(), decimalTypeInfo.scale());
                    }
                }
                if ("TIMESTAMPLOCALTZ".equalsIgnoreCase(((PrimitiveTypeInfo)typeInfo).getPrimitiveCategory().name())) {
                    return Types.TimestampType.withZone();
                }
                throw new IllegalArgumentException("Unsupported Hive type (" + ((PrimitiveTypeInfo)typeInfo).getPrimitiveCategory() + ") for Iceberg tables.");
            }
            case STRUCT: {
                StructTypeInfo structTypeInfo = (StructTypeInfo)typeInfo;
                List<Types.NestedField> fields = this.convertInternal(structTypeInfo.getAllStructFieldNames(), structTypeInfo.getAllStructFieldTypeInfos(), Collections.emptyList());
                return Types.StructType.of(fields);
            }
            case MAP: {
                MapTypeInfo mapTypeInfo = (MapTypeInfo)typeInfo;
                Type keyType = this.convertType(mapTypeInfo.getMapKeyTypeInfo());
                Type valueType = this.convertType(mapTypeInfo.getMapValueTypeInfo());
                int keyId = this.id++;
                int valueId = this.id++;
                return Types.MapType.ofOptional(keyId, valueId, keyType, valueType);
            }
            case LIST: {
                ListTypeInfo listTypeInfo = (ListTypeInfo)typeInfo;
                Type listType = this.convertType(listTypeInfo.getListElementTypeInfo());
                return Types.ListType.ofOptional(this.id++, listType);
            }
        }
        throw new IllegalArgumentException("Unknown type " + typeInfo.getCategory());
    }
}

