/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.auth.oauth2;

import java.net.URI;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.iceberg.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Generated;
import org.projectnessie.client.auth.oauth2.TokensExchangeRequest;
import org.projectnessie.client.auth.oauth2.TokensRequestBase;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="TokensExchangeRequest", generator="Immutables")
@Immutable
final class ImmutableTokensExchangeRequest
implements TokensExchangeRequest {
    @Nullable
    private final String scope;
    private final String grantType;
    @Nullable
    private final URI resource;
    @Nullable
    private final String audience;
    @Nullable
    private final URI requestedTokenType;
    private final String subjectToken;
    private final URI subjectTokenType;
    @Nullable
    private final String actorToken;
    @Nullable
    private final URI actorTokenType;

    private ImmutableTokensExchangeRequest(Builder builder) {
        this.scope = builder.scope;
        this.resource = builder.resource;
        this.audience = builder.audience;
        this.requestedTokenType = builder.requestedTokenType;
        this.subjectToken = builder.subjectToken;
        this.subjectTokenType = builder.subjectTokenType;
        this.actorToken = builder.actorToken;
        this.actorTokenType = builder.actorTokenType;
        this.grantType = builder.grantType != null ? builder.grantType : Objects.requireNonNull(TokensExchangeRequest.super.getGrantType(), "grantType");
    }

    private ImmutableTokensExchangeRequest(@Nullable String scope, String grantType, @Nullable URI resource, @Nullable String audience, @Nullable URI requestedTokenType, String subjectToken, URI subjectTokenType, @Nullable String actorToken, @Nullable URI actorTokenType) {
        this.scope = scope;
        this.grantType = grantType;
        this.resource = resource;
        this.audience = audience;
        this.requestedTokenType = requestedTokenType;
        this.subjectToken = subjectToken;
        this.subjectTokenType = subjectTokenType;
        this.actorToken = actorToken;
        this.actorTokenType = actorTokenType;
    }

    @Override
    @JsonProperty(value="scope")
    @Nullable
    public String getScope() {
        return this.scope;
    }

    @Override
    @JsonProperty(value="grant_type")
    public String getGrantType() {
        return this.grantType;
    }

    @Override
    @JsonProperty(value="resource")
    @Nullable
    public URI getResource() {
        return this.resource;
    }

    @Override
    @JsonProperty(value="audience")
    @Nullable
    public String getAudience() {
        return this.audience;
    }

    @Override
    @JsonProperty(value="requested_token_type")
    @Nullable
    public URI getRequestedTokenType() {
        return this.requestedTokenType;
    }

    @Override
    @JsonProperty(value="subject_token")
    public String getSubjectToken() {
        return this.subjectToken;
    }

    @Override
    @JsonProperty(value="subject_token_type")
    public URI getSubjectTokenType() {
        return this.subjectTokenType;
    }

    @Override
    @JsonProperty(value="actor_token")
    @Nullable
    public String getActorToken() {
        return this.actorToken;
    }

    @Override
    @JsonProperty(value="actor_token_type")
    @Nullable
    public URI getActorTokenType() {
        return this.actorTokenType;
    }

    public final ImmutableTokensExchangeRequest withScope(@Nullable String value) {
        if (Objects.equals(this.scope, value)) {
            return this;
        }
        return new ImmutableTokensExchangeRequest(value, this.grantType, this.resource, this.audience, this.requestedTokenType, this.subjectToken, this.subjectTokenType, this.actorToken, this.actorTokenType);
    }

    public final ImmutableTokensExchangeRequest withGrantType(String value) {
        String newValue = Objects.requireNonNull(value, "grantType");
        if (this.grantType.equals(newValue)) {
            return this;
        }
        return new ImmutableTokensExchangeRequest(this.scope, newValue, this.resource, this.audience, this.requestedTokenType, this.subjectToken, this.subjectTokenType, this.actorToken, this.actorTokenType);
    }

    public final ImmutableTokensExchangeRequest withResource(@Nullable URI value) {
        if (this.resource == value) {
            return this;
        }
        return new ImmutableTokensExchangeRequest(this.scope, this.grantType, value, this.audience, this.requestedTokenType, this.subjectToken, this.subjectTokenType, this.actorToken, this.actorTokenType);
    }

    public final ImmutableTokensExchangeRequest withAudience(@Nullable String value) {
        if (Objects.equals(this.audience, value)) {
            return this;
        }
        return new ImmutableTokensExchangeRequest(this.scope, this.grantType, this.resource, value, this.requestedTokenType, this.subjectToken, this.subjectTokenType, this.actorToken, this.actorTokenType);
    }

    public final ImmutableTokensExchangeRequest withRequestedTokenType(@Nullable URI value) {
        if (this.requestedTokenType == value) {
            return this;
        }
        return new ImmutableTokensExchangeRequest(this.scope, this.grantType, this.resource, this.audience, value, this.subjectToken, this.subjectTokenType, this.actorToken, this.actorTokenType);
    }

    public final ImmutableTokensExchangeRequest withSubjectToken(String value) {
        String newValue = Objects.requireNonNull(value, "subjectToken");
        if (this.subjectToken.equals(newValue)) {
            return this;
        }
        return new ImmutableTokensExchangeRequest(this.scope, this.grantType, this.resource, this.audience, this.requestedTokenType, newValue, this.subjectTokenType, this.actorToken, this.actorTokenType);
    }

    public final ImmutableTokensExchangeRequest withSubjectTokenType(URI value) {
        if (this.subjectTokenType == value) {
            return this;
        }
        URI newValue = Objects.requireNonNull(value, "subjectTokenType");
        return new ImmutableTokensExchangeRequest(this.scope, this.grantType, this.resource, this.audience, this.requestedTokenType, this.subjectToken, newValue, this.actorToken, this.actorTokenType);
    }

    public final ImmutableTokensExchangeRequest withActorToken(@Nullable String value) {
        if (Objects.equals(this.actorToken, value)) {
            return this;
        }
        return new ImmutableTokensExchangeRequest(this.scope, this.grantType, this.resource, this.audience, this.requestedTokenType, this.subjectToken, this.subjectTokenType, value, this.actorTokenType);
    }

    public final ImmutableTokensExchangeRequest withActorTokenType(@Nullable URI value) {
        if (this.actorTokenType == value) {
            return this;
        }
        return new ImmutableTokensExchangeRequest(this.scope, this.grantType, this.resource, this.audience, this.requestedTokenType, this.subjectToken, this.subjectTokenType, this.actorToken, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTokensExchangeRequest && this.equalTo(0, (ImmutableTokensExchangeRequest)another);
    }

    private boolean equalTo(int synthetic, ImmutableTokensExchangeRequest another) {
        return Objects.equals(this.scope, another.scope) && this.grantType.equals(another.grantType) && Objects.equals(this.resource, another.resource) && Objects.equals(this.audience, another.audience) && Objects.equals(this.requestedTokenType, another.requestedTokenType) && this.subjectToken.equals(another.subjectToken) && this.subjectTokenType.equals(another.subjectTokenType) && Objects.equals(this.actorToken, another.actorToken) && Objects.equals(this.actorTokenType, another.actorTokenType);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + Objects.hashCode(this.scope);
        h2 += (h2 << 5) + this.grantType.hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.resource);
        h2 += (h2 << 5) + Objects.hashCode(this.audience);
        h2 += (h2 << 5) + Objects.hashCode(this.requestedTokenType);
        h2 += (h2 << 5) + this.subjectToken.hashCode();
        h2 += (h2 << 5) + this.subjectTokenType.hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.actorToken);
        h2 += (h2 << 5) + Objects.hashCode(this.actorTokenType);
        return h2;
    }

    public String toString() {
        return "TokensExchangeRequest{scope=" + this.scope + ", grantType=" + this.grantType + ", resource=" + this.resource + ", audience=" + this.audience + ", requestedTokenType=" + this.requestedTokenType + ", subjectToken=" + this.subjectToken + ", subjectTokenType=" + this.subjectTokenType + ", actorToken=" + this.actorToken + ", actorTokenType=" + this.actorTokenType + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableTokensExchangeRequest fromJson(Json json) {
        Builder builder = ImmutableTokensExchangeRequest.builder();
        if (json.scope != null) {
            builder.scope(json.scope);
        }
        if (json.grantType != null) {
            builder.grantType(json.grantType);
        }
        if (json.resource != null) {
            builder.resource(json.resource);
        }
        if (json.audience != null) {
            builder.audience(json.audience);
        }
        if (json.requestedTokenType != null) {
            builder.requestedTokenType(json.requestedTokenType);
        }
        if (json.subjectToken != null) {
            builder.subjectToken(json.subjectToken);
        }
        if (json.subjectTokenType != null) {
            builder.subjectTokenType(json.subjectTokenType);
        }
        if (json.actorToken != null) {
            builder.actorToken(json.actorToken);
        }
        if (json.actorTokenType != null) {
            builder.actorTokenType(json.actorTokenType);
        }
        return builder.build();
    }

    public static ImmutableTokensExchangeRequest copyOf(TokensExchangeRequest instance) {
        if (instance instanceof ImmutableTokensExchangeRequest) {
            return (ImmutableTokensExchangeRequest)instance;
        }
        return ImmutableTokensExchangeRequest.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TokensExchangeRequest", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_SUBJECT_TOKEN = 1L;
        private static final long INIT_BIT_SUBJECT_TOKEN_TYPE = 2L;
        private long initBits = 3L;
        @Nullable
        private String scope;
        @Nullable
        private String grantType;
        @Nullable
        private URI resource;
        @Nullable
        private String audience;
        @Nullable
        private URI requestedTokenType;
        @Nullable
        private String subjectToken;
        @Nullable
        private URI subjectTokenType;
        @Nullable
        private String actorToken;
        @Nullable
        private URI actorTokenType;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(TokensExchangeRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(TokensRequestBase instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TokensRequestBase instance;
            long bits = 0L;
            if (object instanceof TokensExchangeRequest) {
                URI actorTokenTypeValue;
                URI requestedTokenTypeValue;
                String actorTokenValue;
                instance = (TokensExchangeRequest)object;
                String audienceValue = instance.getAudience();
                if (audienceValue != null) {
                    this.audience(audienceValue);
                }
                this.subjectTokenType(instance.getSubjectTokenType());
                URI resourceValue = instance.getResource();
                if (resourceValue != null) {
                    this.resource(resourceValue);
                }
                this.subjectToken(instance.getSubjectToken());
                if ((bits & 1L) == 0L) {
                    String scopeValue = instance.getScope();
                    if (scopeValue != null) {
                        this.scope(scopeValue);
                    }
                    bits |= 1L;
                }
                if ((actorTokenValue = instance.getActorToken()) != null) {
                    this.actorToken(actorTokenValue);
                }
                if ((requestedTokenTypeValue = instance.getRequestedTokenType()) != null) {
                    this.requestedTokenType(requestedTokenTypeValue);
                }
                if ((bits & 2L) == 0L) {
                    this.grantType(instance.getGrantType());
                    bits |= 2L;
                }
                if ((actorTokenTypeValue = instance.getActorTokenType()) != null) {
                    this.actorTokenType(actorTokenTypeValue);
                }
            }
            if (object instanceof TokensRequestBase) {
                instance = (TokensRequestBase)object;
                if ((bits & 2L) == 0L) {
                    this.grantType(instance.getGrantType());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    String scopeValue = instance.getScope();
                    if (scopeValue != null) {
                        this.scope(scopeValue);
                    }
                    bits |= 1L;
                }
            }
        }

        @JsonProperty(value="scope")
        @CanIgnoreReturnValue
        public final Builder scope(@Nullable String scope) {
            this.scope = scope;
            return this;
        }

        @JsonProperty(value="grant_type")
        @CanIgnoreReturnValue
        public final Builder grantType(String grantType) {
            this.grantType = Objects.requireNonNull(grantType, "grantType");
            return this;
        }

        @JsonProperty(value="resource")
        @CanIgnoreReturnValue
        public final Builder resource(@Nullable URI resource) {
            this.resource = resource;
            return this;
        }

        @JsonProperty(value="audience")
        @CanIgnoreReturnValue
        public final Builder audience(@Nullable String audience) {
            this.audience = audience;
            return this;
        }

        @JsonProperty(value="requested_token_type")
        @CanIgnoreReturnValue
        public final Builder requestedTokenType(@Nullable URI requestedTokenType) {
            this.requestedTokenType = requestedTokenType;
            return this;
        }

        @JsonProperty(value="subject_token")
        @CanIgnoreReturnValue
        public final Builder subjectToken(String subjectToken) {
            this.subjectToken = Objects.requireNonNull(subjectToken, "subjectToken");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="subject_token_type")
        @CanIgnoreReturnValue
        public final Builder subjectTokenType(URI subjectTokenType) {
            this.subjectTokenType = Objects.requireNonNull(subjectTokenType, "subjectTokenType");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="actor_token")
        @CanIgnoreReturnValue
        public final Builder actorToken(@Nullable String actorToken) {
            this.actorToken = actorToken;
            return this;
        }

        @JsonProperty(value="actor_token_type")
        @CanIgnoreReturnValue
        public final Builder actorTokenType(@Nullable URI actorTokenType) {
            this.actorTokenType = actorTokenType;
            return this;
        }

        public ImmutableTokensExchangeRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTokensExchangeRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("subjectToken");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("subjectTokenType");
            }
            return "Cannot build TokensExchangeRequest, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="TokensExchangeRequest", generator="Immutables")
    static final class Json
    implements TokensExchangeRequest {
        @Nullable
        String scope;
        @Nullable
        String grantType;
        @Nullable
        URI resource;
        @Nullable
        String audience;
        @Nullable
        URI requestedTokenType;
        @Nullable
        String subjectToken;
        @Nullable
        URI subjectTokenType;
        @Nullable
        String actorToken;
        @Nullable
        URI actorTokenType;

        Json() {
        }

        @JsonProperty(value="scope")
        public void setScope(@Nullable String scope) {
            this.scope = scope;
        }

        @JsonProperty(value="grant_type")
        public void setGrantType(String grantType) {
            this.grantType = grantType;
        }

        @JsonProperty(value="resource")
        public void setResource(@Nullable URI resource) {
            this.resource = resource;
        }

        @JsonProperty(value="audience")
        public void setAudience(@Nullable String audience) {
            this.audience = audience;
        }

        @JsonProperty(value="requested_token_type")
        public void setRequestedTokenType(@Nullable URI requestedTokenType) {
            this.requestedTokenType = requestedTokenType;
        }

        @JsonProperty(value="subject_token")
        public void setSubjectToken(String subjectToken) {
            this.subjectToken = subjectToken;
        }

        @JsonProperty(value="subject_token_type")
        public void setSubjectTokenType(URI subjectTokenType) {
            this.subjectTokenType = subjectTokenType;
        }

        @JsonProperty(value="actor_token")
        public void setActorToken(@Nullable String actorToken) {
            this.actorToken = actorToken;
        }

        @JsonProperty(value="actor_token_type")
        public void setActorTokenType(@Nullable URI actorTokenType) {
            this.actorTokenType = actorTokenType;
        }

        @Override
        public String getScope() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getGrantType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI getResource() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getAudience() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI getRequestedTokenType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getSubjectToken() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI getSubjectTokenType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getActorToken() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI getActorTokenType() {
            throw new UnsupportedOperationException();
        }
    }
}

