/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.auth.oauth2;

import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import org.apache.iceberg.shaded.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.iceberg.shaded.com.fasterxml.jackson.core.JsonParser;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.ser.std.StdSerializer;

class JacksonSerializers {
    private JacksonSerializers() {
    }

    static class SecondsToInstantDeserializer
    extends StdDeserializer<Instant> {
        public SecondsToInstantDeserializer() {
            super(Instant.class);
        }

        @Override
        public Instant deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            if (p.currentToken().isNumeric()) {
                int seconds = p.getValueAsInt();
                return Instant.now().plusSeconds(seconds);
            }
            return null;
        }
    }

    static class InstantToSecondsSerializer
    extends StdSerializer<Instant> {
        public InstantToSecondsSerializer() {
            super(Instant.class);
        }

        @Override
        public void serialize(Instant value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            if (value == null) {
                gen.writeNull();
            } else {
                gen.writeNumber(Duration.between(Instant.now(), value).getSeconds());
            }
        }
    }
}

