/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink.shuffle;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputSerializer;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.iceberg.flink.sink.shuffle.AggregatedStatistics;
import org.apache.iceberg.flink.sink.shuffle.DataStatistics;

class DataStatisticsUtil {
    private DataStatisticsUtil() {
    }

    static <D extends DataStatistics<D, S>, S> byte[] serializeDataStatistics(DataStatistics<D, S> dataStatistics, TypeSerializer<DataStatistics<D, S>> statisticsSerializer) {
        DataOutputSerializer out = new DataOutputSerializer(64);
        try {
            statisticsSerializer.serialize(dataStatistics, (DataOutputView)out);
            return out.getCopyOfBuffer();
        }
        catch (IOException e) {
            throw new IllegalStateException("Fail to serialize data statistics", e);
        }
    }

    static <D extends DataStatistics<D, S>, S> D deserializeDataStatistics(byte[] bytes, TypeSerializer<DataStatistics<D, S>> statisticsSerializer) {
        DataInputDeserializer input = new DataInputDeserializer(bytes, 0, bytes.length);
        try {
            return (D)((DataStatistics)statisticsSerializer.deserialize((DataInputView)input));
        }
        catch (IOException e) {
            throw new IllegalStateException("Fail to deserialize data statistics", e);
        }
    }

    static <D extends DataStatistics<D, S>, S> byte[] serializeAggregatedStatistics(AggregatedStatistics<D, S> aggregatedStatistics, TypeSerializer<DataStatistics<D, S>> statisticsSerializer) throws IOException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bytes);
        DataOutputSerializer outSerializer = new DataOutputSerializer(64);
        out.writeLong(aggregatedStatistics.checkpointId());
        statisticsSerializer.serialize(aggregatedStatistics.dataStatistics(), (DataOutputView)outSerializer);
        byte[] statisticsBytes = outSerializer.getCopyOfBuffer();
        out.writeInt(statisticsBytes.length);
        out.write(statisticsBytes);
        out.flush();
        return bytes.toByteArray();
    }

    static <D extends DataStatistics<D, S>, S> AggregatedStatistics<D, S> deserializeAggregatedStatistics(byte[] bytes, TypeSerializer<DataStatistics<D, S>> statisticsSerializer) throws IOException {
        ByteArrayInputStream bytesIn = new ByteArrayInputStream(bytes);
        ObjectInputStream in = new ObjectInputStream(bytesIn);
        long completedCheckpointId = in.readLong();
        int statisticsBytesLength = in.readInt();
        byte[] statisticsBytes = new byte[statisticsBytesLength];
        in.readFully(statisticsBytes);
        DataInputDeserializer input = new DataInputDeserializer(statisticsBytes, 0, statisticsBytesLength);
        DataStatistics dataStatistics = (DataStatistics)statisticsSerializer.deserialize((DataInputView)input);
        return new AggregatedStatistics(completedCheckpointId, dataStatistics);
    }
}

