/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.nessie;

import org.apache.iceberg.BaseMetastoreTableOperations;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableMetadataParser;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.nessie.NessieIcebergClient;
import org.apache.iceberg.nessie.NessieUtil;
import org.projectnessie.client.api.GetContentBuilder;
import org.projectnessie.client.http.HttpClientException;
import org.projectnessie.error.NessieBadRequestException;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.error.NessieContentNotFoundException;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.IcebergTable;
import org.projectnessie.model.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NessieTableOperations
extends BaseMetastoreTableOperations {
    private static final Logger LOG = LoggerFactory.getLogger(NessieTableOperations.class);
    public static final String NESSIE_COMMIT_ID_PROPERTY = "nessie.commit.id";
    public static final String NESSIE_GC_NO_WARNING_PROPERTY = "nessie.gc.no-warning";
    private final NessieIcebergClient client;
    private final ContentKey key;
    private IcebergTable table;
    private final FileIO fileIO;

    NessieTableOperations(ContentKey key, NessieIcebergClient client, FileIO fileIO) {
        this.key = key;
        this.client = client;
        this.fileIO = fileIO;
    }

    @Override
    protected String tableName() {
        return this.key.toString();
    }

    @Override
    protected void doRefresh() {
        Reference reference;
        String metadataLocation;
        block7: {
            try {
                this.client.refresh();
            }
            catch (NessieNotFoundException e) {
                throw new RuntimeException(String.format("Failed to refresh as ref '%s' is no longer valid.", this.client.getRef().getName()), e);
            }
            metadataLocation = null;
            reference = this.client.getRef().getReference();
            try {
                Content content = ((GetContentBuilder)this.client.getApi().getContent().key(this.key).reference(reference)).get().get(this.key);
                LOG.debug("Content '{}' at '{}': {}", new Object[]{this.key, reference, content});
                if (content == null) {
                    if (this.currentMetadataLocation() != null) {
                        throw new NoSuchTableException("No such table '%s' in '%s'", this.key, reference);
                    }
                } else {
                    this.table = content.unwrap(IcebergTable.class).orElseThrow(() -> new NessieContentNotFoundException(this.key, reference.getName()));
                    metadataLocation = this.table.getMetadataLocation();
                }
            }
            catch (NessieNotFoundException ex) {
                if (this.currentMetadataLocation() == null) break block7;
                throw new NoSuchTableException(ex, "No such table '%s'", this.key);
            }
        }
        this.refreshFromMetadataLocation(metadataLocation, null, 2, location -> NessieUtil.updateTableMetadataWithNessieSpecificProperties(TableMetadataParser.read(this.fileIO, location), location, this.table, this.key.toString(), reference));
    }

    @Override
    protected void doCommit(TableMetadata base, TableMetadata metadata) {
        boolean newTable = base == null;
        String newMetadataLocation = this.writeNewMetadataIfRequired(newTable, metadata);
        boolean failure = false;
        try {
            String contentId = this.table == null ? null : this.table.getId();
            this.client.commitTable(base, metadata, newMetadataLocation, contentId, this.key);
        }
        catch (HttpClientException | NessieConflictException | NessieNotFoundException ex) {
            if (ex instanceof NessieConflictException || ex instanceof NessieNotFoundException) {
                failure = true;
            }
            NessieUtil.handleExceptionsForCommits(ex, this.client.refName(), Content.Type.ICEBERG_TABLE).ifPresent(exception -> {
                throw exception;
            });
        }
        catch (NessieBadRequestException ex) {
            failure = true;
            throw NessieUtil.handleBadRequestForCommit(this.client, this.key, Content.Type.ICEBERG_TABLE).orElse(ex);
        }
        finally {
            if (failure) {
                this.io().deleteFile(newMetadataLocation);
            }
        }
    }

    @Override
    public FileIO io() {
        return this.fileIO;
    }
}

