/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.auth.oauth2;

import java.net.URI;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.apache.iceberg.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Generated;
import org.projectnessie.client.auth.oauth2.DeviceCodeResponse;
import org.projectnessie.client.auth.oauth2.JacksonSerializers;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="DeviceCodeResponse", generator="Immutables")
@Immutable
public final class ImmutableDeviceCodeResponse
implements DeviceCodeResponse {
    private final String deviceCode;
    private final String userCode;
    private final URI verificationUri;
    @Nullable
    private final URI verificationUriComplete;
    private final Duration expiresIn;
    @Nullable
    private final Duration interval;

    private ImmutableDeviceCodeResponse(String deviceCode, String userCode, URI verificationUri, @Nullable URI verificationUriComplete, Duration expiresIn, @Nullable Duration interval) {
        this.deviceCode = deviceCode;
        this.userCode = userCode;
        this.verificationUri = verificationUri;
        this.verificationUriComplete = verificationUriComplete;
        this.expiresIn = expiresIn;
        this.interval = interval;
    }

    @Override
    @JsonProperty(value="device_code")
    public String getDeviceCode() {
        return this.deviceCode;
    }

    @Override
    @JsonProperty(value="user_code")
    public String getUserCode() {
        return this.userCode;
    }

    @Override
    @JsonProperty(value="verification_uri")
    public URI getVerificationUri() {
        return this.verificationUri;
    }

    @Override
    @JsonProperty(value="verification_uri_complete")
    @Nullable
    public URI getVerificationUriComplete() {
        return this.verificationUriComplete;
    }

    @Override
    @JsonProperty(value="expires_in")
    @JsonSerialize(using=JacksonSerializers.DurationToSecondsSerializer.class)
    @JsonDeserialize(using=JacksonSerializers.SecondsToDurationDeserializer.class)
    public Duration getExpiresIn() {
        return this.expiresIn;
    }

    @Override
    @JsonProperty(value="interval")
    @JsonSerialize(using=JacksonSerializers.DurationToSecondsSerializer.class)
    @JsonDeserialize(using=JacksonSerializers.SecondsToDurationDeserializer.class)
    @Nullable
    public Duration getInterval() {
        return this.interval;
    }

    public final ImmutableDeviceCodeResponse withDeviceCode(String value) {
        String newValue = Objects.requireNonNull(value, "deviceCode");
        if (this.deviceCode.equals(newValue)) {
            return this;
        }
        return new ImmutableDeviceCodeResponse(newValue, this.userCode, this.verificationUri, this.verificationUriComplete, this.expiresIn, this.interval);
    }

    public final ImmutableDeviceCodeResponse withUserCode(String value) {
        String newValue = Objects.requireNonNull(value, "userCode");
        if (this.userCode.equals(newValue)) {
            return this;
        }
        return new ImmutableDeviceCodeResponse(this.deviceCode, newValue, this.verificationUri, this.verificationUriComplete, this.expiresIn, this.interval);
    }

    public final ImmutableDeviceCodeResponse withVerificationUri(URI value) {
        if (this.verificationUri == value) {
            return this;
        }
        URI newValue = Objects.requireNonNull(value, "verificationUri");
        return new ImmutableDeviceCodeResponse(this.deviceCode, this.userCode, newValue, this.verificationUriComplete, this.expiresIn, this.interval);
    }

    public final ImmutableDeviceCodeResponse withVerificationUriComplete(@Nullable URI value) {
        if (this.verificationUriComplete == value) {
            return this;
        }
        return new ImmutableDeviceCodeResponse(this.deviceCode, this.userCode, this.verificationUri, value, this.expiresIn, this.interval);
    }

    public final ImmutableDeviceCodeResponse withExpiresIn(Duration value) {
        if (this.expiresIn == value) {
            return this;
        }
        Duration newValue = Objects.requireNonNull(value, "expiresIn");
        return new ImmutableDeviceCodeResponse(this.deviceCode, this.userCode, this.verificationUri, this.verificationUriComplete, newValue, this.interval);
    }

    public final ImmutableDeviceCodeResponse withInterval(@Nullable Duration value) {
        if (this.interval == value) {
            return this;
        }
        return new ImmutableDeviceCodeResponse(this.deviceCode, this.userCode, this.verificationUri, this.verificationUriComplete, this.expiresIn, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDeviceCodeResponse && this.equalTo(0, (ImmutableDeviceCodeResponse)another);
    }

    private boolean equalTo(int synthetic, ImmutableDeviceCodeResponse another) {
        return this.deviceCode.equals(another.deviceCode) && this.userCode.equals(another.userCode) && this.verificationUri.equals(another.verificationUri) && Objects.equals(this.verificationUriComplete, another.verificationUriComplete) && this.expiresIn.equals(another.expiresIn) && Objects.equals(this.interval, another.interval);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.deviceCode.hashCode();
        h2 += (h2 << 5) + this.userCode.hashCode();
        h2 += (h2 << 5) + this.verificationUri.hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.verificationUriComplete);
        h2 += (h2 << 5) + this.expiresIn.hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.interval);
        return h2;
    }

    public String toString() {
        return "DeviceCodeResponse{deviceCode=" + this.deviceCode + ", userCode=" + this.userCode + ", verificationUri=" + this.verificationUri + ", verificationUriComplete=" + this.verificationUriComplete + ", expiresIn=" + this.expiresIn + ", interval=" + this.interval + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableDeviceCodeResponse fromJson(Json json) {
        Builder builder = ImmutableDeviceCodeResponse.builder();
        if (json.deviceCode != null) {
            builder.deviceCode(json.deviceCode);
        }
        if (json.userCode != null) {
            builder.userCode(json.userCode);
        }
        if (json.verificationUri != null) {
            builder.verificationUri(json.verificationUri);
        }
        if (json.verificationUriComplete != null) {
            builder.verificationUriComplete(json.verificationUriComplete);
        }
        if (json.expiresIn != null) {
            builder.expiresIn(json.expiresIn);
        }
        if (json.interval != null) {
            builder.interval(json.interval);
        }
        return builder.build();
    }

    public static ImmutableDeviceCodeResponse copyOf(DeviceCodeResponse instance) {
        if (instance instanceof ImmutableDeviceCodeResponse) {
            return (ImmutableDeviceCodeResponse)instance;
        }
        return ImmutableDeviceCodeResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DeviceCodeResponse", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_DEVICE_CODE = 1L;
        private static final long INIT_BIT_USER_CODE = 2L;
        private static final long INIT_BIT_VERIFICATION_URI = 4L;
        private static final long INIT_BIT_EXPIRES_IN = 8L;
        private long initBits = 15L;
        @Nullable
        private String deviceCode;
        @Nullable
        private String userCode;
        @Nullable
        private URI verificationUri;
        @Nullable
        private URI verificationUriComplete;
        @Nullable
        private Duration expiresIn;
        @Nullable
        private Duration interval;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(DeviceCodeResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.deviceCode(instance.getDeviceCode());
            this.userCode(instance.getUserCode());
            this.verificationUri(instance.getVerificationUri());
            URI verificationUriCompleteValue = instance.getVerificationUriComplete();
            if (verificationUriCompleteValue != null) {
                this.verificationUriComplete(verificationUriCompleteValue);
            }
            this.expiresIn(instance.getExpiresIn());
            Duration intervalValue = instance.getInterval();
            if (intervalValue != null) {
                this.interval(intervalValue);
            }
            return this;
        }

        @JsonProperty(value="device_code")
        @CanIgnoreReturnValue
        public final Builder deviceCode(String deviceCode) {
            this.deviceCode = Objects.requireNonNull(deviceCode, "deviceCode");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="user_code")
        @CanIgnoreReturnValue
        public final Builder userCode(String userCode) {
            this.userCode = Objects.requireNonNull(userCode, "userCode");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="verification_uri")
        @CanIgnoreReturnValue
        public final Builder verificationUri(URI verificationUri) {
            this.verificationUri = Objects.requireNonNull(verificationUri, "verificationUri");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="verification_uri_complete")
        @CanIgnoreReturnValue
        public final Builder verificationUriComplete(@Nullable URI verificationUriComplete) {
            this.verificationUriComplete = verificationUriComplete;
            return this;
        }

        @JsonProperty(value="expires_in")
        @JsonSerialize(using=JacksonSerializers.DurationToSecondsSerializer.class)
        @JsonDeserialize(using=JacksonSerializers.SecondsToDurationDeserializer.class)
        @CanIgnoreReturnValue
        public final Builder expiresIn(Duration expiresIn) {
            this.expiresIn = Objects.requireNonNull(expiresIn, "expiresIn");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="interval")
        @JsonSerialize(using=JacksonSerializers.DurationToSecondsSerializer.class)
        @JsonDeserialize(using=JacksonSerializers.SecondsToDurationDeserializer.class)
        @CanIgnoreReturnValue
        public final Builder interval(@Nullable Duration interval) {
            this.interval = interval;
            return this;
        }

        public ImmutableDeviceCodeResponse build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDeviceCodeResponse(this.deviceCode, this.userCode, this.verificationUri, this.verificationUriComplete, this.expiresIn, this.interval);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("deviceCode");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("userCode");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("verificationUri");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("expiresIn");
            }
            return "Cannot build DeviceCodeResponse, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="DeviceCodeResponse", generator="Immutables")
    static final class Json
    implements DeviceCodeResponse {
        @Nullable
        String deviceCode;
        @Nullable
        String userCode;
        @Nullable
        URI verificationUri;
        @Nullable
        URI verificationUriComplete;
        @Nullable
        Duration expiresIn;
        @Nullable
        Duration interval;

        Json() {
        }

        @JsonProperty(value="device_code")
        public void setDeviceCode(String deviceCode) {
            this.deviceCode = deviceCode;
        }

        @JsonProperty(value="user_code")
        public void setUserCode(String userCode) {
            this.userCode = userCode;
        }

        @JsonProperty(value="verification_uri")
        public void setVerificationUri(URI verificationUri) {
            this.verificationUri = verificationUri;
        }

        @JsonProperty(value="verification_uri_complete")
        public void setVerificationUriComplete(@Nullable URI verificationUriComplete) {
            this.verificationUriComplete = verificationUriComplete;
        }

        @JsonProperty(value="expires_in")
        @JsonSerialize(using=JacksonSerializers.DurationToSecondsSerializer.class)
        @JsonDeserialize(using=JacksonSerializers.SecondsToDurationDeserializer.class)
        public void setExpiresIn(Duration expiresIn) {
            this.expiresIn = expiresIn;
        }

        @JsonProperty(value="interval")
        @JsonSerialize(using=JacksonSerializers.DurationToSecondsSerializer.class)
        @JsonDeserialize(using=JacksonSerializers.SecondsToDurationDeserializer.class)
        public void setInterval(@Nullable Duration interval) {
            this.interval = interval;
        }

        @Override
        public String getDeviceCode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUserCode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI getVerificationUri() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI getVerificationUriComplete() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Duration getExpiresIn() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Duration getInterval() {
            throw new UnsupportedOperationException();
        }
    }
}

