/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.hive;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.iceberg.CatalogProperties;
import org.apache.iceberg.ClientPool;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.hive.HiveClientPool;
import org.apache.iceberg.hive.ImmutableConfElement;
import org.apache.iceberg.hive.ImmutableKey;
import org.apache.iceberg.relocated.com.google.common.annotations.VisibleForTesting;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.shaded.com.github.benmanes.caffeine.cache.Cache;
import org.apache.iceberg.shaded.com.github.benmanes.caffeine.cache.Caffeine;
import org.apache.iceberg.shaded.com.github.benmanes.caffeine.cache.Scheduler;
import org.apache.iceberg.util.PropertyUtil;
import org.apache.iceberg.util.ThreadPools;
import org.apache.thrift.TException;
import org.immutables.value.Value;

public class CachedClientPool
implements ClientPool<IMetaStoreClient, TException> {
    private static final String CONF_ELEMENT_PREFIX = "conf:";
    private static Cache<Key, HiveClientPool> clientPoolCache;
    private final Configuration conf;
    private final int clientPoolSize;
    private final long evictionInterval;
    private final Key key;

    CachedClientPool(Configuration conf, Map<String, String> properties) {
        this.conf = conf;
        this.clientPoolSize = PropertyUtil.propertyAsInt(properties, "clients", 2);
        this.evictionInterval = PropertyUtil.propertyAsLong(properties, "client.pool.cache.eviction-interval-ms", CatalogProperties.CLIENT_POOL_CACHE_EVICTION_INTERVAL_MS_DEFAULT);
        this.key = CachedClientPool.extractKey(properties.get("client-pool-cache-keys"), conf);
        this.init();
    }

    @VisibleForTesting
    HiveClientPool clientPool() {
        return clientPoolCache.get(this.key, k -> new HiveClientPool(this.clientPoolSize, this.conf));
    }

    private synchronized void init() {
        if (clientPoolCache == null) {
            clientPoolCache = Caffeine.newBuilder().expireAfterAccess(this.evictionInterval, TimeUnit.MILLISECONDS).removalListener((ignored, value, cause) -> ((HiveClientPool)value).close()).scheduler(Scheduler.forScheduledExecutorService(ThreadPools.newScheduledPool("hive-metastore-cleaner", 1))).build();
        }
    }

    @VisibleForTesting
    static Cache<Key, HiveClientPool> clientPoolCache() {
        return clientPoolCache;
    }

    @Override
    public <R> R run(ClientPool.Action<R, IMetaStoreClient, TException> action) throws TException, InterruptedException {
        return this.clientPool().run(action);
    }

    @Override
    public <R> R run(ClientPool.Action<R, IMetaStoreClient, TException> action, boolean retry) throws TException, InterruptedException {
        return this.clientPool().run(action, retry);
    }

    @VisibleForTesting
    static Key extractKey(String cacheKeys, Configuration conf) {
        ArrayList<Object> elements = Lists.newArrayList();
        elements.add(conf.get(HiveConf.ConfVars.METASTOREURIS.varname, ""));
        elements.add(conf.get("metastore.catalog.default", "hive"));
        if (cacheKeys == null || cacheKeys.isEmpty()) {
            return Key.of(elements);
        }
        TreeSet<KeyElementType> types = Sets.newTreeSet(Comparator.comparingInt(Enum::ordinal));
        TreeMap<String, String> confElements = Maps.newTreeMap();
        block11: for (String element : cacheKeys.split(",", -1)) {
            String trimmed = element.trim();
            if (trimmed.toLowerCase(Locale.ROOT).startsWith(CONF_ELEMENT_PREFIX)) {
                String key = trimmed.substring(CONF_ELEMENT_PREFIX.length());
                ValidationException.check(!confElements.containsKey(key), "Conf key element %s already specified", key);
                confElements.put(key, conf.get(key));
                continue;
            }
            KeyElementType type = KeyElementType.valueOf(trimmed.toUpperCase());
            switch (type) {
                case UGI: 
                case USER_NAME: {
                    ValidationException.check(!types.contains((Object)type), "%s key element already specified", type.name());
                    types.add(type);
                    continue block11;
                }
                default: {
                    throw new ValidationException("Unknown key element %s", trimmed);
                }
            }
        }
        block12: for (KeyElementType type : types) {
            switch (type) {
                case UGI: {
                    try {
                        elements.add(UserGroupInformation.getCurrentUser());
                        continue block12;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                case USER_NAME: {
                    try {
                        elements.add(UserGroupInformation.getCurrentUser().getUserName());
                        continue block12;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
            }
            throw new RuntimeException("Unexpected key element " + type.name());
        }
        for (String key : confElements.keySet()) {
            elements.add(ConfElement.of(key, (String)confElements.get(key)));
        }
        return Key.of(elements);
    }

    private static enum KeyElementType {
        UGI,
        USER_NAME,
        CONF;

    }

    @Value.Immutable
    static abstract class ConfElement {
        ConfElement() {
        }

        abstract String key();

        @Nullable
        abstract String value();

        static ConfElement of(String key, String value) {
            return ImmutableConfElement.builder().key(key).value(value).build();
        }
    }

    @Value.Immutable
    static abstract class Key {
        Key() {
        }

        abstract List<Object> elements();

        private static Key of(Iterable<?> elements) {
            return ImmutableKey.builder().elements(elements).build();
        }
    }
}

