/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iceberg.PartitionStatisticsFile;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.UpdatePartitionStatistics;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;

public class SetPartitionStatistics
implements UpdatePartitionStatistics {
    private final TableOperations ops;
    private final Map<Long, PartitionStatisticsFile> statsToSet = Maps.newHashMap();
    private final Set<Long> statsToRemove = Sets.newHashSet();

    public SetPartitionStatistics(TableOperations ops) {
        this.ops = ops;
    }

    @Override
    public UpdatePartitionStatistics setPartitionStatistics(PartitionStatisticsFile file) {
        Preconditions.checkArgument(null != file, "partition statistics file must not be null");
        this.statsToSet.put(file.snapshotId(), file);
        return this;
    }

    @Override
    public UpdatePartitionStatistics removePartitionStatistics(long snapshotId) {
        this.statsToRemove.add(snapshotId);
        return this;
    }

    @Override
    public List<PartitionStatisticsFile> apply() {
        return this.internalApply(this.ops.current()).partitionStatisticsFiles();
    }

    @Override
    public void commit() {
        TableMetadata base = this.ops.current();
        TableMetadata newMetadata = this.internalApply(base);
        this.ops.commit(base, newMetadata);
    }

    private TableMetadata internalApply(TableMetadata base) {
        TableMetadata.Builder builder = TableMetadata.buildFrom(base);
        this.statsToSet.values().forEach(builder::setPartitionStatistics);
        this.statsToRemove.forEach(builder::removePartitionStatistics);
        return builder.build();
    }
}

