/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.aliyun.oss;

import com.aliyun.oss.OSS;
import org.apache.iceberg.aliyun.AliyunProperties;
import org.apache.iceberg.aliyun.oss.BaseOSSFile;
import org.apache.iceberg.aliyun.oss.OSSInputFile;
import org.apache.iceberg.aliyun.oss.OSSOutputStream;
import org.apache.iceberg.aliyun.oss.OSSURI;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.io.PositionOutputStream;
import org.apache.iceberg.metrics.MetricsContext;

class OSSOutputFile
extends BaseOSSFile
implements OutputFile {
    OSSOutputFile(OSS client, OSSURI uri, AliyunProperties aliyunProperties, MetricsContext metrics) {
        super(client, uri, aliyunProperties, metrics);
    }

    static OSSOutputFile fromLocation(OSS client, String location, AliyunProperties aliyunProperties) {
        return new OSSOutputFile(client, new OSSURI(location), aliyunProperties, MetricsContext.nullMetrics());
    }

    @Override
    public PositionOutputStream create() {
        if (!this.exists()) {
            return this.createOrOverwrite();
        }
        throw new AlreadyExistsException("Location already exists: %s", this.uri());
    }

    @Override
    public PositionOutputStream createOrOverwrite() {
        return new OSSOutputStream(this.client(), this.uri(), this.aliyunProperties(), this.metrics());
    }

    @Override
    public InputFile toInputFile() {
        return new OSSInputFile(this.client(), this.uri(), this.aliyunProperties(), this.metrics());
    }
}

