/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.avro;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.Schema;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.avro.AvroWithPartnerVisitor;
import org.apache.iceberg.avro.SupportsCustomRecords;
import org.apache.iceberg.avro.SupportsRowPosition;
import org.apache.iceberg.avro.ValueReader;
import org.apache.iceberg.avro.ValueReaders;
import org.apache.iceberg.common.DynClasses;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.shaded.org.apache.avro.LogicalType;
import org.apache.iceberg.shaded.org.apache.avro.LogicalTypes;
import org.apache.iceberg.shaded.org.apache.avro.Schema;
import org.apache.iceberg.shaded.org.apache.avro.generic.IndexedRecord;
import org.apache.iceberg.shaded.org.apache.avro.io.DatumReader;
import org.apache.iceberg.shaded.org.apache.avro.io.Decoder;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.Pair;

public class GenericAvroReader<T>
implements DatumReader<T>,
SupportsRowPosition,
SupportsCustomRecords {
    private final Types.StructType expectedType;
    private ClassLoader loader = Thread.currentThread().getContextClassLoader();
    private Map<String, String> renames = ImmutableMap.of();
    private Map<Integer, ?> idToConstant = ImmutableMap.of();
    private org.apache.iceberg.shaded.org.apache.avro.Schema fileSchema = null;
    private ValueReader<T> reader = null;

    public static <D> GenericAvroReader<D> create(Schema schema) {
        return new GenericAvroReader(schema);
    }

    public static <D> GenericAvroReader<D> create(org.apache.iceberg.shaded.org.apache.avro.Schema schema) {
        return new GenericAvroReader(schema);
    }

    GenericAvroReader(Schema readSchema) {
        this.expectedType = readSchema.asStruct();
    }

    GenericAvroReader(org.apache.iceberg.shaded.org.apache.avro.Schema readSchema) {
        this.expectedType = AvroSchemaUtil.convert(readSchema).asStructType();
    }

    private void initReader() {
        this.reader = (ValueReader)AvroWithPartnerVisitor.visit(this.expectedType, this.fileSchema, new ResolvingReadBuilder(this.expectedType, this.fileSchema.getFullName()), AvroWithPartnerVisitor.FieldIDAccessors.get());
    }

    @Override
    public void setSchema(org.apache.iceberg.shaded.org.apache.avro.Schema schema) {
        this.fileSchema = schema;
        this.initReader();
    }

    @Override
    public void setClassLoader(ClassLoader newClassLoader) {
        this.loader = newClassLoader;
    }

    @Override
    public void setRenames(Map<String, String> renames) {
        this.renames = renames;
    }

    @Override
    public void setRowPositionSupplier(Supplier<Long> posSupplier) {
        if (this.reader instanceof SupportsRowPosition) {
            ((SupportsRowPosition)((Object)this.reader)).setRowPositionSupplier(posSupplier);
        }
    }

    @Override
    public T read(T reuse, Decoder decoder) throws IOException {
        return this.reader.read(decoder, reuse);
    }

    private class ResolvingReadBuilder
    extends AvroWithPartnerVisitor<Type, ValueReader<?>> {
        private final Map<Type, org.apache.iceberg.shaded.org.apache.avro.Schema> avroSchemas;

        private ResolvingReadBuilder(Types.StructType expectedType, String rootName) {
            this.avroSchemas = AvroSchemaUtil.convertTypes(expectedType, rootName);
        }

        @Override
        public ValueReader<?> record(Type partner, org.apache.iceberg.shaded.org.apache.avro.Schema record, List<ValueReader<?>> fieldResults) {
            Types.StructType expected = partner != null ? partner.asStructType() : null;
            Map<Integer, Integer> idToPos = this.idToPos(expected);
            ArrayList<Pair<Integer, ValueReader<?>>> readPlan = Lists.newArrayList();
            List<Schema.Field> fileFields = record.getFields();
            for (int pos = 0; pos < fileFields.size(); ++pos) {
                Schema.Field field = fileFields.get(pos);
                ValueReader<?> fieldReader = fieldResults.get(pos);
                Integer fieldId = AvroSchemaUtil.fieldId(field);
                Integer projectionPos = idToPos.remove(fieldId);
                Object constant = GenericAvroReader.this.idToConstant.get(fieldId);
                if (projectionPos != null && constant != null) {
                    readPlan.add(Pair.of(projectionPos, ValueReaders.replaceWithConstant(fieldReader, constant)));
                    continue;
                }
                readPlan.add(Pair.of(projectionPos, fieldReader));
            }
            for (Map.Entry<Integer, Integer> idAndPos : idToPos.entrySet()) {
                int fieldId = idAndPos.getKey();
                int pos = idAndPos.getValue();
                Object constant = GenericAvroReader.this.idToConstant.get(fieldId);
                Types.NestedField field = expected.field(fieldId);
                if (constant != null) {
                    readPlan.add(Pair.of(pos, ValueReaders.constant(constant)));
                    continue;
                }
                if (fieldId == MetadataColumns.IS_DELETED.fieldId()) {
                    readPlan.add(Pair.of(pos, ValueReaders.constant(false)));
                    continue;
                }
                if (fieldId == MetadataColumns.ROW_POSITION.fieldId()) {
                    readPlan.add(Pair.of(pos, ValueReaders.positions()));
                    continue;
                }
                if (field.isOptional()) {
                    readPlan.add(Pair.of(pos, ValueReaders.constant(null)));
                    continue;
                }
                throw new IllegalArgumentException(String.format("Missing required field: %s", field.name()));
            }
            return this.recordReader(readPlan, this.avroSchemas.get(partner), record.getFullName());
        }

        private ValueReader<?> recordReader(List<Pair<Integer, ValueReader<?>>> readPlan, org.apache.iceberg.shaded.org.apache.avro.Schema avroSchema, String recordName) {
            String className = GenericAvroReader.this.renames.getOrDefault(recordName, recordName);
            if (className != null) {
                try {
                    Class recordClass = DynClasses.builder().loader(GenericAvroReader.this.loader).impl(className).buildChecked();
                    if (IndexedRecord.class.isAssignableFrom(recordClass)) {
                        return ValueReaders.record(avroSchema, recordClass, readPlan);
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            return ValueReaders.record(avroSchema, readPlan);
        }

        @Override
        public ValueReader<?> union(Type partner, org.apache.iceberg.shaded.org.apache.avro.Schema union, List<ValueReader<?>> options) {
            return ValueReaders.union(options);
        }

        @Override
        public ValueReader<?> arrayMap(Type partner, org.apache.iceberg.shaded.org.apache.avro.Schema map, ValueReader<?> keyReader, ValueReader<?> valueReader) {
            if (keyReader == ValueReaders.utf8s()) {
                return ValueReaders.arrayMap(ValueReaders.strings(), valueReader);
            }
            return ValueReaders.arrayMap(keyReader, valueReader);
        }

        @Override
        public ValueReader<?> array(Type partner, org.apache.iceberg.shaded.org.apache.avro.Schema array, ValueReader<?> elementReader) {
            return ValueReaders.array(elementReader);
        }

        @Override
        public ValueReader<?> map(Type partner, org.apache.iceberg.shaded.org.apache.avro.Schema map, ValueReader<?> valueReader) {
            return ValueReaders.map(ValueReaders.strings(), valueReader);
        }

        @Override
        public ValueReader<?> primitive(Type partner, org.apache.iceberg.shaded.org.apache.avro.Schema primitive) {
            LogicalType logicalType = primitive.getLogicalType();
            if (logicalType != null) {
                switch (logicalType.getName()) {
                    case "date": {
                        return ValueReaders.ints();
                    }
                    case "time-micros": {
                        return ValueReaders.longs();
                    }
                    case "timestamp-millis": {
                        ValueReader<Long> longs = ValueReaders.longs();
                        return (decoder, ignored) -> (Long)longs.read(decoder, null) * 1000L;
                    }
                    case "timestamp-micros": {
                        return ValueReaders.longs();
                    }
                    case "decimal": {
                        return ValueReaders.decimal(ValueReaders.decimalBytesReader(primitive), ((LogicalTypes.Decimal)logicalType).getScale());
                    }
                    case "uuid": {
                        return ValueReaders.uuids();
                    }
                }
                throw new IllegalArgumentException("Unknown logical type: " + logicalType);
            }
            switch (primitive.getType()) {
                case NULL: {
                    return ValueReaders.nulls();
                }
                case BOOLEAN: {
                    return ValueReaders.booleans();
                }
                case INT: {
                    if (partner != null && partner.typeId() == Type.TypeID.LONG) {
                        return ValueReaders.intsAsLongs();
                    }
                    return ValueReaders.ints();
                }
                case LONG: {
                    return ValueReaders.longs();
                }
                case FLOAT: {
                    if (partner != null && partner.typeId() == Type.TypeID.DOUBLE) {
                        return ValueReaders.floatsAsDoubles();
                    }
                    return ValueReaders.floats();
                }
                case DOUBLE: {
                    return ValueReaders.doubles();
                }
                case STRING: {
                    return ValueReaders.utf8s();
                }
                case FIXED: {
                    return ValueReaders.fixed(primitive);
                }
                case BYTES: {
                    return ValueReaders.byteBuffers();
                }
                case ENUM: {
                    return ValueReaders.enums(primitive.getEnumSymbols());
                }
            }
            throw new IllegalArgumentException("Unsupported type: " + primitive);
        }

        private Map<Integer, Integer> idToPos(Types.StructType struct) {
            HashMap<Integer, Integer> idToPos = Maps.newHashMap();
            if (struct != null) {
                List<Types.NestedField> fields = struct.fields();
                for (int pos = 0; pos < fields.size(); ++pos) {
                    Types.NestedField field = fields.get(pos);
                    idToPos.put(field.fieldId(), pos);
                }
            }
            return idToPos;
        }
    }
}

