/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.aws.s3.signer;

import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.aws.s3.signer.ImmutableS3SignRequest;
import org.apache.iceberg.aws.s3.signer.S3SignRequest;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.shaded.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.apache.iceberg.util.JsonUtil;

public class S3SignRequestParser {
    private static final String REGION = "region";
    private static final String METHOD = "method";
    private static final String URI = "uri";
    private static final String HEADERS = "headers";
    private static final String PROPERTIES = "properties";
    private static final String BODY = "body";

    private S3SignRequestParser() {
    }

    public static String toJson(S3SignRequest request) {
        return S3SignRequestParser.toJson(request, false);
    }

    public static String toJson(S3SignRequest request, boolean pretty) {
        return JsonUtil.generate(gen -> S3SignRequestParser.toJson(request, gen), pretty);
    }

    public static void toJson(S3SignRequest request, JsonGenerator gen) throws IOException {
        Preconditions.checkArgument(null != request, "Invalid s3 sign request: null");
        gen.writeStartObject();
        gen.writeStringField(REGION, request.region());
        gen.writeStringField(METHOD, request.method());
        gen.writeStringField(URI, request.uri().toString());
        S3SignRequestParser.headersToJson(HEADERS, request.headers(), gen);
        if (!request.properties().isEmpty()) {
            JsonUtil.writeStringMap(PROPERTIES, request.properties(), gen);
        }
        if (request.body() != null && !request.body().isEmpty()) {
            gen.writeStringField(BODY, request.body());
        }
        gen.writeEndObject();
    }

    public static S3SignRequest fromJson(String json) {
        return JsonUtil.parse(json, S3SignRequestParser::fromJson);
    }

    public static S3SignRequest fromJson(JsonNode json) {
        Preconditions.checkArgument(null != json, "Cannot parse s3 sign request from null object");
        Preconditions.checkArgument(json.isObject(), "Cannot parse s3 sign request from non-object: %s", (Object)json);
        String region = JsonUtil.getString(REGION, json);
        String method = JsonUtil.getString(METHOD, json);
        URI uri = java.net.URI.create(JsonUtil.getString(URI, json));
        Map<String, List<String>> headers = S3SignRequestParser.headersFromJson(HEADERS, json);
        ImmutableS3SignRequest.Builder builder = ImmutableS3SignRequest.builder().region(region).method(method).uri(uri).headers(headers);
        if (json.has(PROPERTIES)) {
            builder.properties(JsonUtil.getStringMap(PROPERTIES, json));
        }
        if (json.has(BODY)) {
            builder.body(JsonUtil.getString(BODY, json));
        }
        return builder.build();
    }

    static void headersToJson(String property, Map<String, List<String>> headers, JsonGenerator gen) throws IOException {
        gen.writeObjectFieldStart(property);
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            gen.writeFieldName(entry.getKey());
            gen.writeStartArray();
            for (String val : entry.getValue()) {
                gen.writeString(val);
            }
            gen.writeEndArray();
        }
        gen.writeEndObject();
    }

    static Map<String, List<String>> headersFromJson(String property, JsonNode json) {
        HashMap<String, List<String>> headers = Maps.newHashMap();
        JsonNode headersNode = JsonUtil.get(property, json);
        headersNode.fields().forEachRemaining(entry -> {
            String key = (String)entry.getKey();
            List<String> values = Arrays.asList(JsonUtil.getStringArray((JsonNode)entry.getValue()));
            headers.put(key, values);
        });
        return headers;
    }
}

