/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.source.reader;

import java.io.Serializable;
import java.util.Comparator;
import java.util.concurrent.TimeUnit;
import org.apache.flink.annotation.Internal;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.Schema;
import org.apache.iceberg.flink.source.reader.SplitWatermarkExtractor;
import org.apache.iceberg.flink.source.split.IcebergSourceSplit;
import org.apache.iceberg.relocated.com.google.common.annotations.VisibleForTesting;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.types.Conversions;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

@Internal
public class ColumnStatsWatermarkExtractor
implements SplitWatermarkExtractor,
Serializable {
    private final int eventTimeFieldId;
    private final String eventTimeFieldName;
    private final TimeUnit timeUnit;

    public ColumnStatsWatermarkExtractor(Schema schema, String eventTimeFieldName, TimeUnit timeUnit) {
        Types.NestedField field = schema.findField(eventTimeFieldName);
        Type.TypeID typeID = field.type().typeId();
        Preconditions.checkArgument(typeID.equals((Object)Type.TypeID.LONG) || typeID.equals((Object)Type.TypeID.TIMESTAMP), "Found %s, expected a LONG or TIMESTAMP column for watermark generation.", (Object)typeID);
        this.eventTimeFieldId = field.fieldId();
        this.eventTimeFieldName = eventTimeFieldName;
        this.timeUnit = typeID.equals((Object)Type.TypeID.LONG) ? timeUnit : TimeUnit.MICROSECONDS;
    }

    @VisibleForTesting
    ColumnStatsWatermarkExtractor(int eventTimeFieldId, String eventTimeFieldName) {
        this.eventTimeFieldId = eventTimeFieldId;
        this.eventTimeFieldName = eventTimeFieldName;
        this.timeUnit = TimeUnit.MICROSECONDS;
    }

    @Override
    public long extractWatermark(IcebergSourceSplit split) {
        return split.task().files().stream().map(scanTask -> {
            Preconditions.checkArgument(((DataFile)scanTask.file()).lowerBounds() != null && ((DataFile)scanTask.file()).lowerBounds().get(this.eventTimeFieldId) != null, "Missing statistics for column name = %s in file = %s", (Object)this.eventTimeFieldName, (Object)this.eventTimeFieldId, scanTask.file());
            return this.timeUnit.toMillis((Long)Conversions.fromByteBuffer(Types.LongType.get(), ((DataFile)scanTask.file()).lowerBounds().get(this.eventTimeFieldId)));
        }).min(Comparator.comparingLong(l -> l)).get();
    }
}

