/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.orc;

import java.util.List;
import java.util.Optional;
import org.apache.iceberg.orc.ORCSchemaUtil;
import org.apache.iceberg.orc.OrcSchemaVisitor;
import org.apache.iceberg.shaded.org.apache.orc.TypeDescription;

public class EstimateOrcAvgWidthVisitor
extends OrcSchemaVisitor<Integer> {
    @Override
    public Integer record(TypeDescription record, List<String> names, List<Integer> fieldWidths) {
        return fieldWidths.stream().reduce(Integer::sum).orElse(0);
    }

    @Override
    public Integer list(TypeDescription array, Integer elementWidth) {
        return elementWidth;
    }

    @Override
    public Integer map(TypeDescription map, Integer keyWidth, Integer valueWidth) {
        return keyWidth + valueWidth;
    }

    @Override
    public Integer primitive(TypeDescription primitive) {
        Optional<Integer> icebergIdOpt = ORCSchemaUtil.icebergID(primitive);
        if (!icebergIdOpt.isPresent()) {
            return 0;
        }
        switch (primitive.getCategory()) {
            case BYTE: 
            case CHAR: 
            case SHORT: 
            case INT: 
            case FLOAT: 
            case BOOLEAN: 
            case LONG: 
            case DOUBLE: 
            case DATE: {
                return 8;
            }
            case TIMESTAMP: 
            case TIMESTAMP_INSTANT: {
                return 12;
            }
            case STRING: 
            case VARCHAR: 
            case BINARY: {
                return 128;
            }
            case DECIMAL: {
                return primitive.getPrecision() + 2;
            }
        }
        throw new IllegalArgumentException("Can't handle " + primitive);
    }
}

