/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.shaded.org.apache.orc.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.crypto.key.KeyProviderFactory;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.hdfs.client.HdfsDataOutputStream;
import org.apache.hadoop.io.compress.snappy.SnappyDecompressor;
import org.apache.hadoop.io.compress.zlib.ZlibDecompressor;
import org.apache.iceberg.shaded.org.apache.orc.EncryptionAlgorithm;
import org.apache.iceberg.shaded.org.apache.orc.impl.HadoopShims;
import org.apache.iceberg.shaded.org.apache.orc.impl.KeyProvider;
import org.apache.iceberg.shaded.org.apache.orc.impl.KeyProviderImpl;
import org.apache.iceberg.shaded.org.apache.orc.impl.NullKeyProvider;
import org.apache.iceberg.shaded.org.apache.orc.impl.SnappyDirectDecompressWrapper;
import org.apache.iceberg.shaded.org.apache.orc.impl.ZeroCopyShims;
import org.apache.iceberg.shaded.org.apache.orc.impl.ZlibDirectDecompressWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopShimsCurrent
implements HadoopShims {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopShimsCurrent.class);

    static HadoopShims.DirectDecompressor getDecompressor(HadoopShims.DirectCompressionType codec) {
        switch (codec) {
            case ZLIB: {
                return new ZlibDirectDecompressWrapper(new ZlibDecompressor.ZlibDirectDecompressor());
            }
            case ZLIB_NOHEADER: {
                return new ZlibDirectDecompressWrapper(new ZlibDecompressor.ZlibDirectDecompressor(ZlibDecompressor.CompressionHeader.NO_HEADER, 0));
            }
            case SNAPPY: {
                return new SnappyDirectDecompressWrapper(new SnappyDecompressor.SnappyDirectDecompressor());
            }
        }
        return null;
    }

    static EncryptionAlgorithm findAlgorithm(KeyProvider.Metadata meta) {
        String cipher = meta.getCipher();
        if (cipher.startsWith("AES/")) {
            int bitLength = meta.getBitLength();
            if (bitLength == 128) {
                return EncryptionAlgorithm.AES_CTR_128;
            }
            if (bitLength != 256) {
                LOG.info("ORC column encryption does not support " + bitLength + " bit keys. Using 256 bits instead.");
            }
            return EncryptionAlgorithm.AES_CTR_256;
        }
        throw new IllegalArgumentException("ORC column encryption only supports AES and not " + cipher);
    }

    static String buildKeyVersionName(HadoopShims.KeyMetadata key) {
        return key.getKeyName() + "@" + key.getVersion();
    }

    static KeyProvider createKeyProvider(Configuration conf, Random random) throws IOException {
        List result = KeyProviderFactory.getProviders((Configuration)conf);
        if (result.size() == 0) {
            LOG.debug("Can't get KeyProvider for ORC encryption from hadoop.security.key.provider.path.");
            return new NullKeyProvider();
        }
        return new KeyProviderImpl((org.apache.hadoop.crypto.key.KeyProvider)result.get(0), random);
    }

    @Override
    public HadoopShims.DirectDecompressor getDirectDecompressor(HadoopShims.DirectCompressionType codec) {
        return HadoopShimsCurrent.getDecompressor(codec);
    }

    @Override
    public HadoopShims.ZeroCopyReaderShim getZeroCopyReader(FSDataInputStream in, HadoopShims.ByteBufferPoolShim pool) throws IOException {
        return ZeroCopyShims.getZeroCopyReader(in, pool);
    }

    @Override
    public boolean endVariableLengthBlock(OutputStream output) throws IOException {
        if (output instanceof HdfsDataOutputStream) {
            HdfsDataOutputStream hdfs = (HdfsDataOutputStream)output;
            hdfs.hsync(EnumSet.of(HdfsDataOutputStream.SyncFlag.END_BLOCK));
            return true;
        }
        return false;
    }

    @Override
    public KeyProvider getHadoopKeyProvider(Configuration conf, Random random) throws IOException {
        return HadoopShimsCurrent.createKeyProvider(conf, random);
    }
}

