/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.shaded.org.threeten.extra;

import java.io.Serializable;
import java.time.DateTimeException;
import java.time.Period;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalUnit;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.iceberg.shaded.org.threeten.extra.Temporals;
import org.joda.convert.FromString;
import org.joda.convert.ToString;

public final class Weeks
implements TemporalAmount,
Comparable<Weeks>,
Serializable {
    public static final Weeks ZERO = new Weeks(0);
    public static final Weeks ONE = new Weeks(1);
    private static final long serialVersionUID = -8903767091325669093L;
    private static final Pattern PATTERN = Pattern.compile("([-+]?)P([-+]?[0-9]+)W", 2);
    private final int weeks;

    public static Weeks of(int weeks) {
        if (weeks == 0) {
            return ZERO;
        }
        if (weeks == 1) {
            return ONE;
        }
        return new Weeks(weeks);
    }

    public static Weeks from(TemporalAmount amount) {
        if (amount instanceof Weeks) {
            return (Weeks)amount;
        }
        Objects.requireNonNull(amount, "amount");
        int weeks = 0;
        for (TemporalUnit unit : amount.getUnits()) {
            long value = amount.get(unit);
            if (value == 0L) continue;
            long[] converted = Temporals.convertAmount(value, unit, ChronoUnit.WEEKS);
            if (converted[1] != 0L) {
                throw new DateTimeException("Amount could not be converted to a whole number of weeks: " + value + " " + unit);
            }
            weeks = Math.addExact(weeks, Math.toIntExact(converted[0]));
        }
        return Weeks.of(weeks);
    }

    @FromString
    public static Weeks parse(CharSequence text) {
        Objects.requireNonNull(text, "text");
        Matcher matcher = PATTERN.matcher(text);
        if (matcher.matches()) {
            int negate = "-".equals(matcher.group(1)) ? -1 : 1;
            String str = matcher.group(2);
            try {
                int val = Integer.parseInt(str);
                return Weeks.of(Math.multiplyExact(val, negate));
            }
            catch (NumberFormatException ex) {
                throw new DateTimeParseException("Text cannot be parsed to a Weeks", text, 0, ex);
            }
        }
        throw new DateTimeParseException("Text cannot be parsed to a Weeks", text, 0);
    }

    public static Weeks between(Temporal startDateInclusive, Temporal endDateExclusive) {
        return Weeks.of(Math.toIntExact(ChronoUnit.WEEKS.between(startDateInclusive, endDateExclusive)));
    }

    private Weeks(int weeks) {
        this.weeks = weeks;
    }

    private Object readResolve() {
        return Weeks.of(this.weeks);
    }

    @Override
    public long get(TemporalUnit unit) {
        if (unit == ChronoUnit.WEEKS) {
            return this.weeks;
        }
        throw new UnsupportedTemporalTypeException("Unsupported unit: " + unit);
    }

    @Override
    public List<TemporalUnit> getUnits() {
        return Collections.singletonList(ChronoUnit.WEEKS);
    }

    public int getAmount() {
        return this.weeks;
    }

    public boolean isNegative() {
        return this.getAmount() < 0;
    }

    public boolean isZero() {
        return this.getAmount() == 0;
    }

    public boolean isPositive() {
        return this.getAmount() > 0;
    }

    public Weeks plus(TemporalAmount amountToAdd) {
        return this.plus(Weeks.from(amountToAdd).getAmount());
    }

    public Weeks plus(int weeks) {
        if (weeks == 0) {
            return this;
        }
        return Weeks.of(Math.addExact(this.weeks, weeks));
    }

    public Weeks minus(TemporalAmount amountToSubtract) {
        return this.minus(Weeks.from(amountToSubtract).getAmount());
    }

    public Weeks minus(int weeks) {
        if (weeks == 0) {
            return this;
        }
        return Weeks.of(Math.subtractExact(this.weeks, weeks));
    }

    public Weeks multipliedBy(int scalar) {
        if (scalar == 1) {
            return this;
        }
        return Weeks.of(Math.multiplyExact(this.weeks, scalar));
    }

    public Weeks dividedBy(int divisor) {
        if (divisor == 1) {
            return this;
        }
        return Weeks.of(this.weeks / divisor);
    }

    public Weeks negated() {
        return this.multipliedBy(-1);
    }

    public Weeks abs() {
        return this.weeks < 0 ? this.negated() : this;
    }

    public Period toPeriod() {
        return Period.ofWeeks(this.weeks);
    }

    @Override
    public Temporal addTo(Temporal temporal) {
        if (this.weeks != 0) {
            temporal = temporal.plus(this.weeks, ChronoUnit.WEEKS);
        }
        return temporal;
    }

    @Override
    public Temporal subtractFrom(Temporal temporal) {
        if (this.weeks != 0) {
            temporal = temporal.minus(this.weeks, ChronoUnit.WEEKS);
        }
        return temporal;
    }

    @Override
    public int compareTo(Weeks otherAmount) {
        int thisValue = this.weeks;
        int otherValue = otherAmount.weeks;
        return Integer.compare(thisValue, otherValue);
    }

    public boolean equals(Object otherAmount) {
        if (this == otherAmount) {
            return true;
        }
        if (otherAmount instanceof Weeks) {
            Weeks other = (Weeks)otherAmount;
            return this.weeks == other.weeks;
        }
        return false;
    }

    public int hashCode() {
        return this.weeks;
    }

    @ToString
    public String toString() {
        return "P" + this.weeks + "W";
    }
}

