/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.util;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.util.ByteBuffers;

public class ZOrderByteUtils {
    public static final int PRIMITIVE_BUFFER_SIZE = 8;

    private ZOrderByteUtils() {
    }

    static ByteBuffer allocatePrimitiveBuffer() {
        return ByteBuffer.allocate(8);
    }

    public static ByteBuffer intToOrderedBytes(int val, ByteBuffer reuse) {
        ByteBuffer bytes = ByteBuffers.reuse(reuse, 8);
        bytes.putLong((long)val ^ Long.MIN_VALUE);
        return bytes;
    }

    public static ByteBuffer longToOrderedBytes(long val, ByteBuffer reuse) {
        ByteBuffer bytes = ByteBuffers.reuse(reuse, 8);
        bytes.putLong(val ^ Long.MIN_VALUE);
        return bytes;
    }

    public static ByteBuffer shortToOrderedBytes(short val, ByteBuffer reuse) {
        return ZOrderByteUtils.intToOrderedBytes(val, reuse);
    }

    public static ByteBuffer tinyintToOrderedBytes(byte val, ByteBuffer reuse) {
        return ZOrderByteUtils.intToOrderedBytes(val, reuse);
    }

    public static ByteBuffer floatToOrderedBytes(float val, ByteBuffer reuse) {
        return ZOrderByteUtils.doubleToOrderedBytes(val, reuse);
    }

    public static ByteBuffer doubleToOrderedBytes(double val, ByteBuffer reuse) {
        ByteBuffer bytes = ByteBuffers.reuse(reuse, 8);
        long lval = Double.doubleToLongBits(val);
        lval ^= lval >> 31 | Long.MIN_VALUE;
        bytes.putLong(lval);
        return bytes;
    }

    public static ByteBuffer stringToOrderedBytes(String val, int length, ByteBuffer reuse, CharsetEncoder encoder) {
        Preconditions.checkArgument(encoder.charset().equals(StandardCharsets.UTF_8), "Cannot use an encoder not using UTF_8 as it's Charset");
        ByteBuffer bytes = ByteBuffers.reuse(reuse, length);
        Arrays.fill(bytes.array(), 0, length, (byte)0);
        if (val != null) {
            CharBuffer inputBuffer = CharBuffer.wrap(val);
            encoder.encode(inputBuffer, bytes, true);
        }
        return bytes;
    }

    public static ByteBuffer byteTruncateOrFill(byte[] val, int length, ByteBuffer reuse) {
        ByteBuffer bytes = ByteBuffers.reuse(reuse, length);
        if (val == null) {
            Arrays.fill(bytes.array(), 0, length, (byte)0);
            return bytes;
        }
        if (val.length < length) {
            bytes.put(val, 0, val.length);
            Arrays.fill(bytes.array(), val.length, length, (byte)0);
        } else {
            bytes.put(val, 0, length);
        }
        return bytes;
    }

    static byte[] interleaveBits(byte[][] columnsBinary, int interleavedSize) {
        return ZOrderByteUtils.interleaveBits(columnsBinary, interleavedSize, ByteBuffer.allocate(interleavedSize));
    }

    public static byte[] interleaveBits(byte[][] columnsBinary, int interleavedSize, ByteBuffer reuse) {
        byte[] interleavedBytes = reuse.array();
        Arrays.fill(interleavedBytes, 0, interleavedSize, (byte)0);
        int sourceColumn = 0;
        int sourceByte = 0;
        int sourceBit = 7;
        int interleaveByte = 0;
        int interleaveBit = 7;
        while (interleaveByte < interleavedSize) {
            int n = interleaveByte++;
            interleavedBytes[n] = (byte)(interleavedBytes[n] | (columnsBinary[sourceColumn][sourceByte] & 1 << sourceBit) >>> sourceBit << interleaveBit);
            if (--interleaveBit == -1) {
                interleaveBit = 7;
            }
            if (interleaveByte == interleavedSize) break;
            do {
                if (++sourceColumn != columnsBinary.length) continue;
                sourceColumn = 0;
                if (--sourceBit != -1) continue;
                ++sourceByte;
                sourceBit = 7;
            } while (columnsBinary[sourceColumn].length <= sourceByte);
        }
        return interleavedBytes;
    }
}

